#ifndef _SubtitleFormat_h
#define _SubtitleFormat_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <glibmm.h>
#include "Document.h"
#include <exception>

/*
 *
 */
class SubtitleException : public std::exception
{
public:
	SubtitleException(const char *classname, const char *msg)
	:m_classname(classname), m_msg(msg)
	{
	}

	virtual ~SubtitleException() throw()
	{
	}

	const char* classname() const throw()
	{
		return m_classname.c_str();
	}

	virtual const char* what() const throw()
	{
		return m_msg.c_str();
	}

private:
	std::string m_classname;
	std::string m_msg;
};


/*
 *
 */
class SubtitleFormat
{
public:

	SubtitleFormat();
	virtual ~SubtitleFormat();

	/*
	 *
	 */
	void set_charset(const std::string &charset);

	/*
	 *
	 */
	std::string get_charset();

	
	/*
	 *	encoding "" pour auto ou "UTF-8", ...
	 */
	virtual bool open(const Glib::ustring &filename, const Glib::ustring &encoding);
	
	/*
	 *	encoding "" pour auto ou "UTF-8", ...
	 */
	virtual bool save(const Glib::ustring &filename, const Glib::ustring &encoding);

	/*
	 *	convertir text en utf8
	 *	le charset du text est defini par m_charset
	 */
	Glib::ustring charset_to_utf8(const std::string &text);

	/*
	 *	convertir le text (utf-8) en codage defini par m_charset
	 */
	std::string utf8_to_charset(const Glib::ustring &text);


protected:
	/*
	 *	represente le charset utiliser pour la lecture (charset -> utf8) 
	 *	ou la sauvegarde (utf8 -> charset)
	 */
	std::string	m_charset;

	/*
	 *
	 */
	SubtitleColumnRecorder	m_column;

private:
	std::list<Glib::ustring> m_list_encodings;
	bool	m_use_auto_deteced;
};


#endif//_SubtitleFormat_h
