/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "SubtitleText.h"
#include <iostream>
#include <fstream>
#include "utility.h"

/*
 *
 */
SubtitleText::SubtitleText(Document *doc)
{
	m_subtitleModel = doc->m_subtitleModel;
}

/*
 *
 */
SubtitleText::~SubtitleText()
{
}


/*
 *
 */
bool SubtitleText::open(const Glib::ustring &filename, const Glib::ustring &encoding)
{
	debug_msg("SubtitleText::open > start");
	
	SubtitleFormat::open(filename, encoding);
	
	std::ifstream file(filename.c_str());
	if(!file)
	{
		return false;
	}

	SubtitleColumnRecorder column;
	std::string line;

	while(!file.eof() && std::getline(file, line))
	{
		if(line !="")
		{
			Gtk::TreeIter it = m_subtitleModel->append();
			(*it)[column.text] = check_end_char(charset_to_utf8(line));
		}
	}
	file.close();

	debug_msg("SubtitleText::open > finish");
	return true;
}

/*
 *
 */
bool SubtitleText::save(const Glib::ustring &filename, const Glib::ustring &encoding)
{
	debug_msg("SubtitleText::save > start");

	SubtitleFormat::save(filename, encoding);
	
	std::ofstream file(filename.c_str());
	if(!file)
	{
		return false;
	}

	SubtitleColumnRecorder column;
	Gtk::TreeIter it = m_subtitleModel->getFirst();
	Glib::ustring line;

	for(; it; ++it)
	{
#warning "fixme: on laisse | ou on utilise \n ?"

		file << utf8_to_charset((*it)[column.text]);
		file << std::endl;
	}
	file.close();

	debug_msg("SubtitleText::save > finish");
	return true;
}
