/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <iostream>
#include <gtkmm/main.h>
#include <gtkmm/window.h>
#include <gtkmm/table.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/box.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/dialog.h>
#include <gtkmm/label.h>

#include "SubtitleView.h"
#include "SubtitleEditor.h"

#include <glibmm/spawn.h>

#include <glibmm.h>

#include <gtkmm/liststore.h>
#include <gtkmm/stock.h>

#include "ASpell.h"
#include "SpellDialog.h"
#include <config.h>

#include "SubtitleSSA.h"
#include "utility.h"
#include "Config.h"

#include <locale.h>

#include "Waveform.h"



/*
 *
 */
class SubtitleOption : public Glib::OptionGroup
{
public:
	SubtitleOption();

public:
	Glib::ustring	m_subtitlefile;
	Glib::ustring m_moviefile;
	bool m_maximize;
};

/*
 *
 */
SubtitleOption::SubtitleOption()
:Glib::OptionGroup("subtitleeditor", "description ....", "help...")
{
	m_maximize = false;

	Glib::OptionEntry entry1;
	entry1.set_long_name("maximize");
	entry1.set_description("Maximize window");
	add_entry(entry1, m_maximize);

	Glib::OptionEntry entry2;
	entry2.set_long_name("sub");
	entry2.set_short_name('s');
	entry2.set_description("The subtitle file");
	add_entry(entry2, m_subtitlefile);

	Glib::OptionEntry entry3;
	entry3.set_long_name("movie");
	entry3.set_short_name('m');
	entry3.set_description("The movie file");
	add_entry(entry3, m_moviefile);
}

/*
 *
 */
void check_default_config()
{
	debug_msg("check_default_config");

	Config &cfg = Config::getInstance();

	/*
	 * piti check... ~/.subtitleeditor
	 */
	Glib::ustring path_se = Glib::build_filename(Glib::get_home_dir(), ".subtitleeditor");
	if(Glib::file_test(path_se, Glib::FILE_TEST_IS_DIR) == false)
	{
		Glib::ustring cmd = "mkdir " + path_se;
		system(cmd.c_str());
	}

	/*
	 *	GENERAL
	 */
	if(!cfg.has_key("general", "maximize"))
		cfg.set_value_bool("general", "maximize", false);


	/*
	 *	ENCODINGS
	 */
	if(!cfg.has_key("encodings", "default"))
		cfg.set_value_string("encodings", "encodings", "ISO-8859-15;UTF-8;");

	if(!cfg.has_key("encodings", "default"))
	{
		std::string def;
		if(!Glib::get_charset(def))
			def="UTF-8";

		cfg.set_value_string("encodings", "default", def);
	}

	if(!cfg.has_key("encodings", "used-auto-detected"))
		cfg.set_value_bool("encodings", "used-auto-detected", true);

	/*
	 *	VIDEO-PLAYER
	 */
	
	if(!cfg.has_key("video-player", "default"))
	{
		//cfg.set_comment("video-player", "video-player", "blablabla");
		
		cfg.set_value_string("video-player", "default", "mplayer");

		cfg.set_value_string("video-player", "mplayer", 
				"mplayer \"#video_file\" -sub \"#subtitle_file\" -ss #seconds -osdlevel 2");
		
		cfg.set_value_string("video-player", "vlc", 
				"vlc \"#video_file\" --sub-file=\"#subtitle_file\" --start-time=#seconds");
	
		//cfg.set_value_string("video-player", "gstreamer", 
		//		"gst-launch playbin uri=\"#video_uri\" subfile=\"#subtitle_uri\" subtitle-font-desc=\"Comic Sans MS Bold 20\"");
	}
	else
	{
		// TODO enlever.
		// un patch pour le passage 0.8.1 -> 0.9
		std::list<Glib::ustring> keys;
		if(cfg.get_keys("video-player", keys))
		{
			Glib::ustring cmd;
			
			std::list<Glib::ustring>::const_iterator it;
			for(it = keys.begin(); it != keys.end(); ++it)
			{
				if((*it) == "default")
					continue;
				
				if(cfg.get_value_string("video-player", *it, cmd))
				{
					if(cmd.find("#msecs") != Glib::ustring::npos)
					{
						find_and_replace(cmd, "#msecs", "#seconds");
						cfg.set_value_string("video-player", *it, cmd);
					}
				}
			}
		}
	}

	/*
	 *	TIMING-SYSTEM
	 */

	if(!cfg.has_key("timing-system", "audio-sink"))
		cfg.set_value_string("timing-system", "audio-sink", "autoaudiosink");
	
	if(!cfg.has_key("timing-system", "video-sink"))
		cfg.set_value_string("timing-system", "video-sink", "ximagesink");
}

void format_rgb(const unsigned int rgb[3])
{
	g_print("%02X%02X%02X\n", rgb[0], rgb[1], rgb[2]);
}

/*
 *
 */
int main(int argc, char *argv[])
{
	/*
	{
		unsigned int rgb[]={255,255,0};

		format_rgb(rgb);
		
		return 0;
	}
	*/
	debug_msg("subtitleeditor "VERSION);
	
	bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain(PACKAGE);

	debug_msg("init Gtk+");
	
	Gtk::Main kit(argc, argv);

	g_set_application_name("subtitleeditor");

	debug_msg("init gstreamer");
	
	gst_init(&argc,&argv);

	debug_msg("check .subtitleeditor");
	
	check_default_config();

	debug_msg("create SubtitleEditor instance");

	SubtitleEditor* editor = SubtitleEditor::getInstance();	


	debug_msg("SubtitleOption");
	
	try
	{
		SubtitleOption options;
		Glib::OptionContext context;

		context.set_main_group(options);
		context.parse(argc, argv);

		if(!options.m_subtitlefile.empty())
			editor->open_subtitle(options.m_subtitlefile);

		if(!options.m_moviefile.empty())
			editor->open_movie(options.m_moviefile);

		if(options.m_maximize)
			editor->maximize();
	}
	catch(const Glib::Error &ex)
	{
		std::cerr << "SubtitleEditor::Exception: " << ex.what() << std::endl;
		delete editor;
		return 1;
	}


	debug_msg(message("run"));

	kit.run(*editor);

	debug_msg(message("delete subtitleeditor"));
	
	delete editor;

	return 0;
}

