#ifndef _utility_h
#define _utility_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <glibmm/ustring.h>
#include <gdkmm/color.h>
#include <sstream>
#include <iostream>



#ifdef ENABLE_NLS
#include <libintl.h>
#define _(String) gettext(String)
#ifdef gettext_noop
#define N_(String) gettext_noop(String)
#else
#define N_(String) (String)
#endif
#else /* NLS is disabled */
#define _(String) (String)
#define N_(String) (String)
#define textdomain(String) (String)
#define gettext(String) (String)
#define dgettext(Domain,String) (String)
#define dcgettext(Domain,String,Type) (String)
#define bindtextdomain(Domain,Directory) (Domain) 
#define bind_textdomain_codeset(Domain,Codeset) (Codeset) 
#endif /* ENABLE_NLS */

void find_and_replace(Glib::ustring &text, const Glib::ustring &find, const Glib::ustring &replace);

/*
 *
 */
Glib::ustring get_share_dir(const Glib::ustring &file);


/*
 *
 */
Glib::ustring check_end_char(const Glib::ustring &str);


/*
 *	convertir str en n'importe quel type
 */
template<class T>
bool from_string(const std::string &src, T& dest)
{
	std::istringstream s(src);
	// return s >> dest != 0;

	bool state = s >> dest != 0;

	g_return_val_if_fail(state, false);

	return true;
}

/*
 *
 */
template<class T>
bool from_string(const Glib::ustring &src, T& dest)
{
	std::istringstream s(src);
	// return s >> dest != 0;

	bool state = s >> dest != 0;

	g_return_val_if_fail(state, false);

	return true;
}

/*
 *	convertir n'importe quoi en string
 */
template<class T>
std::string to_string(const T &src)
{
	std::ostringstream oss;
	oss << src;
	
	return oss.str();
}


void dialog_warning(const Glib::ustring &primary_text, const Glib::ustring &secondary_text);
void dialog_error(const Glib::ustring &primary_text, const Glib::ustring &secondary_text);



/*
 *	DEBUG
 */

Glib::ustring message(const char *format, ...);

void debug(const char *key, const Glib::ustring &msg);

#ifdef DEBUG_MSG
	#define debug_msg(msg) debug(__PRETTY_FUNCTION__, msg);
#else//DEBUG_MSG
	#define debug_msg(msg)
#endif//DEBUG_MSG


#include <regex.h>

/*
 *
 */
class RegEx
{
public:
	RegEx(const std::string &ex, int flag = REG_EXTENDED | REG_NEWLINE);
	~RegEx();

	bool exec(const std::string &string);
	bool exec(const std::string &string, std::string::size_type &start, std::string::size_type &len);

protected:
	int m_err;
	regex_t m_rx;
};

#endif//_utility_h
