#ifndef _DialogChangeFPS_h
#define _DialogChangeFPS_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <libglademm/xml.h>
#include <gtkmm/dialog.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/comboboxentrytext.h>
#include "utility.h"


class DialogChangeFPS : public Gtk::Dialog
{
	/*
	 *
	 */
	class ComboBoxEntryText : public Gtk::ComboBoxEntryText
	{
	public:
		ComboBoxEntryText(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade)
		:Gtk::ComboBoxEntryText(cobject)
		{
			get_entry()->signal_focus_out_event().connect(
					sigc::mem_fun(*this, &ComboBoxEntryText::on_focus_out));
		}

		void append_text(const Glib::ustring &text)
		{
			Gtk::TreeNodeChildren rows = get_model()->children();
			
			Gtk::ComboBoxEntryText::TextModelColumns m_columns;

			for(Gtk::TreeIter it = rows.begin(); it; ++it)
			{
				if((*it)[m_columns.m_column] == text)
				{
					set_active(it);
					return;
				}
			}

			Gtk::ComboBoxEntryText::append_text(text);
		}

		bool on_focus_out(GdkEventFocus* ev)
		{
			bool state = true;//get_entry()->on_focus_out_event(ev);

			Glib::ustring text = get_entry()->get_text();

			double value = 0;
			if(from_string(text, value))
			{
				if(value > 0)
					append_text(to_string(value));
				else
					set_active(0);
			}
			else
				set_active(0);

			return state;
		}
	};

public:
	DialogChangeFPS(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);

	void execute();
protected:
	double	get_source();
	double	get_dest();

	void combo_activate(ComboBoxEntryText *combo);

protected:

	/*
	 *	modification du fps de time src->dest
	 */
	SubtitleTime change_fps(const SubtitleTime &time, double src_fps, double dest_fps);

	/*
	 *	applique le changement de FPS au document
	 */
	void changeFPS(const double &src_fps, const double&dest_fps);

protected:
	ComboBoxEntryText* m_comboSrc;
	ComboBoxEntryText* m_comboDest;
};

#endif//_DialogChangeFPS_h
