/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "MenuBar.h"
#include "utility.h"
#include <iostream>
#include "SubtitleEditor.h"


MenuBar::MenuBar(Gtk::Window &window)
:Gtk::VBox(false, 0)
{
	Glib::RefPtr<Gtk::ActionGroup> m_refActionGroupTiming;
	
	SubtitleEditor *instance = SubtitleEditor::getInstance();
	
	m_refActionGroup = Gtk::ActionGroup::create();
	
	m_refActionGroupTiming = Gtk::ActionGroup::create("timing-system");

#define SIGNAL(callback) sigc::mem_fun(instance, &SubtitleEditor::callback)
#define SIGNAL_THIS(callback) sigc::mem_fun(this, &MenuBar::callback)

	// menu-file
	m_refActionGroup->add(Gtk::Action::create("menu-file", _("_File")));
	m_refActionGroup->add(Gtk::Action::create("new-subtitle", Gtk::Stock::NEW), SIGNAL(on_new_subtitle));
	m_refActionGroup->add(Gtk::Action::create("open-subtitle", Gtk::Stock::OPEN, _("_Open Subtitle")), SIGNAL(on_open_subtitle));
	m_refActionGroup->add(Gtk::Action::create("save-subtitle", Gtk::Stock::SAVE, _("_Save Subtitle")), SIGNAL(on_save_subtitle));
	m_refActionGroup->add(Gtk::Action::create("save-as-subtitle", Gtk::Stock::SAVE_AS, _("Save As Subtitle")), SIGNAL(on_save_as_subtitle));
	m_refActionGroup->add(Gtk::Action::create("properties", _("Properties")), SIGNAL(on_properties));
	m_refActionGroup->add(Gtk::Action::create("import-text", _("Import Text")), SIGNAL(on_import_text));
	m_refActionGroup->add(Gtk::Action::create("export-text", _("Export Text")), SIGNAL(on_export_text));
	m_refActionGroup->add(Gtk::Action::create("quit", Gtk::Stock::QUIT), SIGNAL(on_quit));
	
	// menu-option
	m_refActionGroup->add(Gtk::Action::create("menu-option", _("_Options")));
	m_refActionGroup->add(Gtk::Action::create("preferences", Gtk::Stock::PREFERENCES), SIGNAL(on_preferences));

	
	// menu-view
	m_refActionGroup->add(Gtk::Action::create("menu-view", _("_View")));
	
	m_refActionGroup->add(Gtk::Action::create("setup-view-simple", _("Simple")), SIGNAL_THIS(on_setup_view_simple));
	m_refActionGroup->add(Gtk::Action::create("setup-view-advanced", _("Advanced")), SIGNAL_THIS(on_setup_view_advanced));
	m_refActionGroup->add(Gtk::Action::create("setup-view-translation", _("Translation")), SIGNAL_THIS(on_setup_view_translation));
	m_refActionGroup->add(Gtk::Action::create("setup-view-timing", _("Timing")), SIGNAL_THIS(on_setup_view_timing));

	// menu-columns
	m_refActionGroup->add(Gtk::Action::create("menu-columns", _("Columns")));

#define SIGNAL_COLUMN(column) sigc::bind<Glib::ustring>(sigc::mem_fun(this, &MenuBar::on_toggle_column), column)
	
	m_refActionGroup->add(Gtk::ToggleAction::create("number", _("Number")), SIGNAL_COLUMN("number"));
	m_refActionGroup->add(Gtk::ToggleAction::create("layer", _("Layer")), SIGNAL_COLUMN("layer"));
	m_refActionGroup->add(Gtk::ToggleAction::create("start", _("Start")), SIGNAL_COLUMN("start"));
	m_refActionGroup->add(Gtk::ToggleAction::create("end", _("End")), SIGNAL_COLUMN("end"));
	m_refActionGroup->add(Gtk::ToggleAction::create("duration", _("Duration")), SIGNAL_COLUMN("duration"));
	m_refActionGroup->add(Gtk::ToggleAction::create("style", _("Style")), SIGNAL_COLUMN("style"));
	m_refActionGroup->add(Gtk::ToggleAction::create("name", _("Name")), SIGNAL_COLUMN("name"));
	m_refActionGroup->add(Gtk::ToggleAction::create("margin-r", _("Margin Left")), SIGNAL_COLUMN("margin-r"));
	m_refActionGroup->add(Gtk::ToggleAction::create("margin-l", _("Margin Right")), SIGNAL_COLUMN("margin-l"));
	m_refActionGroup->add(Gtk::ToggleAction::create("margin-v", _("Margin Vertical")), SIGNAL_COLUMN("margin-v"));
	m_refActionGroup->add(Gtk::ToggleAction::create("effect", _("Effect")), SIGNAL_COLUMN("effect"));
	m_refActionGroup->add(Gtk::ToggleAction::create("text", _("Text")), SIGNAL_COLUMN("text"));
	m_refActionGroup->add(Gtk::ToggleAction::create("translation", _("Translation")), SIGNAL_COLUMN("translation"));
	m_refActionGroup->add(Gtk::ToggleAction::create("characters-per-line", _("Characters Per Line")), SIGNAL_COLUMN("characters-per-line"));

#undef SIGNAL_COLUMN

	// menu-edit
	m_refActionGroup->add(Gtk::Action::create("menu-edit", _("_Edit")));

	m_refActionGroup->add(Gtk::Action::create("select-previous-subtitle", Gtk::Stock::GO_BACK,
				_("Select Previous Subtitle")),	SIGNAL(on_select_previous_subtitle));
	m_refActionGroup->add(Gtk::Action::create("select-next-subtitle", Gtk::Stock::GO_FORWARD,
				_("Select Next Subtitle")),	SIGNAL(on_select_next_subtitle));

	m_refActionGroup->add(Gtk::Action::create("delete-subtitle", Gtk::Stock::DELETE),
		Gtk::AccelKey(GDK_Delete, Gdk::CONTROL_MASK), SIGNAL(on_delete_subtitle));

	m_refActionGroup->add(Gtk::Action::create("insert-before", Gtk::Stock::GOTO_BOTTOM, _("Insert Before")),
		Gtk::AccelKey(GDK_Insert, Gdk::CONTROL_MASK), SIGNAL(on_insert_before_subtitle)); 
	m_refActionGroup->add(Gtk::Action::create("insert-after", Gtk::Stock::GOTO_TOP, _("Insert After")),
		Gtk::AccelKey(GDK_Insert, (Gdk::ModifierType)0), SIGNAL(on_insert_after_subtitle));

	m_refActionGroup->add(Gtk::Action::create("menu-move", _("_Move")));

	m_refActionGroup->add(Gtk::Action::create("move-subtitles", Gtk::Stock::JUMP_TO,
				_("_Move Subtitles")),	SIGNAL(on_move_subtitles));

	m_refActionGroup->add(Gtk::Action::create("add-100-ms", Gtk::Stock::ADD,
				_("Add 100 Milliseconds")),	SIGNAL(on_add_100_ms));
	m_refActionGroup->add(Gtk::Action::create("remove-100-ms", Gtk::Stock::REMOVE,
				_("Remove 100 Milliseconds")), SIGNAL(on_remove_100_ms));

	m_refActionGroup->add(Gtk::Action::create("add-100-ms-to-start", Gtk::Stock::ADD,
				_("Add 100 Milliseconds To Start")),	SIGNAL(on_add_100_ms_to_start));
	m_refActionGroup->add(Gtk::Action::create("remove-100-ms-to-start", Gtk::Stock::REMOVE,
				_("Remove 100 Milliseconds To Start")),	SIGNAL(on_remove_100_ms_to_start));

	m_refActionGroup->add(Gtk::Action::create("add-100-ms-to-duration", Gtk::Stock::ADD,
				_("Add 100 Milliseconds To Duration")),	SIGNAL(on_add_100_ms_to_duration));
	m_refActionGroup->add(Gtk::Action::create("remove-100-ms-to-duration", Gtk::Stock::REMOVE,
				_("Remove 100 Milliseconds To Duration")),	SIGNAL(on_remove_100_ms_to_duration));

	/*
	m_refActionGroup->add(Gtk::Action::create("move-subtitle-text-forward", Gtk::Stock::GO_FORWARD,
				_("Move Subtitle Text Forward")),	SIGNAL(on_move_subtitle_text_forward));
	m_refActionGroup->add(Gtk::Action::create("move-subtitle-text-backward", Gtk::Stock::GO_BACK,
				_("Move Subtitle Text Backward")),	SIGNAL(on_move_subtitle_text_backward));
	*/

	m_refActionGroup->add(Gtk::Action::create("change-fps", Gtk::Stock::CONVERT, _("Change FPS")), SIGNAL(on_change_fps));
	m_refActionGroup->add(Gtk::Action::create("scale", Gtk::Stock::CONVERT, _("Scale")), SIGNAL(on_scale));

	// menu-tools
	m_refActionGroup->add(Gtk::Action::create("menu-tools", _("_Tools")));
	
	//m_refActionGroup->add(Gtk::Action::create("find", Gtk::Stock::FIND, _("Find")),
	//	Gtk::AccelKey('f', Gdk::CONTROL_MASK), SIGNAL(on_find));
	//m_refActionGroup->add(Gtk::Action::create("find-next", Gtk::Stock::FIND, _("Find Next")),
	//	Gtk::AccelKey('g', Gdk::CONTROL_MASK), SIGNAL(on_find_next));
	m_refActionGroup->add(Gtk::Action::create("find-and-replace", Gtk::Stock::FIND_AND_REPLACE, _("Find And Replace")),
		Gtk::AccelKey('g', Gdk::SHIFT_MASK | Gdk::CONTROL_MASK), SIGNAL(on_find_and_replace));
	
	m_refActionGroup->add(Gtk::Action::create("remove-line-empty", _("Remove Line Empty")), SIGNAL(on_remove_line_nul));

	m_refActionGroup->add(Gtk::Action::create("check-time", Gtk::Stock::YES, _("Check Time")), SIGNAL(on_check_time));
	m_refActionGroup->add(Gtk::Action::create("spell-check", Gtk::Stock::SPELL_CHECK, _("Spell Check")),
		Gtk::AccelKey('c', Gdk::MOD1_MASK), SIGNAL(on_spell_check)); 
	
	m_refActionGroup->add(Gtk::Action::create("set-all-end-time", _("Set All End Time")), SIGNAL(on_set_all_end_time));
	m_refActionGroup->add(Gtk::Action::create("style-editor", _("Style Editor")), 
			Gtk::AccelKey('a', Gdk::MOD1_MASK), SIGNAL(on_style_editor));

	m_refActionGroup->add(Gtk::Action::create("apply-translation", Gtk::Stock::APPLY, _("Apply Translation")), SIGNAL(on_apply_translation));

	m_refActionGroup->add(Gtk::Action::create("split", Gtk::Stock::CUT, _("Split")), SIGNAL(on_split));
	m_refActionGroup->add(Gtk::Action::create("joint", Gtk::Stock::CONNECT, _("Joint")), SIGNAL(on_joint));

	// menu-timing
	m_refActionGroup->add(Gtk::Action::create("menu-timing", _("_Timing")));
	m_refActionGroup->add(Gtk::Action::create("open-media-for-timing", Gtk::Stock::OPEN, _("Open Media")), SIGNAL(on_open_media_for_timing));

	m_refActionGroupTiming->add(Gtk::Action::create("save-waveform", Gtk::Stock::SAVE, _("Save Waveform")), SIGNAL(on_save_waveform));

	m_refActionGroupTiming->add(Gtk::Action::create("timing-play-previous-subtitle", 
				Gtk::Stock::MEDIA_PREVIOUS, _("Play Previous Subtitle")), SIGNAL(on_timing_play_previous_subtitle));
	m_refActionGroupTiming->add(Gtk::Action::create("timing-play-current-subtitle", 
				Gtk::Stock::MEDIA_PLAY, _("Play Selection")), SIGNAL(on_timing_play_current_subtitle));
	m_refActionGroupTiming->add(Gtk::Action::create("timing-play-next-subtitle", 
				Gtk::Stock::MEDIA_NEXT, _("Play Next Subtitle")), SIGNAL(on_timing_play_next_subtitle));
	m_refActionGroupTiming->add(Gtk::Action::create("timing-stop", 
				Gtk::Stock::MEDIA_STOP, _("Stop")), SIGNAL(on_timing_stop));

	m_refActionGroupTiming->add(Gtk::Action::create("timing-play-previous-second", 
			_("Play Previous Second")), SIGNAL(on_timing_play_previous_second));
	m_refActionGroupTiming->add(Gtk::Action::create("timing-play-first-second", 
			_("Play First Second")), SIGNAL(on_timing_play_first_second));
	m_refActionGroupTiming->add(Gtk::Action::create("timing-play-last-second", 
			_("Play Last Second")), SIGNAL(on_timing_play_last_second));
	m_refActionGroupTiming->add(Gtk::Action::create("timing-play-next-second", 
			_("Play Next Second")), SIGNAL(on_timing_play_next_second));

	// menu-video
	m_refActionGroup->add(Gtk::Action::create("menu-video", _("_Video")));
	m_refActionGroup->add(Gtk::Action::create("open-movie", Gtk::Stock::OPEN, _("Open Movie")),
		Gtk::AccelKey('o', Gdk::SHIFT_MASK | Gdk::CONTROL_MASK), SIGNAL(on_open_movie));
	m_refActionGroup->add(Gtk::Action::create("play-movie", Gtk::Stock::MEDIA_PLAY, _("_Play Movie")),
		Gtk::AccelKey(GDK_space, Gdk::CONTROL_MASK), SIGNAL(on_play_movie));
	//m_refActionGroupTiming->add(Gtk::Action::create("video-properties", _("Properties")), SIGNAL(on_video_properties));

	// menu-help
	m_refActionGroup->add(Gtk::Action::create("menu-help", _("_Help")));
	m_refActionGroup->add(Gtk::Action::create("about", Gtk::Stock::HELP, _("_About")), SIGNAL(on_about));

	// UIMANAGER

	m_refUIManager = Gtk::UIManager::create();
	m_refUIManager->insert_action_group(m_refActionGroup);
	m_refUIManager->insert_action_group(m_refActionGroupTiming);

	window.add_accel_group(m_refUIManager->get_accel_group());
	
	m_refUIManager->add_ui_from_file(get_share_dir("menubar.xml"));

	pack_start(*m_refUIManager->get_widget("/menubar"), false,false);

	show_all();

	//m_refActionGroupTiming->set_sensitive(false);

	init_columns_by_subtitleview();
/*
	// disable preferences
	Glib::RefPtr<Gtk::ToggleAction> action = 
		Glib::RefPtr<Gtk::ToggleAction>::cast_static(m_refActionGroup->get_action("find-next"));
	if(action)
		action->set_sensitive(false);
*/	
#undef SIGNAL
#undef SIGNAL_THIS
}

/*
 *	change l'etat d'affichage d'une colonne
 */
void MenuBar::set_toggle_column(const Glib::ustring &column, const bool &state)
{
	try
	{
		Glib::RefPtr<Gtk::ToggleAction> action = 
			Glib::RefPtr<Gtk::ToggleAction>::cast_static(m_refActionGroup->get_action(column));

		if(action)
		{
			action->set_active(state);
			SubtitleEditor::getInstance()->getSubtitleView()->set_column_visible(column, state);
		}
	}
	catch(Glib::Error &ex)
	{
		std::cerr << ex.what() << std::endl;
	}
}

/*
 *
 */
void MenuBar::on_toggle_column(const Glib::ustring &column)
{
	Glib::RefPtr<Gtk::ToggleAction> action = 
		Glib::RefPtr<Gtk::ToggleAction>::cast_static(m_refActionGroup->get_action(column));

	if(action)
	{
		bool state = action->get_active();
		SubtitleEditor::getInstance()->getSubtitleView()->set_column_visible(column, state);
	}
}

	
/*
 *
 */
void MenuBar::init_columns_by_subtitleview()
{
	gchar* columns[]={
		"number", "layer", "start", "end", "duration", "style", "name", 
		"margin-r", "margin-l", "margin-v", "effect", 
		"text", "translation", "characters-per-line", 
		NULL};

	for(unsigned int i=0; columns[i] != NULL; ++i)
	{
		bool state = SubtitleEditor::getInstance()->getSubtitleView()->get_column_visible(columns[i]);
		
		Glib::RefPtr<Gtk::ToggleAction> action = 
			Glib::RefPtr<Gtk::ToggleAction>::cast_static(m_refActionGroup->get_action(columns[i]));

		if(action)
		{
			action->set_active(state);
		}
	}
}

/*
 *
 */
void MenuBar::on_setup_view_simple()
{
	set_toggle_column("number", true);
	set_toggle_column("layer", false);
	set_toggle_column("start", true);
	set_toggle_column("end", true);
	set_toggle_column("duration", true);
	set_toggle_column("style", false);
	set_toggle_column("name", false);
	set_toggle_column("margin-r", false);
	set_toggle_column("margin-l", false);
	set_toggle_column("margin-v", false);
	set_toggle_column("effect", false);
	set_toggle_column("text", true);
	set_toggle_column("translation", false);
	set_toggle_column("characters-per-line", false);

	Signal::getInstance().setup_view("simple");
}

void MenuBar::on_setup_view_advanced()
{
	set_toggle_column("number", true);
	set_toggle_column("layer", true);
	set_toggle_column("start", true);
	set_toggle_column("end", true);
	set_toggle_column("duration", true);
	set_toggle_column("style", true);
	set_toggle_column("name", true);
	set_toggle_column("margin-r", false);
	set_toggle_column("margin-l", false);
	set_toggle_column("margin-v", false);
	set_toggle_column("effect", false);
	set_toggle_column("text", true);
	set_toggle_column("translation", false);
	set_toggle_column("characters-per-line", true);

	Signal::getInstance().setup_view("advanced");
}

void MenuBar::on_setup_view_translation()
{
	set_toggle_column("number", true);
	set_toggle_column("layer", false);
	set_toggle_column("start", false);
	set_toggle_column("end", false);
	set_toggle_column("duration", false);
	set_toggle_column("style", false);
	set_toggle_column("name", false);
	set_toggle_column("margin-r", false);
	set_toggle_column("margin-l", false);
	set_toggle_column("margin-v", false);
	set_toggle_column("effect", false);
	set_toggle_column("text", true);
	set_toggle_column("translation", true);
	set_toggle_column("characters-per-line", false);

	Signal::getInstance().setup_view("translation");
}

void MenuBar::on_setup_view_timing()
{
	set_toggle_column("number", true);
	set_toggle_column("layer", false);
	set_toggle_column("start", true);
	set_toggle_column("end", true);
	set_toggle_column("duration", true);
	set_toggle_column("style", false);
	set_toggle_column("name", false);
	set_toggle_column("margin-r", false);
	set_toggle_column("margin-l", false);
	set_toggle_column("margin-v", false);
	set_toggle_column("effect", false);
	set_toggle_column("text", true);
	set_toggle_column("translation", false);
	set_toggle_column("characters-per-line", true);

	Signal::getInstance().setup_view("timing");
}
