

/*
 *                   COPYRIGHT (c) 1988-1994 BY                             *
 *        PARADIGM ASSOCIATES INCORPORATED, CAMBRIDGE, MASSACHUSETTS.       *
 *        See the source file SLIB.C for more information.                  *

 Array-hacking code moved to another source file.

 */
/*
  removed base64 functions (Oct-03) Yusuke TABATA
  removed tc_{long,double}_array
  removed fast save/load functionality
 */
#include <stdio.h>
#include <string.h>
#include <setjmp.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <math.h>

#include "siod.h"

LISP
assv (LISP x, LISP alist)
{
  LISP l, tmp;
  for (l = alist; CONSP (l); l = CDR (l))
    {
      tmp = CAR (l);
      if (CONSP (tmp) && NNULLP (eql (CAR (tmp), x)))
	return (tmp);
      INTERRUPT_CHECK ();
    }
  if EQ
    (l, NIL) return (NIL);
  return (my_err ("improper list to assv", alist));
}

long
get_c_long (LISP x)
{
  if NFLONUMP
    (x) my_err ("not a number", x);
  return ((long) FLONM (x));
}

long
nlength (LISP obj)
{
  LISP l;
  long n;
  switch TYPE
    (obj)
    {
    case tc_string:
      return (strlen (obj->storage_as.string.data));
    case tc_nil:
      return (0);
    case tc_cons:
      for (l = obj, n = 0; CONSP (l); l = CDR (l), ++n)
	INTERRUPT_CHECK ();
      if NNULLP
	(l) my_err ("improper list to length", obj);
      return (n);
    default:
      my_err ("wta to length", obj);
      return (0);
    }
}

LISP
lstrcmp (LISP s1, LISP s2)
{
  return (flocons (strcmp (get_c_string (s1), get_c_string (s2))));
}

static LISP
stringp (LISP x)
{
  return (TYPEP (x, tc_string) ? sym_t : NIL);
}

LISP
member (LISP x, LISP il)
{
  LISP l, tmp;
  for (l = il; CONSP (l); l = CDR (l))
    {
      tmp = CAR (l);
      if NNULLP
	(equal (x, tmp)) return (l);
      INTERRUPT_CHECK ();
    }
  if EQ
    (l, NIL) return (NIL);
  return (my_err ("improper list to member", il));
}

LISP
memv (LISP x, LISP il)
{
  LISP l, tmp;
  for (l = il; CONSP (l); l = CDR (l))
    {
      tmp = CAR (l);
      if NNULLP
	(eql (x, tmp)) return (l);
      INTERRUPT_CHECK ();
    }
  if EQ
    (l, NIL) return (NIL);
  return (my_err ("improper list to memv", il));
}

LISP
last (LISP l)
{
  LISP v1, v2;
  v1 = l;
  v2 = CONSP (v1) ? CDR (v1) : my_err ("bad arg to last", l);
  while (CONSP (v2))
    {
      INTERRUPT_CHECK ();
      v1 = v2;
      v2 = CDR (v2);
    }
  return (v1);
}

LISP
string_lessp (LISP s1, LISP s2)
{
  if (strcmp (get_c_string (s1), get_c_string (s2)) < 0)
    return (sym_t);
  else
    return (NIL);
}

LISP
lsubset (LISP fcn, LISP l)
{
  LISP result = NIL, v;
  for (v = l; CONSP (v); v = CDR (v))
    if NNULLP
      (funcall1 (fcn, CAR (v)))
	result = cons (CAR (v), result);
  return (nreverse (result));
}

LISP
listn (long n,...)
{
  LISP result, ptr;
  long j;
  va_list args;
  for (j = 0, result = NIL; j < n; ++j)
    result = cons (NIL, result);
  va_start (args, n);
  for (j = 0, ptr = result; j < n; ptr = cdr (ptr), ++j)
    setcar (ptr, va_arg (args, LISP));
  va_end (args);
  return (result);
}

static void
shexstr (char *outstr, void *buff, size_t len)
{
  unsigned char *data = buff;
  size_t j;
  for (j = 0; j < len; ++j)
    sprintf (&outstr[j * 2], "%02X", data[j]);
}

LISP
ltypeof (LISP obj)
{
  long x;
  x = TYPE (obj);
  switch (x)
    {
    case tc_nil:
      return (rintern ("tc_nil"));
    case tc_cons:
      return (rintern ("tc_cons"));
    case tc_flonum:
      return (rintern ("tc_flonum"));
    case tc_symbol:
      return (rintern ("tc_symbol"));
    case tc_subr_0:
      return (rintern ("tc_subr_0"));
    case tc_subr_1:
      return (rintern ("tc_subr_1"));
    case tc_subr_2:
      return (rintern ("tc_subr_2"));
    case tc_subr_2n:
      return (rintern ("tc_subr_2n"));
    case tc_subr_3:
      return (rintern ("tc_subr_3"));
    case tc_subr_4:
      return (rintern ("tc_subr_4"));
    case tc_subr_5:
      return (rintern ("tc_subr_5"));
    case tc_lsubr:
      return (rintern ("tc_lsubr"));
    case tc_fsubr:
      return (rintern ("tc_fsubr"));
    case tc_msubr:
      return (rintern ("tc_msubr"));
    case tc_closure:
      return (rintern ("tc_closure"));
    case tc_free_cell:
      return (rintern ("tc_free_cell"));
    case tc_string:
      return (rintern ("tc_string"));
    case tc_c_file:
      return (rintern ("tc_c_file"));
    default:
      return (flocons (x));
    }
}

LISP
ash (LISP value, LISP n)
{
  long m, k;
  m = get_c_long (value);
  k = get_c_long (n);
  if (k > 0)
    m = m << k;
  else
    m = m >> (-k);
  return (flocons (m));
}

LISP
leval_cond (LISP * pform, LISP * penv)
{
  LISP args, env, clause, value, next;
  args = cdr (*pform);
  env = *penv;
  if NULLP
    (args)
    {
      *pform = NIL;
      return (NIL);
    }
  next = cdr (args);
  while NNULLP
    (next)
    {
      clause = car (args);
      value = leval (car (clause), env);
      if NNULLP
	(value)
	{
	  clause = cdr (clause);
	  if NULLP
	    (clause)
	    {
	      *pform = value;
	      return (NIL);
	    }
	  else
	    {
	      next = cdr (clause);
	      while (NNULLP (next))
		{
		  leval (car (clause), env);
		  clause = next;
		  next = cdr (next);
		}
	      *pform = car (clause);
	      return (sym_t);
	    }
	}
      args = next;
      next = cdr (next);
    }
  clause = car (args);
  next = cdr (clause);
  if NULLP
    (next)
    {
      *pform = car (clause);
      return (sym_t);
    }
  value = leval (car (clause), env);
  if NULLP
    (value)
    {
      *pform = NIL;
      return (NIL);
    }
  clause = next;
  next = cdr (next);
  while (NNULLP (next))
    {
      leval (car (clause), env);
      clause = next;
      next = cdr (next);
    }
  *pform = car (clause);
  return (sym_t);
}

void
init_subrs_a (void)
{
  init_subr_2 ("assv", assv);
  init_subr_2 ("strcmp", lstrcmp);
  init_subr_1 ("string?", stringp);
  init_subr_2 ("string-lessp", string_lessp);
  init_subr_2 ("subset", lsubset);
  init_subr_1 ("typeof", ltypeof);
  init_msubr ("cond", leval_cond);
  init_subr_2 ("ash", ash);
  init_subr_1 ("last", last);
  init_subr_2 ("memv", memv);
  init_subr_2 ("member", member);
}
