/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.dracula;

import cadyts.interfaces.dracula.DraculaLink;
import cadyts.interfaces.dracula.DraculaODRelation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class DraculaRoute
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long id;
    private final DraculaODRelation od;
    private final int hashCode;
    private final ArrayList<DraculaLink> links = new ArrayList();

    DraculaRoute(long id, DraculaODRelation od) {
        if (od == null) {
            throw new IllegalArgumentException("od is null");
        }
        this.id = id;
        this.od = od;
        this.hashCode = 1 + 31 * ((int)this.id + 31 * this.od.hashCode());
    }

    void addLink(DraculaLink link) {
        if (link == null) {
            throw new IllegalArgumentException("link is null");
        }
        this.links.add(link);
    }

    void trimToSize() {
        this.links.trimToSize();
    }

    long getId() {
        return this.id;
    }

    DraculaODRelation getOD() {
        return this.od;
    }

    List<DraculaLink> getLinks() {
        return this.links;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            DraculaRoute r = (DraculaRoute)o;
            return this.id == r.id && this.od.equals(r.od);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getSimpleName());
        result.append("(id = ");
        result.append(this.id);
        result.append(", od = ");
        result.append(this.od);
        result.append(", links = ");
        result.append(this.links);
        result.append(")");
        return result.toString();
    }
}

