/*
 * Decompiled with CFR 0.152.
 */
package ui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import simulation.JobType;
import ui.dialogs.DlgAddEditJobType;

public class DlgManageJobTypes
extends JDialog {
    private static final long serialVersionUID = 1L;
    private List<JobType> jobTypes = null;
    private JButton btnDelete = null;
    private JButton btnEdit = null;
    private JButton btnNew = null;
    private JButton btnOK = null;
    private JPanel jContentPane = null;
    private JLabel lblJobTypes = null;
    private JList lstJobTypes = null;
    private JScrollPane scrlJobTypes = null;

    public DlgManageJobTypes(Frame owner, List<JobType> jobTypes) {
        super(owner);
        this.initialize();
        this.jobTypes = jobTypes;
        this.lstJobTypes.setModel(new DefaultComboBoxModel<Object>(this.jobTypes.toArray()));
        this.setVisible(true);
    }

    public List<JobType> getJobTypes() {
        return this.jobTypes;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setBounds(new Rectangle(220, 89, 99, 23));
            this.btnDelete.setEnabled(false);
            this.btnDelete.setToolTipText("Delete the currently selected job type");
            this.btnDelete.setText("Delete...");
            this.btnDelete.setHorizontalAlignment(2);
            this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/deletejobtype.png")));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgManageJobTypes.this.DeleteJobType((JobType)DlgManageJobTypes.this.lstJobTypes.getSelectedValue());
                }
            });
        }
        return this.btnDelete;
    }

    private JButton getBtnEdit() {
        if (this.btnEdit == null) {
            this.btnEdit = new JButton();
            this.btnEdit.setBounds(new Rectangle(220, 59, 99, 23));
            this.btnEdit.setEnabled(false);
            this.btnEdit.setToolTipText("Edit the currently selected job type");
            this.btnEdit.setHorizontalAlignment(2);
            this.btnEdit.setText("Edit...");
            this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/editjobtype.png")));
            this.btnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgManageJobTypes.this.EditJobType((JobType)DlgManageJobTypes.this.lstJobTypes.getSelectedValue());
                }
            });
        }
        return this.btnEdit;
    }

    private JButton getBtnNew() {
        if (this.btnNew == null) {
            this.btnNew = new JButton();
            this.btnNew.setBounds(new Rectangle(220, 27, 99, 23));
            this.btnNew.setToolTipText("Create a new job type");
            this.btnNew.setText("New...");
            this.btnNew.setHorizontalAlignment(2);
            this.btnNew.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/addjobtype.png")));
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgManageJobTypes.this.NewJobType();
                }
            });
        }
        return this.btnNew;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setBounds(new Rectangle(220, 133, 99, 23));
            this.btnOK.setText("OK");
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgManageJobTypes.this.OKClicked();
                }
            });
        }
        return this.btnOK;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.lblJobTypes = new JLabel();
            this.lblJobTypes.setBounds(new Rectangle(10, 3, 120, 21));
            this.lblJobTypes.setText("Job types:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getScrlJobTypes(), null);
            this.jContentPane.add((Component)this.lblJobTypes, null);
            this.jContentPane.add((Component)this.getBtnNew(), null);
            this.jContentPane.add((Component)this.getBtnEdit(), null);
            this.jContentPane.add((Component)this.getBtnDelete(), null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
        }
        return this.jContentPane;
    }

    private JList getLstJobTypes() {
        if (this.lstJobTypes == null) {
            this.lstJobTypes = new JList();
            this.lstJobTypes.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    DlgManageJobTypes.this.SelectedJobTypeChanged();
                }
            });
        }
        return this.lstJobTypes;
    }

    private JScrollPane getScrlJobTypes() {
        if (this.scrlJobTypes == null) {
            this.scrlJobTypes = new JScrollPane();
            this.scrlJobTypes.setBounds(new Rectangle(9, 26, 205, 132));
            this.scrlJobTypes.setViewportView(this.getLstJobTypes());
        }
        return this.scrlJobTypes;
    }

    private void initialize() {
        this.setSize(335, 199);
        this.setResizable(false);
        this.setModal(true);
        this.setTitle("Manage job types");
        this.setContentPane(this.getJContentPane());
    }

    protected void DeleteJobType(JobType type) {
        if (type.getName().equals("Default")) {
            JOptionPane.showMessageDialog(this, "The default job type can not be deleted");
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the job type " + type.getName() + "?") == 0) {
            this.jobTypes.remove(type);
            ((DefaultComboBoxModel)this.lstJobTypes.getModel()).removeElement(type);
            this.lstJobTypes.updateUI();
        }
    }

    protected void EditJobType(JobType selectedJobType) {
        DlgAddEditJobType dlg = new DlgAddEditJobType((Dialog)this, selectedJobType);
        if (dlg.getAnswer() == 0) {
            this.lstJobTypes.updateUI();
        }
    }

    protected void NewJobType() {
        DlgAddEditJobType dlg = new DlgAddEditJobType(this);
        if (dlg.getAnswer() == 0) {
            this.jobTypes.add(dlg.getJobType());
            ((DefaultComboBoxModel)this.lstJobTypes.getModel()).addElement(dlg.getJobType());
            this.lstJobTypes.updateUI();
        }
    }

    protected void OKClicked() {
        this.setVisible(false);
    }

    protected void SelectedJobTypeChanged() {
        if (this.lstJobTypes.getSelectedValues().length == 0) {
            this.btnEdit.setEnabled(false);
            this.btnDelete.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnDelete.setEnabled(true);
        }
    }
}

