/*
 * Decompiled with CFR 0.152.
 */
package ui.dialogs;

import helpers.ApplicationSettings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DlgSettings
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton btnBrowseDUARouter = null;
    private JButton btnBrowseNetConvert = null;
    private JButton btnCancel = null;
    private JButton btnOK = null;
    private JPanel jContentPane = null;
    private JLabel lblDUARouterPath = null;
    private JLabel lblNetConvertPath = null;
    private JTextField txtDUARouterPath = null;
    private JTextField txtNetConvertPath = null;

    public DlgSettings(Frame owner) {
        super(owner);
        this.initialize();
        this.txtDUARouterPath.setText(ApplicationSettings.getDUARouterPath());
        this.txtNetConvertPath.setText(ApplicationSettings.getNetConvertPath());
    }

    private JButton getBtnBrowseDUARouter() {
        if (this.btnBrowseDUARouter == null) {
            this.btnBrowseDUARouter = new JButton();
            this.btnBrowseDUARouter.setBounds(new Rectangle(444, 29, 87, 22));
            this.btnBrowseDUARouter.setText("Browse...");
            this.btnBrowseDUARouter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String selectedPath = DlgSettings.this.BrowseForFile();
                    if (selectedPath != null) {
                        DlgSettings.this.txtDUARouterPath.setText(selectedPath);
                    }
                }
            });
        }
        return this.btnBrowseDUARouter;
    }

    private JButton getBtnBrowseNetConvert() {
        if (this.btnBrowseNetConvert == null) {
            this.btnBrowseNetConvert = new JButton();
            this.btnBrowseNetConvert.setBounds(new Rectangle(444, 77, 87, 22));
            this.btnBrowseNetConvert.setText("Browse...");
            this.btnBrowseNetConvert.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String selectedPath = DlgSettings.this.BrowseForFile();
                    if (selectedPath != null) {
                        DlgSettings.this.txtNetConvertPath.setText(selectedPath);
                    }
                }
            });
        }
        return this.btnBrowseNetConvert;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setBounds(new Rectangle(458, 112, 73, 26));
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgSettings.this.setVisible(false);
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setBounds(new Rectangle(379, 112, 73, 26));
            this.btnOK.setText("OK");
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgSettings.this.SaveSettings();
                    DlgSettings.this.setVisible(false);
                }
            });
        }
        return this.btnOK;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.lblNetConvertPath = new JLabel();
            this.lblNetConvertPath.setBounds(new Rectangle(7, 58, 189, 16));
            this.lblNetConvertPath.setText("Net converter executable path:");
            this.lblDUARouterPath = new JLabel();
            this.lblDUARouterPath.setBounds(new Rectangle(7, 10, 189, 16));
            this.lblDUARouterPath.setText("DUA router executable path:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.lblDUARouterPath, null);
            this.jContentPane.add((Component)this.getTxtDUARouterPath(), null);
            this.jContentPane.add((Component)this.getBtnBrowseDUARouter(), null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
            this.jContentPane.add((Component)this.lblNetConvertPath, null);
            this.jContentPane.add((Component)this.getTxtNetConvertPath(), null);
            this.jContentPane.add((Component)this.getBtnBrowseNetConvert(), null);
        }
        return this.jContentPane;
    }

    private JTextField getTxtDUARouterPath() {
        if (this.txtDUARouterPath == null) {
            this.txtDUARouterPath = new JTextField();
            this.txtDUARouterPath.setBounds(new Rectangle(7, 31, 430, 20));
        }
        return this.txtDUARouterPath;
    }

    private JTextField getTxtNetConvertPath() {
        if (this.txtNetConvertPath == null) {
            this.txtNetConvertPath = new JTextField();
            this.txtNetConvertPath.setBounds(new Rectangle(6, 79, 430, 20));
        }
        return this.txtNetConvertPath;
    }

    private void initialize() {
        this.setSize(545, 178);
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setTitle("Settings");
        this.setContentPane(this.getJContentPane());
    }

    protected String BrowseForFile() {
        JFileChooser f = new JFileChooser();
        f.setMultiSelectionEnabled(false);
        f.setFileSelectionMode(0);
        f.setDialogTitle("Select executable");
        f.setAcceptAllFileFilterUsed(true);
        f.setApproveButtonText("Select");
        if (f.showOpenDialog(this) == 0) {
            return f.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    protected void SaveSettings() {
        File dua = new File(this.txtDUARouterPath.getText());
        File netconvert = new File(this.txtNetConvertPath.getText());
        if (!dua.exists()) {
            JOptionPane.showMessageDialog(this, "Specified file does not exist");
            return;
        }
        if (!netconvert.exists()) {
            JOptionPane.showMessageDialog(this, "Specified file does not exist");
            return;
        }
        ApplicationSettings.setDUARouterPath(this.txtDUARouterPath.getText());
        ApplicationSettings.setNetConvertPath(this.txtNetConvertPath.getText());
    }
}

