/*
 * Decompiled with CFR 0.152.
 */
package ui.propertypanels;

import enums.SchoolType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import trafficdefinition.School;
import ui.controls.SimTimeEdit;

public class PnlSchoolProperties
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox cmbType = null;
    private School currentSchool = null;
    private JLabel lblClosingTime = null;
    private JLabel lblNameTitle = null;
    private JLabel lblOpeningTime = null;
    private JLabel lblType = null;
    private SimTimeEdit steTimeClosing = null;
    private SimTimeEdit steTimeOpening = null;
    private JTextField txtName = null;
    private JCheckBox chkExportPolygon = null;
    private JCheckBox chkEnabled = null;
    private JLabel lblCapacity = null;
    private JSpinner spnCapacity = null;

    public PnlSchoolProperties() {
        this.initialize();
    }

    public void setSchool(School school) {
        this.currentSchool = school;
        this.txtName.setText(this.currentSchool.getName());
        this.steTimeOpening.setValue(this.currentSchool.getTimeOpening());
        this.steTimeClosing.setValue(this.currentSchool.getTimeClosing());
        this.cmbType.setSelectedItem((Object)this.currentSchool.getSchoolType());
        this.spnCapacity.setValue(this.currentSchool.getCapacity());
        this.chkExportPolygon.setSelected(this.currentSchool.getExportPolygon());
        this.chkEnabled.setSelected(this.currentSchool.isEnabled());
    }

    private JComboBox getCmbType() {
        if (this.cmbType == null) {
            this.cmbType = new JComboBox();
            this.cmbType.setPreferredSize(new Dimension(31, 20));
            this.cmbType.setModel(new DefaultComboBoxModel<SchoolType>(SchoolType.values()));
            this.cmbType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlSchoolProperties.this.currentSchool.setSchoolType((SchoolType)((Object)PnlSchoolProperties.this.cmbType.getSelectedItem()));
                }
            });
        }
        return this.cmbType;
    }

    private SimTimeEdit getSteTimeClosing() {
        if (this.steTimeClosing == null) {
            this.steTimeClosing = new SimTimeEdit();
            this.steTimeClosing.setPreferredSize(new Dimension(166, 45));
            this.steTimeClosing.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlSchoolProperties.this.currentSchool.setTimeClosing(PnlSchoolProperties.this.steTimeClosing.getValue());
                }
            });
        }
        return this.steTimeClosing;
    }

    private SimTimeEdit getSteTimeOpening() {
        if (this.steTimeOpening == null) {
            this.steTimeOpening = new SimTimeEdit();
            this.steTimeOpening.setPreferredSize(new Dimension(166, 45));
            this.steTimeOpening.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlSchoolProperties.this.currentSchool.setTimeOpening(PnlSchoolProperties.this.steTimeOpening.getValue());
                }
            });
        }
        return this.steTimeOpening;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PnlSchoolProperties.this.currentSchool.setName(PnlSchoolProperties.this.txtName.getText());
                }
            });
        }
        return this.txtName;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridx = 1;
        gridBagConstraints31.anchor = 18;
        gridBagConstraints31.fill = 0;
        gridBagConstraints31.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints31.gridy = 4;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.anchor = 18;
        gridBagConstraints21.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints21.weighty = 1.0;
        gridBagConstraints21.gridy = 4;
        this.lblCapacity = new JLabel();
        this.lblCapacity.setText("Capacity:");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.gridy = 5;
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 1;
        gridBagConstraints13.weighty = 1.0;
        gridBagConstraints13.anchor = 18;
        gridBagConstraints13.gridy = 6;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.insets = new Insets(3, 0, 3, 3);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 1;
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.insets = new Insets(3, 0, 3, 3);
        gridBagConstraints12.gridy = 1;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.gridy = 3;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.anchor = 11;
        gridBagConstraints6.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints6.gridx = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints5.gridy = 3;
        this.lblType = new JLabel();
        this.lblType.setText("Type:");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.insets = new Insets(3, 10, 0, 0);
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridy = 2;
        this.lblClosingTime = new JLabel();
        this.lblClosingTime.setText("ClosingTime:");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.insets = new Insets(3, 10, 0, 5);
        gridBagConstraints11.anchor = 18;
        gridBagConstraints11.gridy = 1;
        this.lblOpeningTime = new JLabel();
        this.lblOpeningTime.setText("Opening time:");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        this.lblNameTitle = new JLabel();
        this.lblNameTitle.setText("Name:");
        this.setSize(272, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblNameTitle, gridBagConstraints);
        this.add((Component)this.getTxtName(), gridBagConstraints1);
        this.add((Component)this.lblOpeningTime, gridBagConstraints11);
        this.add((Component)this.lblClosingTime, gridBagConstraints3);
        this.add((Component)this.lblType, gridBagConstraints5);
        this.add((Component)this.getCmbType(), gridBagConstraints6);
        this.add((Component)this.getSteTimeOpening(), gridBagConstraints12);
        this.add((Component)this.getSteTimeClosing(), gridBagConstraints2);
        this.add((Component)this.getChkExportPolygon(), gridBagConstraints13);
        this.add((Component)this.getChkEnabled(), gridBagConstraints7);
        this.add((Component)this.lblCapacity, gridBagConstraints21);
        this.add((Component)this.getSpnCapacity(), gridBagConstraints31);
    }

    private JCheckBox getChkExportPolygon() {
        if (this.chkExportPolygon == null) {
            this.chkExportPolygon = new JCheckBox();
            this.chkExportPolygon.setText("Export polygon");
            this.chkExportPolygon.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlSchoolProperties.this.currentSchool.setExportPolygon(PnlSchoolProperties.this.chkExportPolygon.isSelected());
                }
            });
        }
        return this.chkExportPolygon;
    }

    private JCheckBox getChkEnabled() {
        if (this.chkEnabled == null) {
            this.chkEnabled = new JCheckBox();
            this.chkEnabled.setText("Enabled");
            this.chkEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlSchoolProperties.this.currentSchool.setEnabled(PnlSchoolProperties.this.chkEnabled.isSelected());
                }
            });
        }
        return this.chkEnabled;
    }

    private JSpinner getSpnCapacity() {
        if (this.spnCapacity == null) {
            this.spnCapacity = new JSpinner();
            this.spnCapacity.setPreferredSize(new Dimension(50, 20));
            this.spnCapacity.setModel(new SpinnerNumberModel(1, 1, 10000, 1));
            this.spnCapacity.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlSchoolProperties.this.currentSchool.setCapacity((Integer)PnlSchoolProperties.this.spnCapacity.getValue());
                }
            });
        }
        return this.spnCapacity;
    }
}

