/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.Projection;
import java.awt.geom.Point2D;

public class MBTFPSProjection
extends Projection {
    private static final int MAX_ITER = 10;
    private static final double LOOP_TOL = 1.0E-7;
    private static final double C1 = 0.45503;
    private static final double C2 = 1.36509;
    private static final double C3 = 1.41546;
    private static final double C_x = 0.22248;
    private static final double C_y = 1.44492;
    private static final double C1_2 = 0.3333333333333333;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        double t;
        double k = 1.41546 * Math.sin(lpphi);
        for (int i = 10; i > 0; --i) {
            t = lpphi / 1.36509;
            double V = (0.45503 * Math.sin(t) + Math.sin(lpphi) - k) / (0.3333333333333333 * Math.cos(t) + Math.cos(lpphi));
            out.y -= V;
            if (Math.abs(V) < 1.0E-7) break;
        }
        t = lpphi / 1.36509;
        out.x = 0.22248 * lplam * (1.0 + 3.0 * Math.cos(lpphi) / Math.cos(t));
        out.y = 1.44492 * Math.sin(t);
        return out;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        double t = MapMath.asin(xyy / 1.44492);
        out.y = 1.36509 * t;
        out.x = xyx / (0.22248 * (1.0 + 3.0 * Math.cos(out.y) / Math.cos(t)));
        out.y = MapMath.asin((0.45503 * Math.sin(t) + Math.sin(out.y)) / 1.41546);
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "McBryde-Thomas Flat-Pole Sine (No. 2)";
    }
}

