/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math;

import java.io.Serializable;
import java.util.logging.Logger;

public class SignalSmoothingWeight
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double innovationWeight = 1.0;
    private double freezeIteration = Double.MAX_VALUE;
    private int iteration = 0;

    public SignalSmoothingWeight(double innovationWeight) {
        this.setInnovationWeight(innovationWeight);
    }

    public void setInnovationWeight(double innovationWeight) {
        if (Double.isNaN(innovationWeight) || innovationWeight < 0.0 || innovationWeight > 1.0) {
            throw new IllegalArgumentException("innovation weight " + innovationWeight + " is not in [0,1]");
        }
        if (innovationWeight == 0.0) {
            Logger.getLogger(this.getClass().getName()).warning("innovation is 0.0 (before freezing)");
        }
        if (this.isFrozen()) {
            Logger.getLogger(this.getClass().getName()).warning("smoothing was already frozen");
        }
        this.innovationWeight = innovationWeight;
        this.freezeIteration = Double.MAX_VALUE;
    }

    public void freeze() {
        if (this.innovationWeight > 0.0) {
            this.freezeIteration = (double)this.iteration - 1.0 / this.innovationWeight;
        } else {
            this.freezeIteration = 0.0;
            Logger.getLogger(this.getClass().getName()).warning("freezing from zero innovation weight");
        }
    }

    public boolean isFrozen() {
        return (double)this.iteration >= this.freezeIteration;
    }

    public double getNextInnovationWeight() {
        if (this.iteration++ == 0) {
            return 1.0;
        }
        if (this.isFrozen()) {
            this.innovationWeight = 1.0 / ((double)this.iteration - this.freezeIteration);
        }
        return this.innovationWeight;
    }

    public double getLastInnovationWeight() {
        if (this.iteration == 0) {
            return 1.0;
        }
        return this.innovationWeight;
    }
}

