/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.io.xml;

import org.xml.sax.Attributes;

public class ElementHandler<C> {
    private final String element;
    private final C dataContainer;
    private ElementHandler<C> nextHandler = null;

    public ElementHandler(String element, C dataContainer) {
        if (element == null) {
            throw new IllegalArgumentException("element is null");
        }
        this.element = element;
        this.dataContainer = dataContainer;
    }

    protected void addNextHandler(ElementHandler<C> nextHandler) {
        if (this.nextHandler != null) {
            this.nextHandler.addNextHandler(nextHandler);
        } else {
            this.nextHandler = nextHandler;
        }
    }

    protected boolean isLast() {
        return this.nextHandler == null;
    }

    protected boolean isSecondLast() {
        return !this.isLast() && this.nextHandler.isLast();
    }

    protected C dataContainer() {
        return this.dataContainer;
    }

    public void startElement(String uri, String lName, String qName, Attributes attrs) {
        if (this.isLast()) {
            if (this.element.equals(qName)) {
                this.myStartElement(uri, lName, qName, attrs);
            } else {
                this.addNextHandler(this.newNextHandler(qName, this.dataContainer));
                this.nextHandler.startElement(uri, lName, qName, attrs);
            }
        } else {
            this.nextHandler.startElement(uri, lName, qName, attrs);
        }
    }

    public void endElement(String uri, String lName, String qName) {
        if (this.isLast()) {
            this.myEndElement(uri, lName, qName);
        } else {
            this.nextHandler.endElement(uri, lName, qName);
            if (this.nextHandler.isLast() && this.nextHandler.element.equals(qName)) {
                this.nextHandler = null;
            }
        }
    }

    protected ElementHandler<C> newNextHandler(String nextElement, C dataContainer) {
        return new ElementHandler<C>(nextElement, dataContainer);
    }

    protected void myStartElement(String uri, String lName, String qName, Attributes attrs) {
    }

    protected void myEndElement(String uri, String lName, String qName) {
    }
}

