"""
@file    basic_rilsacorridor3.py
@author  Daniel Krajzewicz
@date    2014-09-01
@version $Id: basic_rilsacorridor3.py 22608 2017-01-17 06:28:54Z behrisch $

SUMO, Simulation of Urban MObility; see http://sumo.dlr.de/
Copyright (C) 2012-2017 DLR (http://www.dlr.de/) and contributors

This file is part of SUMO.
SUMO is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.
"""
from __future__ import absolute_import
from __future__ import print_function


from . import *
import os
import math
import sumolib.net.generator.grid as netGenerator
import sumolib.net.generator.demand as demandGenerator
from sumolib.net.generator.network import *


flowsRiLSA1 = [
    ["nmp", [
        ["ms", 359, 9],
        ["me", 59, 9],
        ["mw", 64, 12]
    ]],

    ["wmp", [
        ["me", 508, 10],
        ["mn", 80, 14],
        ["ms", 130, 2]
    ]],

    ["emp", [
        ["mw", 571, 10],
        ["mn", 57, 9],
        ["ms", 47, 3]
    ]],

    ["smp", [
        ["mn", 354, 2],
        ["me", 49, 2],
        ["mw", 92, 2]
    ]]

]


class Scenario_BasicRiLSACorridor3(Scenario):
    NAME = "BasicRiLSACorridor3"
    THIS_DIR = os.path.join(os.path.abspath(os.path.dirname(__file__)), NAME)
    TLS_FILE = "tls.add.xml"
    NET_FILE = "network.net.xml"

    def __init__(self, name, params, withDefaultDemand=True):
        Scenario.__init__(self, self.THIS_DIR)
        self.params = params
        self.demandName = self.fullPath("routes.rou.xml")
        self.netName = self.fullPath(self.NET_FILE)
        # network
        if fileNeedsRebuild(self.fullPath(self.NET_FILE), "netconvert"):
            print("Network in '%s' needs to be rebuild" % self.netName)
            # , Lane(dirs="l", disallowed="pedestrian")]
            lanes = [Lane(dirs="s", allowed="pedestrian"), Lane(
                dirs="rs", disallowed="pedestrian")]
            defaultEdge = Edge(numLanes=2, maxSpeed=13.89, lanes=lanes)
            defaultEdge.addSplit(100, 0, 1)
            defaultEdge.lanes[-1].dirs = "l"
            netGen = netGenerator.grid(5, 3, None, defaultEdge)
            for n in netGen._nodes:
                nid = n.split("/")
                nid[0] = int(nid[0])
                nid[1] = int(nid[1])
                if nid[0] > 0 and nid[0] < 6 and nid[1] > 0 and nid[1] < 4:
                    netGen._nodes[n].addCrossing(
                        "%s/%s_to_%s.-100" % (nid[0] - 1, nid[1], n), "%s_to_%s/%s" % (n, nid[0] - 1, nid[1]))
                    netGen._nodes[n].addCrossing(
                        "%s/%s_to_%s.-100" % (nid[0] + 1, nid[1], n), "%s_to_%s/%s" % (n, nid[0] + 1, nid[1]))
                    netGen._nodes[n].addCrossing(
                        "%s/%s_to_%s.-100" % (nid[0], nid[1] - 1, n), "%s_to_%s/%s" % (n, nid[0], nid[1] - 1))
                    netGen._nodes[n].addCrossing(
                        "%s/%s_to_%s.-100" % (nid[0], nid[1] + 1, n), "%s_to_%s/%s" % (n, nid[0], nid[1] + 1))
            # not nice, the network name should be given/returned
            netGen.build(self.netName)
        if True:
            fdow = open(self.fullPath(self.TLS_FILE), "w")
            fdow.write('<additional>\n\n')
            for y in range(1, 4):
                for x in range(1, 6):
                    eedge = "%s/%s_to_%s/%s.-100" % (x - 1, y, x, y)
                    wedge = "%s/%s_to_%s/%s.-100" % (x + 1, y, x, y)
                    nedge = "%s/%s_to_%s/%s.-100" % (x, y + 1, x, y)
                    sedge = "%s/%s_to_%s/%s.-100" % (x, y - 1, x, y)
                    fdow.write(
                        '   <tlLogic id="%s/%s" type="actuated" programID="adapted" offset="0">\n' % (x, y))
                    fdow.write(
                        '      <phase duration="31" state="rrrrrGGgrrrrrGGgGrGr" minDur="10" maxDur="50" type="target;decisional" targetLanes="%s_1 %s_2 %s_1 %s_2"/>\n' % (eedge, eedge, wedge, wedge))
                    fdow.write(
                        '      <phase duration="4"  state="rrrrryygrrrrryygrrrr" type="transient"/>\n')
                    fdow.write(
                        '      <phase duration="6"  state="rrrrrrrGrrrrrrrGrrrr" minDur="2" maxDur="20" type="decisional" targetLanes="%s_2 %s_2"/>\n' % (eedge, wedge))
                    fdow.write(
                        '      <phase duration="4"  state="rrrrrrryrrrrrrryrrrr" type="transient"/>\n')
                    fdow.write(
                        '      <phase duration="4"  state="rrrrrrrrrrrrrrrrrrrr" type="transient;commit"/>\n')
                    fdow.write(
                        '      <phase duration="31" state="rGGgrrrrrGGgrrrrrGrG" minDur="10" maxDur="50" type="target;decisional" targetLanes="%s_1 %s_2 %s_1 %s_2"/>\n' % (sedge, sedge, nedge, nedge))
                    fdow.write(
                        '      <phase duration="4"  state="ryygrrrrryygrrrrrrrr" type="transient"/>\n')
                    fdow.write(
                        '      <phase duration="6"  state="rrrGrrrrrrrGrrrrrrrr" minDur="2" maxDur="20" type="decisional" targetLanes="%s_2 %s_2"/>\n' % (sedge, nedge))
                    fdow.write(
                        '      <phase duration="4"  state="rrryrrrrrrryrrrrrrrr" type="transient"/>\n')
                    fdow.write(
                        '      <phase duration="4"  state="rrrrrrrrrrrrrrrrrrrr" type="transient;commit"/>\n')
                    fdow.write('   </tlLogic>\n\n')
            fdow.write('</additional>\n')
        # demand
        if withDefaultDemand:
            self.demand = demandGenerator.Demand()
            for f in flowsRiLSA1:
                for oe, rel in enumerate(f[1]):
                    flow = int(rel[1] * .75)
                    prob = rel[2] / 100.
                    iprob = 1. - prob
                    pkwEprob = iprob * self.params["equipment-rate"]
                    pkwNprob = iprob - pkwEprob
                    lkwEprob = prob * self.params["equipment-rate"]
                    lkwNprob = prob - lkwEprob
                    for ie in range(2, 5):  # over input
                        via = []
                        if f[0] == "nmp":
                            iedge = "%s/4_to_%s/3" % (ie, ie)
                            for ve in range(5, 0, -1):
                                via.append("%s/%s_to_%s/%s" %
                                           (ie, ve, ie, ve - 1))
                        if f[0] == "smp":
                            iedge = "%s/0_to_%s/1" % (ie, ie)
                            for ve in range(0, 5, 1):
                                via.append("%s/%s_to_%s/%s" %
                                           (ie, ve, ie, ve + 1))
                        if f[0] == "wmp":
                            if ie > 2:
                                continue
                            iedge = "0/%s_to_1/%s" % (ie, ie)
                            for ve in range(0, 5, 1):
                                via.append("%s/%s_to_%s/%s" %
                                           (ve, ie, ve + 1, ie))
                        if f[0] == "emp":
                            if ie > 2:
                                continue
                            iedge = "6/%s_to_5/%s" % (ie, ie)
                            for ve in range(5, 0, -1):
                                via.append("%s/%s_to_%s/%s" %
                                           (ve, ie, ve - 1, ie))
                        if oe == 0:
                            # if ie<2 or ie>2: continue # discard vehicles not
                            # passing the center
                            if rel[0] == "mn":
                                oedge = "%s/3_to_%s/4.-100" % (ie, ie)
                            if rel[0] == "ms":
                                oedge = "%s/1_to_%s/0.-100" % (ie, ie)
                            if rel[0] == "mw":
                                oedge = "1/%s_to_0/%s.-100" % (ie, ie)
                            if rel[0] == "me":
                                oedge = "5/%s_to_6/%s.-100" % (ie, ie)
                            self.demand.addStream(demandGenerator.Stream(iedge + "__" + oedge, 0, 3600, flow, iedge, oedge,
                                                                         {"passenger": pkwEprob, "COLOMBO_undetectable_passenger": pkwNprob, "hdv": lkwEprob, "COLOMBO_undetectable_hdv": lkwNprob}))
                            continue
                        for oee in range(1, 4):
                            if rel[0] == "mn":
                                oedge = "%s/3_to_%s/4.-100" % (oee, oee)
                            if rel[0] == "ms":
                                oedge = "%s/1_to_%s/0.-100" % (oee, oee)
                            if rel[0] == "mw":
                                oedge = "1/%s_to_0/%s.-100" % (oee, oee)
                            if rel[0] == "me":
                                oedge = "5/%s_to_6/%s.-100" % (oee, oee)
                            # if (ie<2 or ie>2) and (oee<2 or oee>2): continue
                            # # discard vehicles not passing the center
                            self.demand.addStream(demandGenerator.Stream(iedge + "__" + oedge, 0, 3600, int(flow / 3.), iedge, oedge,
                                                                         {"passenger": pkwEprob, "COLOMBO_undetectable_passenger": pkwNprob, "hdv": lkwEprob, "COLOMBO_undetectable_hdv": lkwNprob}))
            if fileNeedsRebuild(self.demandName, "duarouter"):
                self.demand.build(0, 86400, self.netName, self.demandName)

        shutil.copy(
            self.fullPath(self.NET_FILE), self.sandboxPath(self.NET_FILE))
        shutil.copy(
            self.fullPath(self.TLS_FILE), self.sandboxPath(self.TLS_FILE))
        print("Huah")
