/***************************************************************************
 *   Copyright (C) 2003 by Wilfried Huss                                   *
 *   Wilfried.Huss@gmx.at                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef RICHTEXTLABEL_H
#define RICHTEXTLABEL_H

#include <qstring.h>
#include <qsimplerichtext.h>
#include <qpainter.h>
#include <qfont.h>
#include <qfontmetrics.h>
#include <qrect.h>

#include "meter.h"
#include "karamba.h"

class RichTextLabel : public Meter
{
public:
    RichTextLabel(karamba*);
    ~RichTextLabel();

    void setText(QString text, bool linkUnderline = false);

    void setFont(QString font);
    QString getFont() const;
    void setFontSize(int);
    int getFontSize() const;
    void setFixedPitch(bool);
    bool getFixedPitch() const;

    void showText();
    void hideText();

    virtual bool insideActiveArea(int, int);

    virtual bool click(QMouseEvent*);
    virtual void mUpdate(QPainter*);

    QString anchorAt(int, int);

private:
    QSimpleRichText* text;

    QString source;
    QFont font;

    bool underlineLinks;
    bool hidden;

    karamba* mykaramba;
}
;

#endif
