//  $Id: sequence_trigger.hpp 4715 2007-01-28 19:31:49Z ravualhemio $
//
//  SuperTux
//  Copyright (C) 2006 Matthias Braun <matze@braunis.de>
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#ifndef __SEQUENCE_TRIGGER_H__
#define __SEQUENCE_TRIGGER_H__

#include "trigger_base.hpp"
#include "serializable.hpp"
#include "object/player.hpp"

class SequenceTrigger : public TriggerBase, public Serializable
{
public:
  SequenceTrigger(const lisp::Lisp& reader);
  SequenceTrigger(const Vector& pos, const std::string& sequence);
  ~SequenceTrigger();

  void write(lisp::Writer& writer);
  void event(Player& player, EventType type);

  std::string get_sequence_name() const { return sequence_name; }

private:
  EventType triggerevent;
  std::string sequence_name;
};

#endif
