dnl libggi (un)installed path


AC_DEFUN([GGI_INST_PATH],
[

AC_ARG_WITH([ggi],
[  --with-ggi=DIR          use the LibGGI installed with prefix DIR
                           (can be used to specify location of LibGII too)],
AM_CPPFLAGS="$AM_CPPFLAGS -I$withval/include"
  AM_LDFLAGS="$AM_LDFLAGS -L$withval/lib"
  CPPFLAGS="$CPPFLAGS -I$withval/include"
  LDFLAGS="$LDFLAGS -L$withval/lib",
AM_CPPFLAGS="$AM_CPPFLAGS -I$prefix/include"
  AM_LDFLAGS="$AM_LDFLAGS -L$prefix/lib"
  CPPFLAGS="$CPPFLAGS -I$prefix/include"
  LDFLAGS="$LDFLAGS -L$prefix/lib")

])


AC_DEFUN([GGI_UNINST_PATH],
[

AC_ARG_WITH([uninst-ggi],
[  --with-uninst-ggi=DIR   use uninstalled copy of LibGGI found in DIR],
absval=`(cd "$withval"; pwd)`
AM_CPPFLAGS="$AM_CPPFLAGS -I$absval/include"
  AM_LDFLAGS="$AM_LDFLAGS -L$absval/ggi"
  CPPFLAGS="$CPPFLAGS -I$absval/include"
  LDFLAGS="$LDFLAGS -L$absval/ggi",
AM_CPPFLAGS="$AM_CPPFLAGS -I$prefix/include"
  AM_LDFLAGS="$AM_LDFLAGS -L$prefix/ggi"
  CPPFLAGS="$CPPFLAGS -I$prefix/include"
  LDFLAGS="$LDFLAGS -L$prefix/ggi")

])


AC_DEFUN([GGI_CHECKLIB],
[

AC_CHECK_HEADERS([ggi/ggi.h])

ggi_missing_part=no

dnl Testing libs should use libtool but doesn't - grrrr!
dnl This isn't a problem during the build because libtool is always used.
dnl Wish I could use $LIBTOOL, but it is written for Makefile use.
save_CC="$CC"
CC="$SHELL ./libtool --mode=link $CC"
AC_CHECK_LIB(ggi,ggiInit,foo=bar,ggi_missing_part=yes)
CC="$save_CC"

if test "$ac_cv_header_ggi_ggi_h" != "yes" -o \
	"$ggi_missing_part" = "yes" ; then
  AC_MSG_ERROR([Either wrong include path is used or LibGGI is
                not properly installed on the system. You need LibGGI for
                building $1. Please compile LibGGI first.])
fi

])
