/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-get; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <cstdio>
#include <cstring>
#include <string>
#include <cstdlib>
#include <iostream>

#include <unistd.h>
#include <netinet/tcp.h>
#include <sys/socket.h>
#include <netdb.h>

#include "http.hh"
#include "basic.hh"
#include "global.hh"

int sock_connect(const char *host, in_port_t port) {
	struct hostent *hp;
	struct sockaddr_in addr;
	int on = 1, sock;     

	if((hp = gethostbyname(host)) == NULL) {
		herror("gethostbyname");
		return -1;
	}
	bcopy(hp->h_addr, &addr.sin_addr, hp->h_length);
	addr.sin_port = htons(port);
	addr.sin_family = AF_INET;
	sock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
	setsockopt(sock, IPPROTO_TCP, TCP_NODELAY, (const char *)&on, sizeof(int));
	if(sock == -1)  {
		perror("setsockopt");
		return -1;
	}
	if(connect(sock, (struct sockaddr *)&addr, sizeof(struct sockaddr_in)) == -1) {
		perror("connect");
		return -1;
	}
	return sock;
}

FILE* http_fopen(xmlURIPtr uri) {
	if (uri == NULL)
		return NULL;

      	int fd;
	FILE* f;

	fd = sock_connect(uri->server, atoi(int2string((uri->port == 0) ? 80 : uri->port).c_str())); 
	if (fd == -1)
		return NULL;

	f = fdopen(fd, "r");
	if (f == NULL)
		return NULL;
	
	std::string query("GET ");
	query += uri->path;
	query += " HTTP/1.0\r\nHost: ";
	query += uri->server;
	query += "\r\nUser-Agent: swac-get " VERSION "\r\n\r\n";

	int size = write(fd, query.c_str(), query.size());  

	//Skip HTTP 1.0 Header        
	char buf[256];

	char *result = fgets(buf, sizeof(buf), f);
	if (memcmp(buf, "HTTP/1.0 200 OK\r", 16) > 0 and memcmp(buf, "HTTP/1.1 200 OK\r", 16) > 0) {
		std::cerr << uri->path << " is unreachable on " << uri->server << std::endl;
		return NULL;
	}

	do {
		result = fgets(buf, sizeof(buf), f);
	} while (strcmp(buf, "\r\n") != 0 && !feof(f));

	return f; 
}


