/**
 * \file SwamiUITree.h
 * \brief Sound font tree object header file
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMIUI_TREE_H__
#define __SWAMIUI_TREE_H__

#include <gtk/gtk.h>
#include <instpatch.h>

#include "swamidll.h"

/* additional IPItem types for dummy tree nodes */
/* FIXME! IPITEM_COUNT */
enum {
  SWAMIUI_TREE_PRESET_ROOT = IPITEM_COUNT,
  SWAMIUI_TREE_PRESET_MELODIC,
  SWAMIUI_TREE_PRESET_PERCUSS,
  SWAMIUI_TREE_INST_ROOT,
  SWAMIUI_TREE_SAMPLE_ROOT,
  SWAMIUI_TREE_SAMPLE_USER,
  SWAMIUI_TREE_SAMPLE_ROM,
  SWAMIUI_TREE_VBANK_DEFAULT,
  SWAMIUI_TREE_VBANK_MAP_ROOT
};

#define SWAMIUI_TREE_FIRST SWAMIUI_TREE_PRESET_ROOT
#define SWAMIUI_TREE_LAST SWAMIUI_TREE_VBANK_MAP_ROOT

typedef struct _SwamiUITree SwamiUITree;
typedef struct _SwamiUITreeClass SwamiUITreeClass;
typedef struct _SwamiUITreeIPSFontNodes SwamiUITreeIPSFontNodes;
typedef struct _SwamiUITreeVBankNodes SwamiUITreeVBankNodes;

#define SWAMIUI_TYPE_TREE   (swamiui_tree_get_type ())
#define SWAMIUI_TREE(obj) \
  (GTK_CHECK_CAST ((obj), SWAMIUI_TYPE_TREE, SwamiUITree))
#define SWAMIUI_TREE_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST ((klass), SWAMIUI_TYPE_TREE, SwamiUITreeClass))
#define SWAMIUI_IS_TREE(obj) \
  (GTK_CHECK_TYPE ((obj), SWAMIUI_TYPE_TREE))
#define SWAMIUI_IS_TREE_CLASS(klass) \
  (GTK_CHECK_CLASS_TYPE ((klass), SWAMIUI_TYPE_TREE))

/** Swami Tree Object (all fields private) */
struct _SwamiUITree
{
  GtkScrolledWindow parent;	/* derived from GtkScrolledWindow */
  GHashTable *item_hash;	/* hash of IPItem -> GtkCTreeNode */
  GtkCTree *tree_widg;		/* tree widget */
  GtkWidget *treemenu;		/* right click menu widget */
  IPItem *rclick_item;		/* current right clicked item or NULL */
  IPItem *select_item;		/* current single selected item or NULL */
};

/** Swami Tree Object class (all fields private) */
struct _SwamiUITreeClass
{
  GtkScrolledWindowClass parent_class;

  GList *tree_list;		/* list of all tree instances */

  void (*item_select) (SwamiUITree *tree, IPItem *item);
  void (*item_unselect) (SwamiUITree *tree, IPItem *item);
  void (*single_select_changed) (SwamiUITree *tree, IPItem *item);
};

/* major nodes for an IPSFont sound font in tree */
struct _SwamiUITreeIPSFontNodes
{
  GtkCTreeNode *sfdata;
  GtkCTreeNode *preset;
  GtkCTreeNode *melodic;
  GtkCTreeNode *percuss;
  GtkCTreeNode *inst;
  GtkCTreeNode *sample;
  GtkCTreeNode *loaded;
  GtkCTreeNode *rom;
};

/* major nodes for a virtual bank in the tree */
struct _SwamiUITreeVBankNodes
{
  GtkCTreeNode *vbank;
  GtkCTreeNode *defbank;
  GtkCTreeNode *inclroot;
  GtkCTreeNode *maproot;
};

SWAMI_API guint swamiui_tree_get_type (void);
SWAMI_API GtkWidget *swamiui_tree_new (void);
SWAMI_API void swamiui_tree_refresh (SwamiUITree *tree);
SWAMI_API void swamiui_tree_item_add (SwamiUITree *tree, IPItem *item);
SWAMI_API void swamiui_tree_item_remove (SwamiUITree *tree, IPItem *item);
SWAMI_API gboolean swamiui_tree_item_is_dummy (IPItem *item);

SWAMI_API void swamiui_tree_freeze (SwamiUITree *tree);
SWAMI_API void swamiui_tree_thaw (SwamiUITree *tree);
SWAMI_API void swamiui_tree_freeze_all (void);
SWAMI_API void swamiui_tree_thaw_all (void);

SWAMI_API IPItem *swamiui_tree_get_selection_single (SwamiUITree *tree);
SWAMI_API GList *swamiui_tree_get_selection (SwamiUITree *tree);
SWAMI_API GList *swamiui_tree_get_selection_rclick (SwamiUITree *tree);
SWAMI_API void swamiui_tree_free_selection (GList *sel_list);

SWAMI_API IPItem *swamiui_tree_get_rclick_item (SwamiUITree *tree);
SWAMI_API void swamiui_tree_set_rclick_item (SwamiUITree *tree, IPItem *item);
SWAMI_API void swamiui_tree_clear_selection (SwamiUITree *tree);

SWAMI_API void swamiui_tree_spotlight_item (SwamiUITree *tree, IPItem *item);
SWAMI_API void swamiui_tree_highlight_item (SwamiUITree *tree, IPItem *item,
					    GtkStateType state);
SWAMI_API void swamiui_tree_unhighlight_item (SwamiUITree *tree, IPItem *item);
SWAMI_API void swamiui_tree_item_set_pixmap (SwamiUITree *tree, IPItem *item,
					     gchar **xpm);

#endif
