/*
    pqConsole    : interfacing SWI-Prolog and Qt

    Author       : Carlo Capelli
    E-mail       : cc.carlo.cap@gmail.com
    Copyright (C): 2013, Carlo Capelli

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef PQCONSOLE_H
#define PQCONSOLE_H

#include "pqConsole_global.h"

/*!
  \mainpage
    [pqConsole](@ref pqConsole) is an attempt to bring [SWI-Prolog](http://www.swi-prolog.org/) running in [Qt](http://qt-project.org/) environment.

    Using a shared library as basic component, it allows for maximum flexibility in reuse and deployment.
    It's being hosted on [Github](https://github.com/CapelliC/pqConsole).

  \author Carlo Capelli
  \version 0.1

  \class generated by QtCreator for project, this class represent library entry point.
  You can use [ConsoleEdit](@ref ConsoleEdit) *without* instancing pqConsole. Indeed argc/argv are forwarded to ConsoleEdit constructor.

  */
class PQCONSOLESHARED_EXPORT pqConsole {
public:

    pqConsole();

    /*! Run a vanilla QMainWindow displaying SWI-Prolog console */
    int runDemo(int argc, char *argv[]);
};

#endif // PQCONSOLE_H
