/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.DefaultStackPresentationSite;
import org.eclipse.ui.internal.DetachedWindow;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartSashContainer;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.presentations.SystemMenuClose;
import org.eclipse.ui.internal.presentations.SystemMenuFastView;
import org.eclipse.ui.internal.presentations.SystemMenuMaximize;
import org.eclipse.ui.internal.presentations.SystemMenuMinimize;
import org.eclipse.ui.internal.presentations.SystemMenuMoveView;
import org.eclipse.ui.internal.presentations.SystemMenuRestore;
import org.eclipse.ui.internal.presentations.SystemMenuSize;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public class PartTabFolder
extends LayoutPart
implements ILayoutContainer {
    private boolean active = false;
    private List children = new ArrayList(3);
    private LayoutPart current;
    private int flags;
    private LayoutPart inactiveCurrent;
    private WorkbenchPage page;
    private DefaultStackPresentationSite presentationSite = new DefaultStackPresentationSite(){

        public void close(IPresentablePart part) {
            PartTabFolder.this.close(part);
        }

        public void dragStart(IPresentablePart beingDragged, Point initialLocation, boolean keyboard) {
            LayoutPart pane;
            if (this.isMoveable(beingDragged) && (pane = PartTabFolder.this.getPaneFor(beingDragged)) != null) {
                DragUtil.performDrag(pane, Geometry.toDisplay((Control)PartTabFolder.this.getParent(), (Rectangle)this.getPresentation().getControl().getBounds()), initialLocation, !keyboard);
            }
        }

        public void dragStart(Point initialPosition, boolean keyboard) {
            if (PartTabFolder.this.canMoveFolder()) {
                DragUtil.performDrag(PartTabFolder.this, Geometry.toDisplay((Control)PartTabFolder.this.getParent(), (Rectangle)this.getPresentation().getControl().getBounds()), initialPosition, !keyboard);
            }
        }

        public boolean isCloseable(IPresentablePart part) {
            Perspective perspective = PartTabFolder.this.page.getActivePerspective();
            if (perspective == null) {
                return false;
            }
            ViewPane pane = (ViewPane)PartTabFolder.this.getPaneFor(part);
            if (pane == null) {
                return false;
            }
            return !perspective.isFixedView(pane.getViewReference());
        }

        public boolean isMoveable(IPresentablePart part) {
            if (part == null) {
                return PartTabFolder.this.canMoveFolder();
            }
            return this.isCloseable(part);
        }

        public void selectPart(IPresentablePart toSelect) {
            PartTabFolder.this.presentationSelectionChanged(toSelect);
        }

        public void setPresentation(StackPresentation newPresentation) {
            super.setPresentation(newPresentation);
            PartTabFolder.this.updateSystemMenu();
        }

        public void setState(int newState) {
            if (newState == 0 && (PartTabFolder.this.flags & 0x80) == 0) {
                return;
            }
            if (newState == 0 && (PartTabFolder.this.flags & 0x400) == 0) {
                return;
            }
            PartTabFolder.this.setState(newState);
        }
    };
    private IContributionItem systemMenuContribution;

    public PartTabFolder(WorkbenchPage page) {
        this(page, 1152);
    }

    public PartTabFolder(WorkbenchPage page, int flags) {
        super("PartTabFolder");
        this.setID(this.toString());
        this.page = page;
        this.flags = flags;
    }

    public void add(LayoutPart child) {
        this.children.add(child);
        if (this.active) {
            this.showPart(child, null);
        }
    }

    private boolean canMoveFolder() {
        Perspective perspective = this.page.getActivePerspective();
        if (perspective == null) {
            return false;
        }
        return !perspective.isFixedLayout();
    }

    private void add(LayoutPart newChild, int idx) {
        IPresentablePart position = this.getPresentablePartAtIndex(idx);
        LayoutPart targetPart = this.getPaneFor(position);
        int childIdx = this.children.indexOf(targetPart);
        if (childIdx == -1) {
            this.children.add(newChild);
        } else {
            this.children.add(idx, newChild);
        }
        if (this.active) {
            this.showPart(newChild, position);
        }
    }

    public boolean allowsAutoFocus() {
        if (this.presentationSite.getState() == 0) {
            return false;
        }
        ILayoutContainer parent = this.getContainer();
        return parent == null || parent.allowsAutoFocus();
    }

    public boolean allowsBorder() {
        return false;
    }

    protected void close(IPresentablePart part) {
        if (!this.presentationSite.isCloseable(part)) {
            return;
        }
        LayoutPart layoutPart = this.getPaneFor(part);
        if (layoutPart != null && layoutPart instanceof ViewPane) {
            ViewPane viewPane = (ViewPane)layoutPart;
            viewPane.doHide();
        }
    }

    public void createControl(Composite parent) {
        if (this.presentationSite.getPresentation() != null) {
            return;
        }
        AbstractPresentationFactory factory = ((WorkbenchWindow)this.page.getWorkbenchWindow()).getWindowConfigurer().getPresentationFactory();
        this.presentationSite.setPresentation(factory.createPresentation(parent, this.presentationSite, 1, this.flags, this.page.getPerspective().getId(), this.getID()));
        this.active = true;
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart part = (LayoutPart)iter.next();
            this.showPart(part, null);
        }
        if (this.getItemCount() > 0) {
            int newPage = 0;
            if (this.current != null) {
                newPage = this.indexOf(this.current);
            }
            this.setSelection(newPage);
        }
        Control ctrl = this.getPresentation().getControl();
        DragUtil.addDragTarget(ctrl, new IDragOverListener(){

            public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
                if (!(draggedObject instanceof ViewPane)) {
                    return null;
                }
                ViewPane pane = (ViewPane)draggedObject;
                if (pane.getWorkbenchWindow() != PartTabFolder.this.getWorkbenchWindow()) {
                    return null;
                }
                StackDropResult dropResult = PartTabFolder.this.getPresentation().dragOver(currentControl, position);
                if (dropResult == null) {
                    return null;
                }
                IPresentablePart draggedControl = PartTabFolder.this.getPresentablePartAtIndex(dropResult.getDropIndex());
                if (draggedControl == pane.getPresentablePart()) {
                    return null;
                }
                return new IDropTarget(this, pane, dropResult){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ ViewPane val$pane;
                    private final /* synthetic */ StackDropResult val$dropResult;
                    {
                        this.this$1 = var1_1;
                        this.val$pane = viewPane;
                        this.val$dropResult = stackDropResult;
                    }

                    public void drop() {
                        if (this.val$pane.getContainer() != 2.access$0(this.this$1)) {
                            PartTabFolder.access$2(2.access$0(this.this$1)).getActivePerspective().getPresentation().derefPart(this.val$pane);
                            this.val$pane.reparent(2.access$0(this.this$1).getParent());
                        } else {
                            2.access$0(this.this$1).remove(this.val$pane);
                        }
                        PartTabFolder.access$9(2.access$0(this.this$1), this.val$pane, this.val$dropResult.getDropIndex());
                        2.access$0(this.this$1).setSelection(this.val$pane);
                        this.val$pane.setFocus();
                    }

                    public Cursor getCursor() {
                        return DragCursors.getCursor(5);
                    }

                    public Rectangle getSnapRectangle() {
                        return this.val$dropResult.getSnapRectangle();
                    }
                };
            }

            static /* synthetic */ PartTabFolder access$0(2 var0) {
                return var0.PartTabFolder.this;
            }
        });
        ctrl.setData((Object)this);
    }

    public void dispose() {
        if (!this.active) {
            return;
        }
        this.presentationSite.getPresentation();
        this.presentationSite.dispose();
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            next.setContainer(null);
        }
        this.active = false;
        this.updateSystemMenu();
    }

    public void findSashes(LayoutPart part, PartPane.Sashes sashes) {
        ILayoutContainer container = this.getContainer();
        if (container != null) {
            container.findSashes(this, sashes);
        }
    }

    private void forceLayout() {
        PartSashContainer cont = (PartSashContainer)this.getContainer();
        if (cont != null) {
            LayoutTree tree = cont.getLayoutTree();
            tree.setBounds(this.getParent().getClientArea());
        }
    }

    public Rectangle getBounds() {
        if (this.getPresentation() == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.getPresentation().getControl().getBounds();
    }

    public LayoutPart[] getChildren() {
        return this.children.toArray(new LayoutPart[this.children.size()]);
    }

    public Control getControl() {
        StackPresentation presentation = this.getPresentation();
        if (presentation == null) {
            return null;
        }
        return presentation.getControl();
    }

    public int getItemCount() {
        if (this.active) {
            return this.getPresentableParts().size();
        }
        return this.children.size();
    }

    private LayoutPart getLayoutPart(IPresentablePart toFind) {
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            if (next.getPresentablePart() != toFind) continue;
            return next;
        }
        return null;
    }

    public int getMinimumHeight() {
        if (this.getPresentation() == null) {
            return 0;
        }
        return this.getPresentation().computeMinimumSize().y;
    }

    private LayoutPart getPaneFor(IPresentablePart part) {
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            if (next.getPresentablePart() != part) continue;
            return next;
        }
        return null;
    }

    public Composite getParent() {
        return this.getControl().getParent();
    }

    private IPresentablePart getPresentablePartAtIndex(int idx) {
        List presentableParts = this.getPresentableParts();
        if (idx >= 0 && idx < presentableParts.size()) {
            return (IPresentablePart)presentableParts.get(idx);
        }
        return null;
    }

    private List getPresentableParts() {
        ArrayList<IPresentablePart> result = new ArrayList<IPresentablePart>(this.children.size());
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart part = (LayoutPart)iter.next();
            IPresentablePart presentablePart = part.getPresentablePart();
            if (presentablePart == null) continue;
            result.add(presentablePart);
        }
        return result;
    }

    private StackPresentation getPresentation() {
        return this.presentationSite.getPresentation();
    }

    public int getSelection() {
        if (!this.active) {
            return 0;
        }
        return this.indexOf(this.current);
    }

    public LayoutPart getVisiblePart() {
        if (this.current == null) {
            return this.inactiveCurrent;
        }
        return this.current;
    }

    private void hidePart(LayoutPart part) {
        IPresentablePart presentablePart = part.getPresentablePart();
        if (presentablePart == null) {
            return;
        }
        this.getPresentation().removePart(presentablePart);
        if (this.active) {
            part.setContainer(null);
        }
    }

    private int indexOf(IPresentablePart part) {
        int result = this.getPresentableParts().indexOf(part);
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public int indexOf(LayoutPart item) {
        return this.indexOf(item.getPresentablePart());
    }

    public boolean isDragAllowed(Point point) {
        return true;
    }

    public void openTracker(LayoutPart part) {
        DragUtil.performDrag(part, DragUtil.getDisplayBounds(part.getControl()));
    }

    private void presentationSelectionChanged(IPresentablePart newSelection) {
        Window window;
        LayoutPart newPart = this.getLayoutPart(newSelection);
        if (newPart == this.current) {
            return;
        }
        this.setSelection(newPart);
        if (newPart != null) {
            newPart.setFocus();
        }
        if ((window = this.getWindow()) instanceof DetachedWindow) {
            window.getShell().setText(newSelection.getTitle());
        }
    }

    public void remove(LayoutPart child) {
        IPresentablePart presentablePart = child.getPresentablePart();
        if (presentablePart != null) {
            this.presentationSite.getPresentation().removePart(presentablePart);
        }
        this.children.remove(child);
        if (this.active) {
            child.setContainer(null);
        }
        this.updateContainerVisibleTab();
    }

    public void reparent(Composite newParent) {
        if (!newParent.isReparentable()) {
            return;
        }
        Control control = this.getControl();
        if (control == null || control.getParent() == newParent) {
            return;
        }
        super.reparent(newParent);
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            next.reparent(newParent);
        }
    }

    public void replace(LayoutPart oldChild, LayoutPart newChild) {
        IPresentablePart oldPart = oldChild.getPresentablePart();
        newChild.getPresentablePart();
        int idx = this.children.indexOf(oldChild);
        this.children.add(idx, newChild);
        if (this.active) {
            this.showPart(newChild, oldPart);
        }
        if (oldChild == this.inactiveCurrent) {
            this.setSelection(newChild);
            this.inactiveCurrent = null;
        }
        this.remove(oldChild);
    }

    public boolean resizesVertically() {
        return this.presentationSite.getState() != 0;
    }

    public IStatus restoreState(IMemento memento) {
        Integer expanded;
        String activeTabID = memento.getString("activePageID");
        IMemento[] children = memento.getChildren("page");
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IMemento childMem = children[i];
                String partID = childMem.getString("content");
                PartPlaceholder part = new PartPlaceholder(partID);
                part.setContainer(this);
                this.add(part);
                if (partID.equals(activeTabID)) {
                    this.inactiveCurrent = part;
                }
                ++i;
            }
        }
        this.setState((expanded = memento.getInteger("expanded")) == null || expanded != 0 ? 2 : 0);
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IStatus saveState(IMemento memento) {
        if (this.current != null) {
            memento.putString("activePageID", this.current.getID());
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            IMemento childMem = memento.createChild("page");
            IPresentablePart part = next.getPresentablePart();
            String tabText = "LabelNotFound";
            if (part != null) {
                tabText = part.getName();
            }
            childMem.putString("label", tabText);
            childMem.putString("content", next.getID());
        }
        memento.putInteger("expanded", this.presentationSite.getState() == 0 ? 0 : 2);
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public void setActive(boolean activeState) {
        if (activeState) {
            if (this.presentationSite.getState() == 0) {
                this.setState(2);
            }
            if (this.page.isZoomed()) {
                this.presentationSite.setPresentationState(1);
            }
        }
        this.getPresentation().setActive(activeState);
    }

    public void setBounds(Rectangle r) {
        if (this.getPresentation() != null) {
            this.getPresentation().setBounds(r);
        }
    }

    public void setContainer(ILayoutContainer container) {
        super.setContainer(container);
        if (this.presentationSite.getState() == 1 && !this.page.isZoomed()) {
            this.setState(2);
        }
    }

    public void setSelection(int index) {
        if (!this.active) {
            return;
        }
        this.setSelection(this.getLayoutPart((IPresentablePart)this.getPresentableParts().get(index)));
    }

    public void setSelection(LayoutPart part) {
        this.current = part;
        this.updateSystemMenu();
        if (part != null) {
            IPresentablePart presentablePart = part.getPresentablePart();
            StackPresentation presentation = this.getPresentation();
            if (presentablePart != null && presentation != null) {
                presentation.selectPart(presentablePart);
            }
        }
    }

    private void setState(int newState) {
        if (newState == this.presentationSite.getState()) {
            return;
        }
        int oldState = this.presentationSite.getState();
        if (this.current != null) {
            if (newState == 1) {
                ((PartPane)this.current).doZoom();
            } else {
                this.presentationSite.setPresentationState(newState);
                WorkbenchPage page = ((PartPane)this.current).getPage();
                if (page.isZoomed()) {
                    page.zoomOut();
                }
                this.updateControlBounds();
                if (oldState == 0) {
                    this.forceLayout();
                }
            }
        }
        if (this.presentationSite.getState() == 0) {
            this.page.refreshActiveView();
        }
    }

    public void setZoomed(boolean isZoomed) {
        super.setZoomed(isZoomed);
        if (isZoomed) {
            this.presentationSite.setPresentationState(1);
        } else if (this.presentationSite.getState() == 1) {
            this.presentationSite.setPresentationState(2);
        }
    }

    private void showPart(LayoutPart part, IPresentablePart position) {
        part.setContainer(this);
        IPresentablePart presentablePart = part.getPresentablePart();
        if (presentablePart == null) {
            return;
        }
        part.createControl(this.getParent());
        if (part.getControl().getParent() != this.getControl().getParent()) {
            part.reparent(this.getControl().getParent());
        }
        part.moveAbove(this.getPresentation().getControl());
        this.presentationSite.getPresentation().addPart(presentablePart, position);
        if (this.current == null) {
            this.setSelection(part);
        }
    }

    private void updateContainerVisibleTab() {
        LayoutPart[] parts = this.getChildren();
        if (parts.length < 1) {
            this.setSelection(null);
            return;
        }
        PartPane selPart = null;
        int topIndex = 0;
        IWorkbenchPartReference[] sortedPartsArray = this.page.getSortedParts();
        List<IWorkbenchPartReference> sortedParts = Arrays.asList(sortedPartsArray);
        int i = 0;
        while (i < parts.length) {
            IWorkbenchPartReference part;
            int index;
            if (parts[i] instanceof PartPane && (index = sortedParts.indexOf(part = ((PartPane)parts[i]).getPartReference())) >= topIndex) {
                topIndex = index;
                selPart = (PartPane)parts[i];
            }
            ++i;
        }
        this.setSelection(selPart);
    }

    private void updateControlBounds() {
        Rectangle bounds = this.getPresentation().getControl().getBounds();
        int minimumHeight = this.getMinimumHeight();
        if (this.presentationSite.getState() == 0 && bounds.height != minimumHeight) {
            bounds.width = this.getMinimumWidth();
            bounds.height = minimumHeight;
            this.getPresentation().setBounds(bounds);
            this.forceLayout();
        }
    }

    private void updateSystemMenu() {
        StackPresentation presentation = this.getPresentation();
        if (presentation == null) {
            if (this.systemMenuContribution != null) {
                this.systemMenuContribution.dispose();
                this.systemMenuContribution = null;
            }
        } else {
            IMenuManager systemMenuManager = presentation.getSystemMenuManager();
            if (this.systemMenuContribution != null) {
                systemMenuManager.remove(this.systemMenuContribution);
                this.systemMenuContribution.dispose();
                this.systemMenuContribution = null;
            }
            if (this.current != null && this.current instanceof ViewPane) {
                this.systemMenuContribution = new SystemMenuContribution(this.presentationSite, (ViewPane)this.current);
                systemMenuManager.add(this.systemMenuContribution);
            }
        }
    }

    public void showSystemMenu() {
        this.getPresentation().showSystemMenu();
    }

    public void showPaneMenu() {
        this.getPresentation().showPaneMenu();
    }

    public Control[] getTabList(LayoutPart part) {
        if (part != null) {
            IPresentablePart presentablePart = part.getPresentablePart();
            StackPresentation presentation = this.getPresentation();
            if (presentablePart != null && presentation != null) {
                return presentation.getTabList(presentablePart);
            }
        }
        return new Control[0];
    }

    static /* synthetic */ void access$9(PartTabFolder partTabFolder, LayoutPart layoutPart, int n) {
        partTabFolder.add(layoutPart, n);
    }

    private class SystemMenuContribution
    extends ContributionItem {
        private SystemMenuClose systemMenuClose;
        private SystemMenuFastView systemMenuFastView;
        private SystemMenuMaximize systemMenuMaximize;
        private SystemMenuMinimize systemMenuMinimize;
        private SystemMenuMoveView systemMenuMoveView;
        private SystemMenuRestore systemMenuRestore;
        private SystemMenuSize systemMenuSize;

        SystemMenuContribution(IStackPresentationSite stackPresentationSite, ViewPane viewPane) {
            this.systemMenuClose = new SystemMenuClose(viewPane.getPresentablePart(), stackPresentationSite);
            this.systemMenuFastView = new SystemMenuFastView(stackPresentationSite, viewPane);
            this.systemMenuMaximize = new SystemMenuMaximize(stackPresentationSite);
            this.systemMenuMinimize = new SystemMenuMinimize(stackPresentationSite);
            this.systemMenuMoveView = new SystemMenuMoveView(viewPane.getPresentablePart(), stackPresentationSite);
            this.systemMenuRestore = new SystemMenuRestore(stackPresentationSite);
            this.systemMenuSize = new SystemMenuSize(viewPane);
        }

        public void fill(Menu menu, int index) {
            this.systemMenuFastView.fill(menu, index);
            this.systemMenuRestore.fill(menu, index);
            this.systemMenuMoveView.fill(menu, index);
            this.systemMenuSize.fill(menu, index);
            this.systemMenuMinimize.fill(menu, index);
            this.systemMenuMaximize.fill(menu, index);
            new MenuItem(menu, 2);
            this.systemMenuClose.fill(menu, index);
        }

        public void dispose() {
            this.systemMenuClose.dispose();
            this.systemMenuFastView.dispose();
            this.systemMenuMaximize.dispose();
            this.systemMenuMinimize.dispose();
            this.systemMenuMoveView.dispose();
            this.systemMenuRestore.dispose();
            this.systemMenuSize.dispose();
        }

        public boolean isDynamic() {
            return true;
        }
    }
}

