/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.internal.PerspectiveBarManager;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class PerspectiveBarContributionItem
extends ContributionItem {
    private IPerspectiveDescriptor perspective;
    private IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
    private ToolItem toolItem = null;
    private Image image;
    private WorkbenchPage workbenchPage;
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("SHOW_TEXT_ON_PERSPECTIVE_BAR".equals(propertyChangeEvent.getProperty())) {
                PerspectiveBarContributionItem.this.update();
                IContributionManager parent = PerspectiveBarContributionItem.this.getParent();
                if (parent != null) {
                    parent.update(true);
                    if (parent instanceof PerspectiveBarManager) {
                        ((PerspectiveBarManager)parent).layout(true);
                    }
                }
            }
        }
    };
    private static final String ellipsis = "...";

    public PerspectiveBarContributionItem(IPerspectiveDescriptor perspective, WorkbenchPage workbenchPage) {
        super(perspective.getId());
        this.perspective = perspective;
        this.workbenchPage = workbenchPage;
        this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void dispose() {
        super.dispose();
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
    }

    public void fill(ToolBar parent, int index) {
        if (this.toolItem == null && parent != null && !parent.isDisposed()) {
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    PerspectiveBarContributionItem.this.toolItem.dispose();
                    PerspectiveBarContributionItem.this.toolItem = null;
                }
            });
            this.toolItem = index >= 0 ? new ToolItem(parent, 32, index) : new ToolItem(parent, 32);
            if (this.image == null || this.image.isDisposed()) {
                ImageDescriptor imageDescriptor = this.perspective.getImageDescriptor();
                this.image = imageDescriptor != null ? imageDescriptor.createImage() : WorkbenchImages.getImageDescriptor("IMG_ETOOL_DEF_PERSPECTIVE").createImage();
            }
            this.toolItem.setImage(this.image);
            this.toolItem.setToolTipText(WorkbenchMessages.format("PerspectiveBarContributionItem.toolTip", new Object[]{this.perspective.getLabel()}));
            this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (PerspectiveBarContributionItem.this.workbenchPage.getPerspective() != PerspectiveBarContributionItem.this.perspective) {
                        PerspectiveBarContributionItem.this.workbenchPage.setPerspective(PerspectiveBarContributionItem.this.perspective);
                        PerspectiveBarContributionItem.this.update();
                        PerspectiveBarContributionItem.this.getParent().update(true);
                    } else {
                        PerspectiveBarContributionItem.this.toolItem.setSelection(true);
                    }
                }
            });
            this.toolItem.setData((Object)this);
            this.update();
        }
    }

    public void update() {
        if (this.toolItem != null && !this.toolItem.isDisposed()) {
            this.toolItem.setSelection(this.workbenchPage.getPerspective() == this.perspective);
            if (this.preferenceStore.getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR")) {
                this.toolItem.setText(this.shortenText(this.perspective.getLabel(), this.toolItem));
            } else {
                this.toolItem.setText("");
            }
        }
    }

    public void update(IPerspectiveDescriptor newDesc) {
        this.perspective = newDesc;
        if (this.toolItem != null && !this.toolItem.isDisposed()) {
            ImageDescriptor imageDescriptor = this.perspective.getImageDescriptor();
            if (imageDescriptor != null) {
                this.toolItem.setImage(imageDescriptor.createImage());
            } else {
                this.toolItem.setImage(WorkbenchImages.getImageDescriptor("IMG_ETOOL_DEF_PERSPECTIVE").createImage());
            }
            this.toolItem.setToolTipText(WorkbenchMessages.format("PerspectiveBarContributionItem.toolTip", new Object[]{this.perspective.getLabel()}));
        }
        this.update();
    }

    WorkbenchPage getPage() {
        return this.workbenchPage;
    }

    IPerspectiveDescriptor getPerspective() {
        return this.perspective;
    }

    public boolean handles(IPerspectiveDescriptor perspective, WorkbenchPage workbenchPage) {
        return this.perspective == perspective && this.workbenchPage == workbenchPage;
    }

    public void setPerspective(IPerspectiveDescriptor newPerspective) {
        this.perspective = newPerspective;
    }

    void setSelection(boolean b) {
        if (this.toolItem != null && !this.toolItem.isDisposed()) {
            this.toolItem.setSelection(b);
        }
    }

    protected String shortenText(String textValue, ToolItem item) {
        if (textValue == null || this.toolItem == null || this.toolItem.isDisposed()) {
            return null;
        }
        GC gc = new GC((Drawable)item.getDisplay());
        int maxWidth = item.getImage().getBounds().width * 5;
        if (gc.textExtent((String)textValue).x < maxWidth) {
            return textValue;
        }
        int i = textValue.length();
        while (i > 0) {
            String test = textValue.substring(0, i);
            test = String.valueOf(test) + ellipsis;
            if (gc.textExtent((String)test).x < maxWidth) {
                return test;
            }
            --i;
        }
        return textValue;
    }
}

