/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.progress.ErrorInfo;
import org.eclipse.ui.internal.progress.ErrorNotificationManager;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;

public class ErrorNotificationDialog
extends Dialog {
    Action clearSelectionAction;
    Action clearAllErrorsAction;
    Action showErrorAction;
    TableViewer errorViewer;

    public ErrorNotificationDialog(Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(false);
        this.setShellStyle(2160);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ProgressMessages.getString("ErrorNotificationDialog.ErrorNotificationTitle"));
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ErrorNotificationDialog.this.getManager().clearDialog();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topArea = (Composite)super.createDialogArea(parent);
        this.errorViewer = new TableViewer(topArea, 770);
        this.errorViewer.setSorter(this.getViewerSorter());
        this.errorViewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ErrorNotificationDialog.this.openErrorDialog();
            }
        });
        Control control = this.errorViewer.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        control.setLayoutData((Object)data);
        this.initContentProvider();
        this.initLabelProvider();
        this.initContextMenu();
        Dialog.applyDialogFont((Control)parent);
        return topArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ErrorNotificationDialog.this.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ErrorNotificationDialog.this.close();
            }
        });
    }

    private void createClearAllErrorsAction() {
        this.clearAllErrorsAction = new Action(ProgressMessages.getString("ProgressView.ClearAllAction")){

            public void run() {
                ErrorNotificationDialog.this.getManager().clearAllErrors();
                ErrorNotificationDialog.this.errorViewer.refresh();
            }
        };
    }

    private void createShowErrorAction() {
        this.showErrorAction = new Action(ProgressMessages.getString("ProgressView.ShowErrorAction")){

            public void run() {
                ErrorNotificationDialog.this.openErrorDialog();
            }
        };
    }

    private void createClearSelectionAction() {
        this.clearSelectionAction = new Action(ProgressMessages.getString("ErrorNotificationDialog.ClearSelectionAction")){

            public void run() {
                ISelection rawSelection = ErrorNotificationDialog.this.errorViewer.getSelection();
                if (rawSelection != null && rawSelection instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)rawSelection;
                    ErrorNotificationDialog.this.getManager().removeErrors(selection.toList());
                }
                ErrorNotificationDialog.this.refresh();
            }
        };
    }

    private ViewerSorter getViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer testViewer, Object e1, Object e2) {
                return ((Comparable)e1).compareTo(e2);
            }
        };
    }

    protected void initContentProvider() {
        IStructuredContentProvider provider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ErrorNotificationDialog.this.getManager().getErrors().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    ErrorNotificationDialog.this.refresh();
                }
            }
        };
        this.errorViewer.setContentProvider((IContentProvider)provider);
        this.errorViewer.setInput((Object)this.getManager());
    }

    private ErrorNotificationManager getManager() {
        return ProgressManager.getInstance().errorManager;
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.errorViewer.getControl());
        this.createShowErrorAction();
        this.createClearSelectionAction();
        this.createClearAllErrorsAction();
        menuMgr.add((IAction)this.clearSelectionAction);
        menuMgr.add((IAction)this.clearAllErrorsAction);
        menuMgr.add((IAction)this.showErrorAction);
        menuMgr.add((IContributionItem)new Separator("additions"));
        this.errorViewer.getControl().setMenu(menu);
    }

    void refresh() {
        this.errorViewer.refresh();
    }

    private void initLabelProvider() {
        ITableLabelProvider provider = new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return JFaceResources.getImageRegistry().get("ERROR_JOB");
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((ErrorInfo)element).getDisplayString();
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        this.errorViewer.setLabelProvider((IBaseLabelProvider)provider);
    }

    private void openErrorDialog() {
        IStructuredSelection selection;
        ISelection rawSelection = this.errorViewer.getSelection();
        if (rawSelection != null && rawSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)rawSelection).size() == 1) {
            ErrorInfo element = (ErrorInfo)selection.getFirstElement();
            ErrorDialog.openError((Shell)this.getShell(), (String)element.getDisplayString(), null, (IStatus)element.getErrorStatus());
        }
    }

    public boolean close() {
        this.getManager().clearAllErrors();
        return super.close();
    }
}

