/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    Layout layout;
    Control[] tabList;
    int scrolledVisibleRgn;
    int siblingsVisibleRgn;

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    Control[] _getChildren() {
        short[] count = new short[1];
        OS.CountSubControls((int)this.handle, (short[])count);
        if (count[0] == 0) {
            return new Control[0];
        }
        Control[] children = new Control[count[0]];
        int[] outControl = new int[1];
        int i = 0;
        int j = 0;
        while (i < count[0]) {
            Widget widget;
            int status = OS.GetIndexedSubControl((int)this.handle, (short)((short)(i + 1)), (int[])outControl);
            if (status == 0 && (widget = this.display.getWidget(outControl[0])) != null && widget != this && widget instanceof Control) {
                children[j++] = (Control)widget;
            }
            ++i;
        }
        if (j == count[0]) {
            return children;
        }
        Control[] newChildren = new Control[j];
        System.arraycopy(children, 0, newChildren, 0, j);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return null;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = this.layout != null ? (wHint == -1 || hHint == -1 ? this.layout.computeSize(this, wHint, hHint, changed) : new Point(wHint, hHint)) : this.minimumSize();
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    protected void checkSubclass() {
    }

    Control[] computeTabList() {
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length != 0) {
                Control[] newResult = new Control[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    void createHandle() {
        this.state |= 0x22;
        if ((this.style & 0xB00) != 0) {
            this.createScrolledHandle(this.parent.handle);
        } else {
            this.createHandle(this.parent.handle);
        }
    }

    void createHandle(int parentHandle) {
        int features = 262;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner((int)parentHandle);
        OS.CreateUserPaneControl((int)window, null, (int)features, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void createScrolledHandle(int parentHandle) {
        int features = 2;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner((int)parentHandle);
        OS.CreateUserPaneControl((int)window, null, (int)features, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.scrolledHandle = outControl[0];
        outControl[0] = 0;
        OS.CreateUserPaneControl((int)window, null, (int)(features |= 0x104), (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void drawBackground(int control) {
        if (control == this.scrolledHandle) {
            if ((this.style & 0x80000) == 0 && this.hooksKeys()) {
                this.drawFocus(control, this.hasFocus() && this.drawFocusRing(), this.hasBorder(), this.getParentBackground(), this.inset());
            } else {
                this.drawBackground(control, this.getParentBackground());
            }
        } else if ((this.state & 2) != 0 && (this.style & 0x40000) == 0) {
            this.drawBackground(control, this.background);
        }
    }

    void enableWidget(boolean enabled) {
        if ((this.state & 2) != 0) {
            if (this.horizontalBar != null) {
                this.horizontalBar.enableWidget(enabled);
            }
            if (this.verticalBar != null) {
                this.verticalBar.enableWidget(enabled);
            }
            return;
        }
        super.enableWidget(enabled);
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        short[] count = new short[1];
        OS.CountSubControls((int)this.handle, (short[])count);
        return count[0];
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    int getVisibleRegion(int control, boolean clipChildren) {
        if (!clipChildren && control == this.handle) {
            if (this.siblingsVisibleRgn == 0) {
                this.siblingsVisibleRgn = OS.NewRgn();
                this.calculateVisibleRegion(control, this.siblingsVisibleRgn, clipChildren);
            }
            int result = OS.NewRgn();
            OS.CopyRgn((int)this.siblingsVisibleRgn, (int)result);
            return result;
        }
        if (control == this.scrolledHandle) {
            if (!clipChildren) {
                return super.getVisibleRegion(control, clipChildren);
            }
            if (this.scrolledVisibleRgn == 0) {
                this.scrolledVisibleRgn = OS.NewRgn();
                this.calculateVisibleRegion(control, this.scrolledVisibleRgn, clipChildren);
            }
            int result = OS.NewRgn();
            OS.CopyRgn((int)this.scrolledVisibleRgn, (int)result);
            return result;
        }
        return super.getVisibleRegion(control, clipChildren);
    }

    int kEventControlClick(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlClick(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.state & 2) != 0) {
            if (!this.isEnabled()) {
                return result;
            }
            if ((this.style & 0x80000) == 0 && this.hooksKeys()) {
                int[] theControl = new int[1];
                int window = OS.GetControlOwner((int)this.handle);
                OS.GetKeyboardFocus((int)window, (int[])theControl);
                if (this.handle != theControl[0]) {
                    short[] count = new short[1];
                    OS.CountSubControls((int)this.handle, (short[])count);
                    if (count[0] == 0 && OS.SetKeyboardFocus((int)window, (int)this.handle, (short)-1) == 0) {
                        return 0;
                    }
                }
            }
        }
        return result;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.state & 2) != 0) {
            if (this.scrolledHandle != 0 && (this.style & 0x80000) == 0 && this.hooksKeys()) {
                short[] part = new short[1];
                OS.GetEventParameter((int)theEvent, (int)1668313716, (int)1668313716, null, (int)2, null, (short[])part);
                this.drawFocusClipped(this.scrolledHandle, part[0] != 0 && this.drawFocusRing(), this.hasBorder(), this.getParentBackground(), this.inset());
            }
            return 0;
        }
        return result;
    }

    int kEventRawKey(int nextHandler, int theEvent, int userData) {
        if ((this.state & 2) != 0) {
            int[] keyCode = new int[1];
            OS.GetEventParameter((int)theEvent, (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
            if (keyCode[0] == 49) {
                int[] modifiers = new int[1];
                OS.GetEventParameter((int)theEvent, (int)1802334052, (int)1835100014, null, (int)4, null, (int[])modifiers);
                if (modifiers[0] == 256 && !this.sendKeyEvent(1, theEvent)) {
                    return 0;
                }
            }
        }
        return -9874;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if ((this.state & 2) != 0) {
            int[] keyboardEvent = new int[1];
            OS.GetEventParameter((int)theEvent, (int)1953721189, (int)1702261350, null, (int)(keyboardEvent.length * 4), null, (int[])keyboardEvent);
            int[] keyCode = new int[1];
            OS.GetEventParameter((int)keyboardEvent[0], (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
            switch (keyCode[0]) {
                case 36: {
                    return 0;
                }
            }
        }
        return result;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    void invalidateChildrenVisibleRegion(int control) {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            child.resetVisibleRegion(control);
            child.invalidateChildrenVisibleRegion(control);
            ++i;
        }
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        int count = this.getChildrenCount();
        if (count == 0) {
            return;
        }
        this.layout.layout(this, changed);
    }

    Point minimumSize() {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    void releaseChildren() {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (!child.isDisposed()) {
                child.releaseResources();
            }
            ++i;
        }
    }

    void releaseWidget() {
        this.releaseChildren();
        super.releaseWidget();
        if (this.scrolledVisibleRgn != 0) {
            OS.DisposeRgn((int)this.scrolledVisibleRgn);
        }
        if (this.siblingsVisibleRgn != 0) {
            OS.DisposeRgn((int)this.siblingsVisibleRgn);
        }
        this.scrolledVisibleRgn = 0;
        this.siblingsVisibleRgn = 0;
        this.layout = null;
        this.tabList = null;
    }

    void resetVisibleRegion(int control) {
        if (this.scrolledVisibleRgn != 0) {
            OS.DisposeRgn((int)this.scrolledVisibleRgn);
            this.scrolledVisibleRgn = 0;
        }
        if (this.siblingsVisibleRgn != 0) {
            OS.DisposeRgn((int)this.siblingsVisibleRgn);
            this.siblingsVisibleRgn = 0;
        }
        super.resetVisibleRegion(control);
    }

    int setBounds(int control, int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(control, x, y, width, height, move, resize, events);
        if (this.layout != null && (result & 0x80) != 0) {
            this.layout.layout(this, false);
        }
        return result;
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].setFocus()) {
                return true;
            }
            ++i;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    boolean setTabGroupFocus() {
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
        }
        if (takeFocus && this.setTabItemFocus()) {
            return true;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.isTabItem() && child.setTabItemFocus()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    void setZOrder() {
        super.setZOrder();
        if (this.scrolledHandle != 0) {
            OS.HIViewAddSubview((int)this.scrolledHandle, (int)this.handle);
        }
    }

    int traversalCode(int key, int theEvent) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key, theEvent);
    }
}

