/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    Tree parent;
    TreeItem parentItem;
    int id;
    int index = -1;
    int width = -1;
    boolean checked;
    boolean grayed;
    Color foreground;
    Color background;
    Font font;

    public TreeItem(Tree parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, null, -1);
    }

    public TreeItem(Tree parent, int style, int index) {
        super(parent, style);
        if (index < 0) {
            this.error(6);
        }
        this.parent = parent;
        parent.createItem(this, null, index);
    }

    public TreeItem(TreeItem parentItem, int style) {
        super(TreeItem.checkNull((TreeItem)parentItem).parent, style);
        this.parent = parentItem.parent;
        this.parentItem = parentItem;
        this.parent.createItem(this, parentItem, -1);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        super(TreeItem.checkNull((TreeItem)parentItem).parent, style);
        if (index < 0) {
            this.error(6);
        }
        this.parent = parentItem.parent;
        this.parentItem = parentItem;
        this.parent.createItem(this, parentItem, index);
    }

    boolean _getExpanded() {
        this.checkWidget();
        int[] state = new int[1];
        OS.GetDataBrowserItemState((int)this.parent.handle, (int)this.id, (int[])state);
        return (state[0] & 2) != 0;
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    int calculateWidth(GC gc) {
        if (this.width != -1) {
            return this.width;
        }
        this.width = 0;
        Image image = this.getImage();
        String text = this.getText();
        if (image != null) {
            this.width += image.getBounds().width + 2;
        }
        if (text != null && text.length() > 0) {
            this.width += gc.stringExtent((String)text).x;
        }
        return this.width;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Color getBackground() {
        this.checkWidget();
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rect rect = new Rect();
        if (OS.GetDataBrowserItemPartBounds((int)this.parent.handle, (int)this.id, (int)1025, (int)0x2D2D2D2D, (Rect)rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = rect.left;
        int y = rect.top;
        int width = 0;
        if (this.image != null) {
            Rectangle bounds = this.image.getBounds();
            x += bounds.width + 2;
        }
        GC gc = new GC(this.parent);
        Point extent = gc.stringExtent(this.text);
        gc.dispose();
        int height = rect.bottom - rect.top;
        OS.GetControlBounds((int)this.parent.handle, (Rect)rect);
        return new Rectangle(x -= rect.left, y -= rect.top, width += extent.x, height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return (this.state & 0x100) != 0 ? false : this._getExpanded();
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Color getForeground() {
        this.checkWidget();
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.parent.getItemCount(this);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.parent.getItems(this);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    void redraw(int propertyID) {
        if (this.parent.drawCount != 0) {
            return;
        }
        int parentID = this.parentItem == null ? 0 : this.parentItem.id;
        OS.UpdateDataBrowserItems((int)this.parent.handle, (int)parentID, (int)1, (int[])new int[]{this.id}, (int)0, (int)propertyID);
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.parentItem = null;
        this.parent = null;
        this.id = 0;
        this.index = -1;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.background == color) {
            return;
        }
        if (this.background != null && this.background.equals(color)) {
            return;
        }
        this.background = color;
        this.redraw(1025);
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == checked) {
            return;
        }
        this.checked = checked;
        this.redraw(1024);
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this.parent.ignoreExpand = true;
        if (expanded) {
            OS.OpenDataBrowserContainer((int)this.parent.handle, (int)this.id);
        } else {
            OS.CloseDataBrowserContainer((int)this.parent.handle, (int)this.id);
        }
        this.parent.ignoreExpand = false;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (this.font != null && this.font.equals(font)) {
            return;
        }
        this.font = font;
        this.redraw(1025);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.foreground == color) {
            return;
        }
        if (this.foreground != null && this.foreground.equals(color)) {
            return;
        }
        this.foreground = color;
        this.redraw(1025);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        this.redraw(1024);
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        this.width = -1;
        this.parent.setScrollWidth(this);
        this.redraw(1025);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        this.width = -1;
        this.parent.setScrollWidth(this);
        this.redraw(1025);
    }
}

