/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.net.URL;
import java.util.Hashtable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import swingwt.awt.Dimension;
import swingwt.awt.Font;
import swingwt.awt.FontMetrics;
import swingwt.awt.GraphicsConfiguration;
import swingwt.awt.HeadlessException;
import swingwt.awt.Image;
import swingwt.awt.Insets;
import swingwt.awt.datatransfer.Clipboard;
import swingwt.awt.image.ColorModel;
import swingwt.awt.image.ImageConsumer;
import swingwt.awt.image.ImageProducer;
import swingwtx.swing.ImageIcon;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class Toolkit {
    private static Toolkit toolkit = new Toolkit();
    private static Object retval;
    private static Hashtable desktopProperties;
    private int isMac = 0;

    protected Toolkit() {
    }

    public static Toolkit getDefaultToolkit() {
        return toolkit;
    }

    public static Toolkit getToolkit() {
        return toolkit;
    }

    public Image getImage(String filename) {
        return new ImageIcon(filename).getImage();
    }

    public Image getImage(URL url) {
        return new ImageIcon(url).getImage();
    }

    public int getScreenResolution() {
        return SwingWTUtils.getDisplay().getDepth();
    }

    public Insets getScreenInsets(GraphicsConfiguration gc) throws HeadlessException {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getScreenInsets(gc);
        }
        return new Insets(0, 0, 0, 0);
    }

    public FontMetrics getFontMetrics(Font f) {
        return new FontMetrics(f);
    }

    private boolean isMac() {
        if (this.isMac == 0) {
            String vers = System.getProperty("os.name").toLowerCase();
            this.isMac = vers.indexOf("mac") != -1 ? 1 : -1;
        }
        return this.isMac > 0;
    }

    public int getMenuShortcutKeyMask() throws HeadlessException {
        if (this.isMac()) {
            return 4;
        }
        return 2;
    }

    public Dimension getScreenSize() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                retval = new Dimension(SwingWTUtils.getDisplay().getBounds().width, SwingWTUtils.getDisplay().getBounds().height);
            }
        });
        return (Dimension)retval;
    }

    public Image createImage(ImageProducer producer) {
        ToolkitImageConsumer tki = new ToolkitImageConsumer();
        producer.startProduction(tki);
        return tki.awtImage;
    }

    public Image createImage(byte[] imagedata) {
        return new ImageIcon(imagedata).getImage();
    }

    public Image createImage(byte[] imagedata, int imageoffset, int imagelength) {
        byte[] im2 = new byte[imagelength];
        for (int i = imageoffset; i < imagelength; ++i) {
            im2[i - imageoffset] = imagedata[i];
        }
        return new ImageIcon(im2).getImage();
    }

    public Image createImage(String filename) {
        return this.getImage(filename);
    }

    public Image createImage(URL url) {
        return this.getImage(url);
    }

    public Clipboard getSystemClipboard() {
        return new Clipboard();
    }

    public void beep() {
    }

    public final Object getDesktopProperty(String propertyName) {
        return desktopProperties.get(propertyName);
    }

    protected final void setDesktopProperty(String propertyName, Object value) {
        desktopProperties.put(propertyName, value);
    }

    public static String getProperty(String key, String defaultValue) {
        return defaultValue;
    }

    static {
        desktopProperties = new Hashtable();
    }

    private class ToolkitImageConsumer
    implements ImageConsumer {
        public Image awtImage = new Image();
        public boolean imageComplete = false;

        private ToolkitImageConsumer() {
        }

        public void imageComplete(int status) {
            this.imageComplete = true;
        }

        public void setColorModel(ColorModel model) {
        }

        public void setDimensions(int width, int height) {
            this.awtImage.image = new org.eclipse.swt.graphics.Image((Device)SwingWTUtils.getDisplay(), width, height);
        }

        public void setHints(int hintflags) {
        }

        public void setProperties(Hashtable props) {
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            byte[] bytes = new byte[pixels.length];
            for (int i = 0; i < pixels.length; ++i) {
                bytes[i] = (byte)pixels[i];
            }
            this.setPixels(x, y, w, h, model, bytes, off, scansize);
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
            this.awtImage.image = new org.eclipse.swt.graphics.Image((Device)SwingWTUtils.getDisplay(), new ImageData(w, h, 16, new PaletteData(255, 255, 255), scansize, pixels));
        }
    }
}

