/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.swt.graphics.Cursor;

public class ResizeTracker
extends SimpleDragTracker {
    private static int FLAG_TARGET_FEEDBACK;
    protected static final int MAX_FLAG;
    private int direction;
    private GraphicalEditPart owner;
    private PrecisionRectangle sourceRect;
    private SnapToHelper snapToHelper;
    static /* synthetic */ Class class$0;

    static {
        MAX_FLAG = FLAG_TARGET_FEEDBACK = 32;
    }

    public ResizeTracker(int direction) {
        this(null, direction);
    }

    public ResizeTracker(GraphicalEditPart owner, int direction) {
        this.owner = owner;
        this.direction = direction;
        this.setDisabledCursor(SharedCursors.NO);
    }

    public void activate() {
        super.activate();
        if (this.owner != null) {
            IFigure figure;
            if (this.getTargetEditPart() != null) {
                GraphicalEditPart graphicalEditPart = this.getTargetEditPart();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.gef.SnapToHelper");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.snapToHelper = (SnapToHelper)graphicalEditPart.getAdapter(clazz);
            }
            this.sourceRect = (figure = this.owner.getFigure()) instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()) : new PrecisionRectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)this.sourceRect);
        }
    }

    public void commitDrag() {
        this.eraseTargetFeedback();
        super.commitDrag();
    }

    protected List createOperationSet() {
        List list = super.createOperationSet();
        ToolUtilities.filterEditPartsUnderstanding(list, this.getSourceRequest());
        return list;
    }

    protected Request createSourceRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest("resize");
        request.setResizeDirection(this.getResizeDirection());
        return request;
    }

    public void deactivate() {
        this.eraseTargetFeedback();
        this.sourceRect = null;
        this.snapToHelper = null;
        super.deactivate();
    }

    protected void eraseTargetFeedback() {
        if (!this.getFlag(FLAG_TARGET_FEEDBACK)) {
            return;
        }
        if (this.getTargetEditPart() != null) {
            this.getTargetEditPart().eraseTargetFeedback(this.getSourceRequest());
        }
        this.setFlag(FLAG_TARGET_FEEDBACK, false);
    }

    protected Command getCommand() {
        List editparts = this.getOperationSet();
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Resize Handle Tracker");
        int i = 0;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            command.add(part.getCommand(this.getSourceRequest()));
            ++i;
        }
        return command.unwrap();
    }

    protected String getCommandName() {
        return "resize";
    }

    protected Cursor getDefaultCursor() {
        return SharedCursors.getDirectionalCursor((int)this.direction);
    }

    protected String getDebugName() {
        return "Resize Handle Tracker";
    }

    protected int getResizeDirection() {
        return this.direction;
    }

    protected GraphicalEditPart getTargetEditPart() {
        if (this.owner != null) {
            return (GraphicalEditPart)this.owner.getParent();
        }
        return null;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.performDrag();
        }
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInDragInProgress()) {
            this.updateSourceRequest();
            this.showSourceFeedback();
            this.showTargetFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected void showTargetFeedback() {
        if (this.getTargetEditPart() != null) {
            this.setFlag(FLAG_TARGET_FEEDBACK, true);
        }
        this.getTargetEditPart().showTargetFeedback(this.getSourceRequest());
    }

    protected void updateSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point moveDelta = new Point(0, 0);
        Dimension resizeDelta = new Dimension(0, 0);
        if (this.getCurrentInput().isShiftKeyDown() && this.owner != null) {
            request.setConstrainedResize(true);
            int origHeight = this.owner.getFigure().getBounds().height;
            int origWidth = this.owner.getFigure().getBounds().width;
            float ratio = 1.0f;
            if (origWidth != 0 && origHeight != 0) {
                ratio = (float)origHeight / (float)origWidth;
            }
            if (this.getResizeDirection() == 20) {
                if ((float)d.height > (float)d.width * ratio) {
                    d.width = (int)((float)d.height / ratio);
                } else {
                    d.height = (int)((float)d.width * ratio);
                }
            } else if (this.getResizeDirection() == 9) {
                if ((float)d.height < (float)d.width * ratio) {
                    d.width = (int)((float)d.height / ratio);
                } else {
                    d.height = (int)((float)d.width * ratio);
                }
            } else if (this.getResizeDirection() == 17) {
                if ((float)(-d.height) > (float)d.width * ratio) {
                    d.width = -((int)((float)d.height / ratio));
                } else {
                    d.height = -((int)((float)d.width * ratio));
                }
            } else if (this.getResizeDirection() == 12) {
                if ((float)(-d.height) < (float)d.width * ratio) {
                    d.width = -((int)((float)d.height / ratio));
                } else {
                    d.height = -((int)((float)d.width * ratio));
                }
            }
        } else {
            request.setConstrainedResize(false);
        }
        request.setCenteredResize(this.getCurrentInput().isControlKeyDown());
        if ((this.getResizeDirection() & 1) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                resizeDelta.height -= d.height;
            }
            moveDelta.y += d.height;
            resizeDelta.height -= d.height;
        }
        if ((this.getResizeDirection() & 4) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                moveDelta.y -= d.height;
                resizeDelta.height += d.height;
            }
            resizeDelta.height += d.height;
        }
        if ((this.getResizeDirection() & 8) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                resizeDelta.width -= d.width;
            }
            moveDelta.x += d.width;
            resizeDelta.width -= d.width;
        }
        if ((this.getResizeDirection() & 0x10) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                moveDelta.x -= d.width;
                resizeDelta.width += d.width;
            }
            resizeDelta.width += d.width;
        }
        request.setMoveDelta(moveDelta);
        request.setSizeDelta(resizeDelta);
        request.setLocation(location);
        request.setEditParts(this.getOperationSet());
        request.getExtendedData().clear();
        if (!this.getCurrentInput().isAltKeyDown() && this.snapToHelper != null) {
            PrecisionRectangle rect = this.sourceRect.getPreciseCopy();
            rect.translate(moveDelta);
            rect.resize(resizeDelta);
            PrecisionRectangle result = new PrecisionRectangle();
            this.snapToHelper.snapRectangle((Request)request, request.getResizeDirection(), rect, result);
            if (request.isCenteredResize()) {
                if (result.preciseX != 0.0) {
                    result.preciseWidth += -result.preciseX;
                } else if (result.preciseWidth != 0.0) {
                    result.preciseX = -result.preciseWidth;
                    result.preciseWidth *= 2.0;
                }
                if (result.preciseY != 0.0) {
                    result.preciseHeight += -result.preciseY;
                } else if (result.preciseHeight != 0.0) {
                    result.preciseY = -result.preciseHeight;
                    result.preciseHeight *= 2.0;
                }
                result.updateInts();
            }
            PrecisionPoint preciseMove = new PrecisionPoint(result.x + moveDelta.x, result.y + moveDelta.y);
            PrecisionDimension preciseResize = new PrecisionDimension((double)(result.width + resizeDelta.width), (double)(result.height + resizeDelta.height));
            request.setMoveDelta((Point)preciseMove);
            request.setSizeDelta((Dimension)preciseResize);
        }
    }
}

