/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Menu.java,v $
   Revision 1.7  2004/10/30 20:11:54  bobintetley
   Code cleanup

   Revision 1.6  2004/06/11 03:29:26  dannaab
   AWT improvements: implement Button over JButton; Menu fixes; add missing geom me
   thods; add some missing awt event methods/features

   Revision 1.5  2004/06/10 07:57:57  dannaab
   Added AWTSwingWrapper to map AWT components to the corresponding Swing version.  Implemted using it: TextComponent, TextArea, TextField; used similar technique for Menu components

   Revision 1.4  2004/01/15 10:11:14  bobintetley
   Fixed AWT constructors/hierarchy

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwt.awt;

import java.util.HashMap;

import swingwtx.swing.JComponent;
import swingwtx.swing.JMenu;
import swingwtx.swing.JMenuItem;

public class Menu extends MenuItem implements MenuContainer {
    
    public Menu() { swingPeer = new JMenu(); }
    public Menu(String text) { swingPeer = new JMenu(text); }
    
    private JMenu getSwingPeer() { return (JMenu) swingPeer; }

    // Maintains a cache of MenuItems mapped to the corresponding JMenuItems
    private HashMap menuItems = new HashMap();
    
    private void addItemToCache(MenuItem menuItem) {
        menuItems.put(menuItem.swingPeer, menuItem);
    }
    
    private void removeItemFromCache(Object menuComponent) {
        menuItems.remove(menuComponent);
    }
    
    private MenuItem getItemForPeer(JMenuItem jMenuItem) {
        return (MenuItem) menuItems.get(jMenuItem);
    }
    
    public MenuItem add(MenuItem mi) { getSwingPeer().add((JMenuItem) mi.swingPeer); addItemToCache(mi); return mi; }
    public void add(String label) { MenuItem menuItem = new MenuItem(label); getSwingPeer().add(menuItem.swingPeer); }
    public void addSeparator() { getSwingPeer().addSeparator(); }
    public int countItems() { return getItemCount(); }
    public MenuItem getItem(int index) { JMenuItem menuItem = getSwingPeer().getItem(index); return getItemForPeer(menuItem); }
    public int getItemCount() { return getSwingPeer().getItemCount(); }
    public void insert(MenuItem menuitem, int index) {  }
    public void insert(String label, int index) {  }
    public void insertSeparator(int index) {  }
    public boolean isTearOff() { return getSwingPeer().isTearOff(); }
    public void remove(int index) { JMenuItem menuItem = getSwingPeer().getItem(index); getSwingPeer().remove(index); removeItemFromCache(menuItem); }
    public void remove(MenuComponent item) { JComponent comp = item.swingPeer; getSwingPeer().remove(comp); removeItemFromCache(comp); }
    public void removeAll() { getSwingPeer().removeAll(); menuItems.clear(); }
}
