/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: SwingUtilities.java,v $
   Revision 1.16  2004/10/30 20:11:57  bobintetley
   Code cleanup

   Revision 1.15  2004/04/23 00:52:32  dannaab
   Handle borders in a Swing-like way. Implement EmptyBorder & TitledBorder

   Revision 1.14  2004/04/15 11:24:33  bobintetley
   (Dan Naab) ComponentUI, UIDefaults/UIManager and Accessibility support.
   (Antonio Weber) TableColumnModelListener implementation and support

   Revision 1.13  2004/03/01 15:58:47  bobintetley
   Various little bug fixes

   Revision 1.12  2004/02/03 09:21:21  bobintetley
   Fixed threading bug in invokeIn, and JComboBox hotkeys

   Revision 1.11  2004/01/23 08:05:49  bobintetley
   JComboBox fixes and better Action implementation

   Revision 1.10  2004/01/20 15:52:56  bobintetley
   Code from an anonymous developer

   Revision 1.9  2004/01/20 07:38:05  bobintetley
   Bug fixes and compatibility methods

   Revision 1.8  2004/01/16 15:53:32  bobintetley
   Many compatibility methods added to Container, Component, JInternalFrame,
      UIManager, SwingUtilities, JTabbedPane, JPasswordField, JCheckBox
      and JRadioButton.

   Revision 1.7  2004/01/16 09:35:47  bobintetley
   Full event dispatch thread support!

   Revision 1.6  2003/12/22 14:17:30  bobintetley
   One-off timer method and better layout management for tabbedPane

   Revision 1.5  2003/12/17 15:24:33  bobintetley
   Threading fixes

   Revision 1.4  2003/12/16 15:47:45  bobintetley
   Thread safety added to common methods

   Revision 1.3  2003/12/16 14:51:16  bobintetley
   Fixed hang when a window close event closes itself again

   Revision 1.2  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing;

import swingwt.awt.*;
import swingwtx.accessibility.*;

public abstract class SwingUtilities implements SwingConstants {
    
    public static void invokeAndWait(Runnable run) {
        invokeSync(run);
    }
    
    public static void invokeLater(Runnable run) {
        invokeAsync(run);
    }
    
    /**
     * Invokes a call asynchronously.
     */
    public static void invokeAsync(Runnable run) {
        SwingWTUtils.checkEventDispatcher();
        SwingWTUtils.getDisplay().asyncExec(run);
    }
    
    /**
     * Invokes a call synchronously. Since we use this a lot for SwingWT
     * internals, we check to see if we are already on the dispatch thread
     * (which is likely in many places) - if we are, we can just run
     * the code right off without queuing it.
     */
    public static void invokeSync(Runnable run) {
        SwingWTUtils.checkEventDispatcher();
        if (Thread.currentThread().equals( SwingWTUtils.getDisplay().getThread() ))
            run.run();
        else
            SwingWTUtils.getDisplay().syncExec(run);
    }
    
    /**
     * Invokes a call in a specified interval of time
     */
    public static void invokeIn(Runnable run, int milliseconds) {
        SwingWTUtils.checkEventDispatcher();
        SwingWTUtils.getDisplay().timerExec(milliseconds, run);
    }
    
    public static void updateComponentTreeUI(Component c) {
        if (c instanceof Container) ((Container) c).invalidate();    
        c.repaint();
    }
    
    /** 
     *  Searches the component hierarchy above comp for the first
     *  instance of class type c
     */
    public static Container getAncestorOfClass(Class c, Component comp) {
        if(comp == null || c == null)
            return null;
        Container parent = comp.getParent();
        while(parent != null && !(c.isInstance(parent)))
            parent = parent.getParent();
        return parent;
    }
    
    // TODO: Implement Accessible support
    public static int getAccessibleChildrenCount(Component component) { return 0; }
    public static Accessible getAccessibleChild(Component component, int i) { 
        return component.getAccessibleContext().getAccessibleChild(i); 
    }
        
}
