/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventCrossing;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.GdkEventScroll;
import org.eclipse.swt.internal.gtk.GdkEventVisibility;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XWindowChanges;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    int fixedHandle;
    int redrawWindow;
    int enableWindow;
    int drawCount;
    Composite parent;
    Cursor cursor;
    Menu menu;
    Font font;
    String toolTipText;
    Object layoutData;
    Accessible accessible;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(0);
    }

    int defaultFont() {
        return this.display.defaultFont;
    }

    void deregister() {
        int imHandle;
        super.deregister();
        if (this.fixedHandle != 0) {
            this.display.removeWidget(this.fixedHandle);
        }
        if ((imHandle = this.imHandle()) != 0) {
            this.display.removeWidget(imHandle);
        }
    }

    boolean drawGripper(int x, int y, int width, int height) {
        int paintHandle = this.paintHandle();
        int window = OS.GTK_WIDGET_WINDOW((int)paintHandle);
        if (window == 0) {
            return false;
        }
        OS.gtk_paint_handle((int)OS.gtk_widget_get_style((int)paintHandle), (int)window, (int)0, (int)2, null, (int)paintHandle, (byte[])new byte[1], (int)x, (int)y, (int)width, (int)height, (int)1);
        return true;
    }

    void enableWidget(boolean enabled) {
        OS.gtk_widget_set_sensitive((int)this.handle, (boolean)enabled);
    }

    int eventHandle() {
        return this.handle;
    }

    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        while ((control = control.parent) != null) {
            if (control.setFocus()) {
                return;
            }
            if (control == shell) break;
        }
        shell.setSavedFocus(focusControl);
        int focusHandle = shell.fixedHandle;
        OS.GTK_WIDGET_SET_FLAGS((int)focusHandle, (int)2048);
        OS.gtk_widget_grab_focus((int)focusHandle);
        OS.GTK_WIDGET_UNSET_FLAGS((int)focusHandle, (int)2048);
    }

    int focusHandle() {
        return this.handle;
    }

    int fontHandle() {
        return this.handle;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    void hookEvents() {
        int windowProc2 = this.display.windowProc2;
        int windowProc3 = this.display.windowProc3;
        int focusHandle = this.focusHandle();
        int focusMask = 19456;
        OS.gtk_widget_add_events((int)focusHandle, (int)focusMask);
        OS.g_signal_connect((int)focusHandle, (byte[])OS.popup_menu, (int)windowProc2, (int)30);
        OS.g_signal_connect((int)focusHandle, (byte[])OS.show_help, (int)windowProc3, (int)38);
        OS.g_signal_connect((int)focusHandle, (byte[])OS.key_press_event, (int)windowProc3, (int)21);
        OS.g_signal_connect((int)focusHandle, (byte[])OS.key_release_event, (int)windowProc3, (int)22);
        OS.g_signal_connect((int)focusHandle, (byte[])OS.focus, (int)windowProc3, (int)15);
        OS.g_signal_connect((int)focusHandle, (byte[])OS.focus_in_event, (int)windowProc3, (int)16);
        OS.g_signal_connect((int)focusHandle, (byte[])OS.focus_out_event, (int)windowProc3, (int)17);
        int eventHandle = this.eventHandle();
        int eventMask = 13060;
        OS.gtk_widget_add_events((int)eventHandle, (int)eventMask);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.button_press_event, (int)windowProc3, (int)2);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.button_release_event, (int)windowProc3, (int)3);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.motion_notify_event, (int)windowProc3, (int)27);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.enter_notify_event, (int)windowProc3, (int)11);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.leave_notify_event, (int)windowProc3, (int)23);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.scroll_event, (int)windowProc3, (int)35);
        OS.g_signal_connect_after((int)eventHandle, (byte[])OS.button_press_event, (int)windowProc3, (int)-2);
        OS.g_signal_connect_after((int)eventHandle, (byte[])OS.button_release_event, (int)windowProc3, (int)-3);
        OS.g_signal_connect_after((int)eventHandle, (byte[])OS.motion_notify_event, (int)windowProc3, (int)-27);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.event_after, (int)windowProc3, (int)13);
        if (focusHandle != eventHandle) {
            OS.g_signal_connect((int)focusHandle, (byte[])OS.event_after, (int)windowProc3, (int)13);
        }
        int paintHandle = this.paintHandle();
        int paintMask = 131074;
        OS.gtk_widget_add_events((int)paintHandle, (int)paintMask);
        OS.g_signal_connect((int)paintHandle, (byte[])OS.expose_event, (int)windowProc3, (int)-14);
        OS.g_signal_connect((int)paintHandle, (byte[])OS.visibility_notify_event, (int)windowProc3, (int)49);
        OS.g_signal_connect_after((int)paintHandle, (byte[])OS.expose_event, (int)windowProc3, (int)14);
        OS.g_signal_connect_after((int)this.handle, (byte[])OS.realize, (int)windowProc2, (int)32);
        OS.g_signal_connect((int)this.handle, (byte[])OS.unrealize, (int)windowProc2, (int)47);
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            OS.g_signal_connect((int)imHandle, (byte[])OS.commit, (int)windowProc3, (int)6);
            OS.g_signal_connect((int)imHandle, (byte[])OS.preedit_changed, (int)windowProc2, (int)31);
        }
        int topHandle = this.topHandle();
        OS.g_signal_connect_after((int)topHandle, (byte[])OS.map, (int)windowProc2, (int)24);
    }

    int hoverProc(int widget) {
        if (!this.hooks(32) && !this.filters(32)) {
            return 0;
        }
        Event event = new Event();
        int[] x = new int[1];
        int[] y = new int[1];
        int[] mask = new int[1];
        OS.gdk_window_get_pointer((int)0, (int[])x, (int[])y, (int[])mask);
        event.x = x[0];
        event.y = y[0];
        int eventHandle = this.eventHandle();
        int window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
        OS.gdk_window_get_origin((int)window, (int[])x, (int[])y);
        event.x -= x[0];
        event.y -= y[0];
        this.setInputState(event, mask[0]);
        this.postEvent(32, event);
        return 0;
    }

    int topHandle() {
        if (this.fixedHandle != 0) {
            return this.fixedHandle;
        }
        return super.topHandle();
    }

    int paintHandle() {
        int topHandle = this.topHandle();
        int paintHandle = this.handle;
        while (paintHandle != topHandle) {
            if ((OS.GTK_WIDGET_FLAGS((int)paintHandle) & 0x20) == 0) break;
            paintHandle = OS.gtk_widget_get_parent((int)paintHandle);
        }
        return paintHandle;
    }

    int paintWindow() {
        int paintHandle = this.paintHandle();
        OS.gtk_widget_realize((int)paintHandle);
        return OS.GTK_WIDGET_WINDOW((int)paintHandle);
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    void checkBorder() {
        if (this.getBorderWidth() == 0) {
            this.style &= 0xFFFFF7FF;
        }
    }

    void createWidget(int index) {
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.showWidget();
        this.setInitialBounds();
        this.setZOrder(null, false);
        this.checkBorder();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        return this.computeNativeSize(this.handle, wHint, hHint, changed);
    }

    Point computeNativeSize(int h, int wHint, int hHint, boolean changed) {
        int width = wHint;
        int height = hHint;
        if (wHint == -1 || hHint == -1) {
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request((int)h, (GtkRequisition)requisition);
            width = wHint == -1 ? OS.GTK_WIDGET_REQUISITION_WIDTH((int)h) : wHint;
            height = hHint == -1 ? OS.GTK_WIDGET_REQUISITION_HEIGHT((int)h) : hHint;
        }
        return new Point(width, height);
    }

    void forceResize() {
        int topHandle = this.topHandle();
        int flags = OS.GTK_WIDGET_FLAGS((int)topHandle);
        OS.GTK_WIDGET_SET_FLAGS((int)topHandle, (int)256);
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)topHandle, (GtkRequisition)requisition);
        GtkAllocation allocation = new GtkAllocation();
        allocation.x = OS.GTK_WIDGET_X((int)topHandle);
        allocation.y = OS.GTK_WIDGET_Y((int)topHandle);
        allocation.width = OS.GTK_WIDGET_WIDTH((int)topHandle);
        allocation.height = OS.GTK_WIDGET_HEIGHT((int)topHandle);
        OS.gtk_widget_size_allocate((int)topHandle, (GtkAllocation)allocation);
        if ((flags & 0x100) == 0) {
            OS.GTK_WIDGET_UNSET_FLAGS((int)topHandle, (int)256);
        }
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int x = OS.GTK_WIDGET_X((int)topHandle);
        int y = OS.GTK_WIDGET_Y((int)topHandle);
        if ((this.state & 0x800) != 0) {
            return new Rectangle(x, y, 0, 0);
        }
        int width = OS.GTK_WIDGET_WIDTH((int)topHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)topHandle);
        return new Rectangle(x, y, width, height);
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(x, y, Math.max(0, width), Math.max(0, height), true, true);
    }

    void markLayout(boolean changed, boolean all) {
    }

    void moveHandle(int x, int y) {
        int topHandle = this.topHandle();
        int parentHandle = this.parent.parentingHandle();
        OS.gtk_fixed_move((int)parentHandle, (int)topHandle, (int)x, (int)y);
    }

    void resizeHandle(int width, int height) {
        int topHandle = this.topHandle();
        OS.gtk_widget_set_size_request((int)topHandle, (int)width, (int)height);
        if (topHandle != this.handle) {
            OS.gtk_widget_set_size_request((int)this.handle, (int)width, (int)height);
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int topHandle = this.topHandle();
        int flags = OS.GTK_WIDGET_FLAGS((int)topHandle);
        OS.GTK_WIDGET_SET_FLAGS((int)topHandle, (int)256);
        boolean sameOrigin = true;
        boolean sameExtent = true;
        if (move) {
            int oldX = OS.GTK_WIDGET_X((int)topHandle);
            int oldY = OS.GTK_WIDGET_Y((int)topHandle);
            boolean bl = sameOrigin = x == oldX && y == oldY;
            if (!sameOrigin) {
                if (this.enableWindow != 0) {
                    OS.gdk_window_move((int)this.enableWindow, (int)x, (int)y);
                }
                this.moveHandle(x, y);
            }
        }
        if (resize) {
            int oldWidth = 0;
            int oldHeight = 0;
            if ((this.state & 0x800) == 0) {
                oldWidth = OS.GTK_WIDGET_WIDTH((int)topHandle);
                oldHeight = OS.GTK_WIDGET_HEIGHT((int)topHandle);
            }
            boolean bl = sameExtent = width == oldWidth && height == oldHeight;
            if (!(sameExtent || width == 0 && height == 0)) {
                int newWidth = Math.max(1, width);
                int newHeight = Math.max(1, height);
                if (this.redrawWindow != 0) {
                    OS.gdk_window_resize((int)this.redrawWindow, (int)newWidth, (int)newHeight);
                }
                if (this.enableWindow != 0) {
                    OS.gdk_window_resize((int)this.enableWindow, (int)newWidth, (int)newHeight);
                }
                this.resizeHandle(newWidth, newHeight);
            }
        }
        if (!sameOrigin || !sameExtent) {
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request((int)topHandle, (GtkRequisition)requisition);
            GtkAllocation allocation = new GtkAllocation();
            if (move) {
                allocation.x = x;
                allocation.y = y;
            } else {
                allocation.x = OS.GTK_WIDGET_X((int)topHandle);
                allocation.y = OS.GTK_WIDGET_Y((int)topHandle);
            }
            if (resize) {
                allocation.width = width;
                allocation.height = height;
            } else {
                allocation.width = OS.GTK_WIDGET_WIDTH((int)topHandle);
                allocation.height = OS.GTK_WIDGET_HEIGHT((int)topHandle);
            }
            OS.gtk_widget_size_allocate((int)topHandle, (GtkAllocation)allocation);
        }
        if ((flags & 0x100) == 0) {
            OS.GTK_WIDGET_UNSET_FLAGS((int)topHandle, (int)256);
        }
        if (!sameExtent) {
            if (width == 0 && height == 0) {
                this.state |= 0x800;
                if (this.enableWindow != 0) {
                    OS.gdk_window_hide((int)this.enableWindow);
                }
                OS.gtk_widget_hide((int)topHandle);
            } else {
                this.state &= 0xFFFFF7FF;
                if ((this.state & 0x1000) == 0) {
                    if (this.enableWindow != 0) {
                        OS.gdk_window_show_unraised((int)this.enableWindow);
                    }
                    OS.gtk_widget_show((int)topHandle);
                }
            }
        }
        int result = 0;
        if (move && !sameOrigin) {
            this.sendEvent(10);
            result |= 0x80;
        }
        if (resize && !sameExtent) {
            this.sendEvent(11);
            result |= 0x100;
        }
        return result;
    }

    public Point getLocation() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int x = OS.GTK_WIDGET_X((int)topHandle);
        int y = OS.GTK_WIDGET_Y((int)topHandle);
        return new Point(x, y);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, 0, 0, true, false);
    }

    public Point getSize() {
        this.checkWidget();
        if ((this.state & 0x800) != 0) {
            return new Point(0, 0);
        }
        int topHandle = this.topHandle();
        int width = OS.GTK_WIDGET_WIDTH((int)topHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)topHandle);
        return new Point(width, height);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, width), Math.max(0, height), false, true);
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false);
    }

    public void pack() {
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.setSize(this.computeSize(-1, -1, changed));
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        int eventHandle = this.eventHandle();
        OS.gtk_widget_realize((int)eventHandle);
        int window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
        return new Point(x - origin_x[0], y - origin_y[0]);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        int eventHandle = this.eventHandle();
        OS.gtk_widget_realize((int)eventHandle);
        int window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
        return new Point(origin_x[0] + x, origin_y[0] + y);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    boolean filterKey(int keyval, int event) {
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            return OS.gtk_im_context_filter_keypress((int)imHandle, (int)event);
        }
        return false;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        oldShell.fixShell(newShell, this);
        oldDecorations.fixDecorations(newDecorations, this, menus);
    }

    int fixedMapProc(int widget) {
        OS.GTK_WIDGET_SET_FLAGS((int)widget, (int)128);
        int widgetList = OS.gtk_container_get_children((int)widget);
        if (widgetList != 0) {
            int widgets = widgetList;
            while (widgets != 0) {
                int child = OS.g_list_data((int)widgets);
                if (OS.GTK_WIDGET_VISIBLE((int)child) && OS.gtk_widget_get_child_visible((int)child) && !OS.GTK_WIDGET_MAPPED((int)child)) {
                    OS.gtk_widget_map((int)child);
                }
                widgets = OS.g_list_next((int)widgets);
            }
            OS.g_list_free((int)widgetList);
        }
        if ((OS.GTK_WIDGET_FLAGS((int)widget) & 0x20) == 0) {
            OS.gdk_window_show_unraised((int)OS.GTK_WIDGET_WINDOW((int)widget));
        }
        return 0;
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Shell shell = this.getShell();
        shell.setSavedFocus(this);
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        shell.bringToTop(false);
        return this.forceFocus(this.focusHandle());
    }

    boolean forceFocus(int focusHandle) {
        OS.gtk_widget_grab_focus((int)focusHandle);
        Shell shell = this.getShell();
        int shellHandle = shell.shellHandle;
        int handle = OS.gtk_window_get_focus((int)shellHandle);
        while (handle != 0) {
            if (handle == focusHandle) {
                return true;
            }
            if (this.display.getWidget(handle) != null) {
                return false;
            }
            handle = OS.gtk_widget_get_parent((int)handle);
        }
        return false;
    }

    public Color getBackground() {
        this.checkWidget();
        return Color.gtk_new(this.display, this.getBackgroundColor());
    }

    GdkColor getBackgroundColor() {
        return this.getBgColor();
    }

    GdkColor getBgColor() {
        int fontHandle = this.fontHandle();
        OS.gtk_widget_realize((int)fontHandle);
        GdkColor color = new GdkColor();
        OS.gtk_style_get_bg((int)OS.gtk_widget_get_style((int)fontHandle), (int)0, (GdkColor)color);
        return color;
    }

    GdkColor getBaseColor() {
        int fontHandle = this.fontHandle();
        OS.gtk_widget_realize((int)fontHandle);
        GdkColor color = new GdkColor();
        OS.gtk_style_get_base((int)OS.gtk_widget_get_style((int)fontHandle), (int)0, (GdkColor)color);
        return color;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return Font.gtk_new(this.display, this.defaultFont());
    }

    int getFontDescription() {
        int fontHandle = this.fontHandle();
        return OS.gtk_style_get_font_desc((int)OS.gtk_widget_get_style((int)fontHandle));
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.gtk_new(this.display, this.getForegroundColor());
    }

    GdkColor getForegroundColor() {
        return this.getFgColor();
    }

    GdkColor getFgColor() {
        int fontHandle = this.fontHandle();
        OS.gtk_widget_realize((int)fontHandle);
        GdkColor color = new GdkColor();
        OS.gtk_style_get_fg((int)OS.gtk_widget_get_style((int)fontHandle), (int)0, (GdkColor)color);
        return color;
    }

    Point getIMCaretPos() {
        return new Point(0, 0);
    }

    GdkColor getTextColor() {
        int fontHandle = this.fontHandle();
        OS.gtk_widget_realize((int)fontHandle);
        GdkColor color = new GdkColor();
        OS.gtk_style_get_text((int)OS.gtk_widget_get_style((int)fontHandle), (int)0, (GdkColor)color);
        return color;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        Monitor monitor = null;
        int screen = OS.gdk_screen_get_default();
        if (screen != 0) {
            int monitorNumber = OS.gdk_screen_get_monitor_at_window((int)screen, (int)this.paintWindow());
            GdkRectangle dest = new GdkRectangle();
            OS.gdk_screen_get_monitor_geometry((int)screen, (int)monitorNumber, (GdkRectangle)dest);
            monitor = new Monitor();
            monitor.handle = monitorNumber;
            monitor.x = dest.x;
            monitor.y = dest.y;
            monitor.width = dest.width;
            monitor.height = dest.height;
            monitor.clientX = monitor.x;
            monitor.clientY = monitor.y;
            monitor.clientWidth = monitor.width;
            monitor.clientHeight = monitor.height;
        } else {
            monitor = this.display.getPrimaryMonitor();
        }
        return monitor;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Shell getShell() {
        this.checkWidget();
        return this._getShell();
    }

    Shell _getShell() {
        return this.parent._getShell();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x1000) == 0;
    }

    int gtk_button_press_event(int widget, int event) {
        Shell shell = this._getShell();
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        if (gdkEvent.type == 6) {
            return 0;
        }
        this.display.dragStartX = (int)gdkEvent.x;
        this.display.dragStartY = (int)gdkEvent.y;
        this.display.dragging = false;
        int button = gdkEvent.button;
        int type = gdkEvent.type != 5 ? 3 : 8;
        this.sendMouseEvent(type, button, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, gdkEvent.state, event);
        int result = 0;
        if ((this.state & 0x20) != 0 && gdkEvent.button == 3 && gdkEvent.type == 4 && this.showMenu((int)gdkEvent.x_root, (int)gdkEvent.y_root)) {
            result = 1;
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        return result;
    }

    int gtk_button_release_event(int widget, int event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        int button = gdkEvent.button;
        if (button == -6) {
            button = 4;
        }
        if (button == -7) {
            button = 5;
        }
        this.sendMouseEvent(4, button, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, gdkEvent.state, event);
        return 0;
    }

    int gtk_commit(int imcontext, int text) {
        if (text == 0) {
            return 0;
        }
        int length = OS.strlen((int)text);
        if (length == 0) {
            return 0;
        }
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)text, (int)length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        this.sendIMKeyEvent(1, null, chars);
        return 0;
    }

    int gtk_enter_notify_event(int widget, int event) {
        GdkEventCrossing gdkEvent = new GdkEventCrossing();
        OS.memmove((GdkEventCrossing)gdkEvent, (int)event, (int)GdkEventCrossing.sizeof);
        if (gdkEvent.mode != 0) {
            return 0;
        }
        if (gdkEvent.subwindow != 0) {
            return 0;
        }
        this.sendMouseEvent(6, 0, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, gdkEvent.state, event);
        return 0;
    }

    int gtk_event_after(int widget, int gdkEvent) {
        GdkEvent event = new GdkEvent();
        OS.memmove((GdkEvent)event, (int)gdkEvent, (int)GdkEvent.sizeof);
        switch (event.type) {
            case 4: {
                if (widget != this.eventHandle() || (this.state & 0x20) != 0) break;
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove((GdkEventButton)gdkEventButton, (int)gdkEvent, (int)GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
                break;
            }
            case 12: {
                if (widget != this.focusHandle()) break;
                GdkEventFocus gdkEventFocus = new GdkEventFocus();
                OS.memmove((GdkEventFocus)gdkEventFocus, (int)gdkEvent, (int)GdkEventFocus.sizeof);
                this.sendFocusEvent(gdkEventFocus.in != 0 ? 15 : 16);
            }
        }
        return 0;
    }

    int gtk_expose_event(int widget, int eventPtr) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        GdkEventExpose gdkEvent = new GdkEventExpose();
        OS.memmove((GdkEventExpose)gdkEvent, (int)eventPtr, (int)GdkEventExpose.sizeof);
        Event event = new Event();
        event.count = gdkEvent.count;
        event.x = gdkEvent.area_x;
        event.y = gdkEvent.area_y;
        event.width = gdkEvent.area_width;
        event.height = gdkEvent.area_height;
        GCData data = new GCData();
        data.damageRgn = gdkEvent.region;
        GC gc = event.gc = GC.gtk_new(this, data);
        OS.gdk_gc_set_clip_region((int)gc.handle, (int)gdkEvent.region);
        this.sendEvent(9, event);
        gc.dispose();
        event.gc = null;
        return 0;
    }

    int gtk_focus(int widget, int directionType) {
        return 1;
    }

    int gtk_focus_in_event(int widget, int event) {
        if (this.handle != 0) {
            int imHandle;
            int oldIMHandle;
            Control oldControl = this.display.imControl;
            if (oldControl != this && oldControl != null && !oldControl.isDisposed() && (oldIMHandle = oldControl.imHandle()) != 0) {
                OS.gtk_im_context_reset((int)oldIMHandle);
            }
            if ((this.hooks(1) || this.hooks(2)) && (imHandle = this.imHandle()) != 0) {
                OS.gtk_im_context_focus_in((int)imHandle);
            }
        }
        return 0;
    }

    int gtk_focus_out_event(int widget, int event) {
        int imHandle;
        if (this.handle != 0 && (this.hooks(1) || this.hooks(2)) && (imHandle = this.imHandle()) != 0) {
            OS.gtk_im_context_focus_out((int)imHandle);
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        if (!this.hasFocus()) {
            return 0;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove((GdkEventKey)gdkEvent, (int)event, (int)GdkEventKey.sizeof);
        if (this.translateMnemonic(gdkEvent.keyval, gdkEvent)) {
            return 1;
        }
        if (this.isDisposed()) {
            return 0;
        }
        if (this.filterKey(gdkEvent.keyval, event)) {
            return 1;
        }
        if (this.isDisposed()) {
            return 0;
        }
        if (this.translateTraversal(gdkEvent)) {
            return 1;
        }
        if (this.isDisposed()) {
            return 0;
        }
        return super.gtk_key_press_event(widget, event);
    }

    int gtk_key_release_event(int widget, int event) {
        if (!this.hasFocus()) {
            return 0;
        }
        int imHandle = this.imHandle();
        if (imHandle != 0 && OS.gtk_im_context_filter_keypress((int)imHandle, (int)event)) {
            return 1;
        }
        return super.gtk_key_release_event(widget, event);
    }

    int gtk_leave_notify_event(int widget, int event) {
        this.display.removeMouseHoverTimeout(this.handle);
        GdkEventCrossing gdkEvent = new GdkEventCrossing();
        OS.memmove((GdkEventCrossing)gdkEvent, (int)event, (int)GdkEventCrossing.sizeof);
        if (gdkEvent.mode != 0) {
            return 0;
        }
        if (gdkEvent.subwindow != 0) {
            return 0;
        }
        this.sendMouseEvent(7, 0, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, gdkEvent.state, event);
        return 0;
    }

    int gtk_mnemonic_activate(int widget, int arg1) {
        int result = 0;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove((GdkEventKey)keyEvent, (int)eventPtr, (int)GdkEventKey.sizeof);
            if (keyEvent.type == 8) {
                int focusHandle;
                Control focusControl = this.display.getFocusControl();
                int n = focusHandle = focusControl != null ? focusControl.focusHandle() : 0;
                if (focusHandle != 0) {
                    this.display.mnemonicControl = this;
                    OS.gtk_widget_event((int)focusHandle, (int)eventPtr);
                    this.display.mnemonicControl = null;
                }
                result = 1;
            }
            OS.gdk_event_free((int)eventPtr);
        }
        return result;
    }

    int gtk_motion_notify_event(int widget, int event) {
        GdkEventMotion gdkEvent = new GdkEventMotion();
        OS.memmove((GdkEventMotion)gdkEvent, (int)event, (int)GdkEventMotion.sizeof);
        if (this.hooks(29) && !this.display.dragging && (gdkEvent.state & 0x100) != 0 && OS.gtk_drag_check_threshold((int)this.handle, (int)this.display.dragStartX, (int)this.display.dragStartY, (int)((int)gdkEvent.x), (int)((int)gdkEvent.y))) {
            this.display.dragging = true;
            Event e = new Event();
            e.x = this.display.dragStartX;
            e.y = this.display.dragStartY;
            this.postEvent(29, e);
        }
        if (this.hooks(32) || this.filters(32)) {
            this.display.addMouseHoverTimeout(this.handle);
        }
        double x_root = gdkEvent.x_root;
        double y_root = gdkEvent.y_root;
        if (gdkEvent.is_hint != 0) {
            int[] pointer_x = new int[1];
            int[] pointer_y = new int[1];
            OS.gdk_window_get_pointer((int)0, (int[])pointer_x, (int[])pointer_y, null);
            x_root = pointer_x[0];
            y_root = pointer_y[0];
        }
        this.sendMouseEvent(5, 0, gdkEvent.time, x_root, y_root, gdkEvent.state, event);
        return 0;
    }

    int gtk_popup_menu(int widget) {
        if (!this.hasFocus()) {
            return 0;
        }
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gdk_window_get_pointer((int)0, (int[])x, (int[])y, null);
        this.showMenu(x[0], y[0]);
        return 0;
    }

    int gtk_preedit_changed(int imcontext) {
        this.display.showIMWindow(this);
        return 0;
    }

    int gtk_realize(int widget) {
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            int window = OS.GTK_WIDGET_WINDOW((int)this.paintHandle());
            OS.gtk_im_context_set_client_window((int)imHandle, (int)window);
        }
        return 0;
    }

    int gtk_scroll_event(int widget, int eventPtr) {
        GdkEventScroll gdkEvent = new GdkEventScroll();
        OS.memmove((GdkEventScroll)gdkEvent, (int)eventPtr, (int)GdkEventScroll.sizeof);
        switch (gdkEvent.direction) {
            case 0: {
                if (this.sendMouseEvent(37, 0, 3, 1, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, gdkEvent.state, eventPtr)) break;
                return 1;
            }
            case 1: {
                if (this.sendMouseEvent(37, 0, -3, 1, true, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, gdkEvent.state, eventPtr)) break;
                return 1;
            }
            case 2: {
                this.sendMouseEvent(3, 4, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, gdkEvent.state, eventPtr);
                break;
            }
            case 3: {
                this.sendMouseEvent(3, 5, gdkEvent.time, gdkEvent.x_root, gdkEvent.y_root, gdkEvent.state, eventPtr);
            }
        }
        return 0;
    }

    int gtk_show_help(int widget, int helpType) {
        if (!this.hasFocus()) {
            return 0;
        }
        return this.sendHelpEvent(helpType) ? 1 : 0;
    }

    int gtk_unrealize(int widget) {
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            OS.gtk_im_context_set_client_window((int)imHandle, (int)0);
        }
        return 0;
    }

    int gtk_visibility_notify_event(int widget, int event) {
        GdkEventVisibility gdkEvent = new GdkEventVisibility();
        OS.memmove((GdkEventVisibility)gdkEvent, (int)event, (int)GdkEventVisibility.sizeof);
        if (gdkEvent.state == 2) {
            this.state |= 0x40;
        } else {
            if ((this.state & 0x40) != 0) {
                int window = gdkEvent.window;
                int[] width = new int[1];
                int[] height = new int[1];
                OS.gdk_drawable_get_size((int)window, (int[])width, (int[])height);
                GdkRectangle rect = new GdkRectangle();
                rect.width = width[0];
                rect.height = height[0];
                OS.gdk_window_invalidate_rect((int)window, (GdkRectangle)rect, (boolean)true);
            }
            this.state &= 0xFFFFFFBF;
        }
        return 0;
    }

    public int internal_new_GC(GCData data) {
        int gdkGC;
        this.checkWidget();
        int window = this.paintWindow();
        if (window == 0) {
            SWT.error(2);
        }
        if ((gdkGC = OS.gdk_gc_new((int)window)) == 0) {
            this.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= this.style & (mask | 0x8000000);
            }
            data.drawable = window;
            data.device = this.display;
            data.background = this.getBackgroundColor();
            data.foreground = this.getForegroundColor();
            data.font = this.font != null ? this.font.handle : this.defaultFont();
        }
        return gdkGC;
    }

    int imHandle() {
        return 0;
    }

    public void internal_dispose_GC(int gdkGC, GCData data) {
        this.checkWidget();
        OS.g_object_unref((int)gdkGC);
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSize();
            if (size.x == 0 || size.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if (((code = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        return ((code = this.traversalCode(0, null)) & 0x60) != 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        return false;
    }

    void register() {
        int imHandle;
        super.register();
        if (this.fixedHandle != 0) {
            this.display.addWidget(this.fixedHandle, this);
        }
        if ((imHandle = this.imHandle()) != 0) {
            this.display.addWidget(imHandle, this);
        }
    }

    public void redraw() {
        this.checkWidget();
        if (!OS.GTK_WIDGET_VISIBLE((int)this.topHandle())) {
            return;
        }
        this.forceResize();
        int paintHandle = this.paintHandle();
        int width = OS.GTK_WIDGET_WIDTH((int)paintHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)paintHandle);
        this.redrawWidget(0, 0, width, height, false);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (!OS.GTK_WIDGET_VISIBLE((int)this.topHandle())) {
            return;
        }
        this.redrawWidget(x, y, width, height, all);
    }

    void redrawWidget(int x, int y, int width, int height, boolean all) {
        if ((OS.GTK_WIDGET_FLAGS((int)this.handle) & 0x40) == 0) {
            return;
        }
        int window = this.paintWindow();
        GdkRectangle rect = new GdkRectangle();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        OS.gdk_window_invalidate_rect((int)window, (GdkRectangle)rect, (boolean)all);
    }

    void releaseChild() {
        this.parent.removeControl(this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.fixedHandle = 0;
    }

    void releaseWidget() {
        this.display.removeMouseHoverTimeout(this.handle);
        super.releaseWidget();
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            OS.gtk_im_context_reset((int)imHandle);
            OS.gtk_im_context_set_client_window((int)imHandle, (int)0);
        }
        if (this.enableWindow != 0) {
            OS.gdk_window_set_user_data((int)this.enableWindow, (int)0);
            OS.gdk_window_destroy((int)this.enableWindow);
            this.enableWindow = 0;
        }
        this.redrawWindow = 0;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        this.toolTipText = null;
        this.parent = null;
        this.layoutData = null;
        this.accessible = null;
    }

    void sendFocusEvent(int type) {
        Shell shell = this._getShell();
        Display display = this.display;
        display.focusControl = this;
        display.focusEvent = type;
        this.sendEvent(type);
        display.focusControl = null;
        display.focusEvent = 0;
        if (!shell.isDisposed()) {
            switch (type) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.getActiveShell()) break;
                    shell.setActiveControl(null);
                }
            }
        }
    }

    boolean sendHelpEvent(int helpType) {
        Control control = this;
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    boolean sendMouseEvent(int type, int button, int time, double x_root, double y_root, int state, int eventPtr) {
        return this.sendMouseEvent(type, button, 0, 0, false, time, x_root, y_root, state, eventPtr);
    }

    boolean sendMouseEvent(int type, int button, int count, int detail, boolean send, int time, double x_root, double y_root, int state, int eventPtr) {
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        Event event = new Event();
        event.time = time;
        event.button = button;
        event.detail = detail;
        event.count = count;
        int window = OS.GTK_WIDGET_WINDOW((int)this.eventHandle());
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
        event.x = (int)x_root - origin_x[0];
        event.y = (int)y_root - origin_y[0];
        this.setInputState(event, state);
        if (send) {
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(type, event);
        }
        return event.doit;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        GdkColor gdkColor = null;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            gdkColor = color.handle;
        }
        boolean set = false;
        if (gdkColor == null) {
            int style = OS.gtk_widget_get_modifier_style((int)this.handle);
            set = (OS.gtk_rc_style_get_color_flags((int)style, (int)0) & 2) != 0;
        } else {
            GdkColor oldColor = this.getBackgroundColor();
            boolean bl = set = oldColor.pixel != gdkColor.pixel;
        }
        if (set) {
            this.setBackgroundColor(gdkColor);
        }
    }

    void setBackgroundColor(int handle, GdkColor color) {
        int index = 0;
        int style = OS.gtk_widget_get_modifier_style((int)handle);
        int ptr = OS.gtk_rc_style_get_bg_pixmap_name((int)style, (int)index);
        if (ptr != 0) {
            OS.g_free((int)ptr);
        }
        String name = color == null ? "<parent>" : "<none>";
        byte[] buffer = Converter.wcsToMbcs(null, name, true);
        ptr = OS.g_malloc((int)buffer.length);
        OS.memmove((int)ptr, (byte[])buffer, (int)buffer.length);
        OS.gtk_rc_style_set_bg_pixmap_name((int)style, (int)index, (int)ptr);
        OS.gtk_rc_style_set_bg((int)style, (int)index, (GdkColor)color);
        int flags = OS.gtk_rc_style_get_color_flags((int)style, (int)index);
        flags = color == null ? flags & 0xFFFFFFFD : flags | 2;
        OS.gtk_rc_style_set_color_flags((int)style, (int)index, (int)flags);
        OS.gtk_widget_modify_style((int)handle, (int)style);
    }

    void setBackgroundColor(GdkColor color) {
        this.setBackgroundColor(this.handle, color);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        this.setCursor(cursor != null ? cursor.handle : 0);
    }

    void setCursor(int cursor) {
        int window = this.paintWindow();
        if (window != 0) {
            OS.gdk_window_set_cursor((int)window, (int)cursor);
            OS.gdk_flush();
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == enabled) {
            return;
        }
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(enabled);
        if (enabled) {
            if (this.enableWindow != 0) {
                OS.gdk_window_set_user_data((int)this.enableWindow, (int)0);
                OS.gdk_window_destroy((int)this.enableWindow);
                this.enableWindow = 0;
            }
        } else {
            OS.gtk_widget_realize((int)this.handle);
            int parentHandle = this.parent.parentingHandle();
            int window = OS.GTK_WIDGET_WINDOW((int)parentHandle);
            Rectangle rect = this.getBounds();
            GdkWindowAttr attributes = new GdkWindowAttr();
            attributes.x = rect.x;
            attributes.y = rect.y;
            attributes.width = rect.width;
            attributes.height = rect.height;
            attributes.event_mask = -32769;
            attributes.wclass = 1;
            attributes.window_type = 2;
            this.enableWindow = OS.gdk_window_new((int)window, (GdkWindowAttr)attributes, (int)12);
            if (this.enableWindow != 0) {
                int topHandle = this.topHandle();
                OS.gdk_window_set_user_data((int)this.enableWindow, (int)parentHandle);
                if (!OS.GDK_WINDOWING_X11()) {
                    OS.gdk_window_raise((int)this.enableWindow);
                } else {
                    int topWindow = OS.GTK_WIDGET_WINDOW((int)topHandle);
                    int xDisplay = OS.gdk_x11_drawable_get_xdisplay((int)topWindow);
                    int xWindow = OS.gdk_x11_drawable_get_xid((int)this.enableWindow);
                    int xScreen = OS.XDefaultScreen((int)xDisplay);
                    int flags = 96;
                    XWindowChanges changes = new XWindowChanges();
                    changes.sibling = OS.gdk_x11_drawable_get_xid((int)topWindow);
                    changes.stack_mode = 0;
                    OS.XReconfigureWMWindow((int)xDisplay, (int)xWindow, (int)xScreen, (int)flags, (XWindowChanges)changes);
                }
                if (OS.GTK_WIDGET_VISIBLE((int)topHandle)) {
                    OS.gdk_window_show_unraised((int)this.enableWindow);
                }
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        int fontDesc;
        this.checkWidget();
        this.font = font;
        if (font == null) {
            fontDesc = this.defaultFont();
        } else {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            fontDesc = font.handle;
        }
        this.setFontDescription(fontDesc);
    }

    void setFontDescription(int font) {
        OS.gtk_widget_modify_font((int)this.handle, (int)font);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        GdkColor gdkColor = null;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            gdkColor = color.handle;
        }
        boolean set = false;
        if (gdkColor == null) {
            int style = OS.gtk_widget_get_modifier_style((int)this.handle);
            set = (OS.gtk_rc_style_get_color_flags((int)style, (int)0) & 1) != 0;
        } else {
            GdkColor oldColor = this.getForegroundColor();
            boolean bl = set = oldColor.pixel != gdkColor.pixel;
        }
        if (set) {
            this.setForegroundColor(gdkColor);
        }
    }

    void setForegroundColor(GdkColor color) {
        OS.gtk_widget_modify_fg((int)this.handle, (int)0, (GdkColor)color);
    }

    void setInitialBounds() {
        if ((this.state & 0x800) != 0) {
            int topHandle = this.topHandle();
            OS.GTK_WIDGET_SET_X((int)topHandle, (int)0);
            OS.GTK_WIDGET_SET_Y((int)topHandle, (int)0);
        } else {
            this.resizeHandle(1, 1);
            this.forceResize();
        }
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent == null) {
            SWT.error(4);
        }
        if (parent.isDisposed()) {
            SWT.error(5);
        }
        if (this.parent == parent) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        this.releaseChild();
        Shell newShell = parent.getShell();
        Shell oldShell = this.getShell();
        Decorations newDecorations = parent.menuShell();
        Decorations oldDecorations = this.menuShell();
        Menu[] menus = oldShell.findMenus(this);
        if (oldShell != newShell || oldDecorations != newDecorations) {
            this.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
            newDecorations.fixAccelGroup();
            oldDecorations.fixAccelGroup();
        }
        int topHandle = this.topHandle();
        int newParent = parent.parentingHandle();
        int x = OS.GTK_WIDGET_X((int)topHandle);
        int y = OS.GTK_WIDGET_Y((int)topHandle);
        OS.gtk_widget_reparent((int)topHandle, (int)newParent);
        OS.gtk_fixed_move((int)newParent, (int)topHandle, (int)x, (int)y);
        this.parent = parent;
        this.setZOrder(null, false);
        return true;
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0 && this.redrawWindow != 0) {
                int window = this.paintWindow();
                OS.gdk_window_destroy((int)this.redrawWindow);
                OS.gdk_window_set_events((int)window, (int)OS.gtk_widget_get_events((int)this.paintHandle()));
                this.redrawWindow = 0;
            }
        } else if (this.drawCount++ == 0 && (OS.GTK_WIDGET_FLAGS((int)this.handle) & 0x40) != 0) {
            int window = this.paintWindow();
            Rectangle rect = this.getBounds();
            GdkWindowAttr attributes = new GdkWindowAttr();
            attributes.width = rect.width;
            attributes.height = rect.height;
            attributes.event_mask = 2;
            attributes.window_type = 2;
            this.redrawWindow = OS.gdk_window_new((int)window, (GdkWindowAttr)attributes, (int)0);
            if (this.redrawWindow != 0) {
                int mouseMask = 13308;
                OS.gdk_window_set_events((int)window, (int)(OS.gdk_window_get_events((int)window) & ~mouseMask));
                OS.gdk_window_set_back_pixmap((int)this.redrawWindow, (int)0, (boolean)false);
                OS.gdk_window_show((int)this.redrawWindow);
            }
        }
    }

    boolean setTabGroupFocus(boolean next) {
        return this.setTabItemFocus(next);
    }

    boolean setTabItemFocus(boolean next) {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        Shell shell = this._getShell();
        this.toolTipText = string;
        shell.setToolTipText(this.eventHandle(), this.toolTipText);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.state & 0x1000) == 0 == visible) {
            return;
        }
        int topHandle = this.topHandle();
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.state &= 0xFFFFEFFF;
            if ((this.state & 0x800) == 0) {
                if (this.enableWindow != 0) {
                    OS.gdk_window_show_unraised((int)this.enableWindow);
                }
                OS.gtk_widget_show((int)topHandle);
            }
        } else {
            Control control = null;
            boolean fixFocus = false;
            if (this.display.focusEvent != 16) {
                control = this.display.getFocusControl();
                fixFocus = this.isFocusAncestor(control);
            }
            if (fixFocus) {
                OS.GTK_WIDGET_UNSET_FLAGS((int)topHandle, (int)256);
                this.fixFocus(control);
                if (this.isDisposed()) {
                    return;
                }
                OS.GTK_WIDGET_SET_FLAGS((int)topHandle, (int)256);
            }
            this.state |= 0x1000;
            OS.gtk_widget_hide((int)topHandle);
            if (this.enableWindow != 0) {
                OS.gdk_window_hide((int)this.enableWindow);
            }
            this.sendEvent(23);
        }
    }

    void setZOrder(Control sibling, boolean above) {
        this.setZOrder(sibling, above, true);
    }

    void setZOrder(Control sibling, boolean above, boolean fixChildren) {
        int topHandle = this.topHandle();
        int siblingHandle = sibling != null ? sibling.topHandle() : 0;
        int window = OS.GTK_WIDGET_WINDOW((int)topHandle);
        if (window != 0) {
            int redrawWindow;
            int siblingWindow = 0;
            if (sibling != null) {
                siblingWindow = above && sibling.enableWindow != 0 ? this.enableWindow : OS.GTK_WIDGET_WINDOW((int)siblingHandle);
            }
            int n = redrawWindow = fixChildren ? this.parent.redrawWindow : 0;
            if (!OS.GDK_WINDOWING_X11() || siblingWindow == 0 && redrawWindow == 0) {
                if (above) {
                    OS.gdk_window_raise((int)window);
                    if (redrawWindow != 0) {
                        OS.gdk_window_raise((int)redrawWindow);
                    }
                    if (this.enableWindow != 0) {
                        OS.gdk_window_raise((int)this.enableWindow);
                    }
                } else {
                    if (this.enableWindow != 0) {
                        OS.gdk_window_lower((int)this.enableWindow);
                    }
                    OS.gdk_window_lower((int)window);
                }
            } else {
                XWindowChanges changes = new XWindowChanges();
                changes.sibling = OS.gdk_x11_drawable_get_xid((int)(siblingWindow != 0 ? siblingWindow : redrawWindow));
                int n2 = changes.stack_mode = above ? 0 : 1;
                if (redrawWindow != 0 && siblingWindow == 0) {
                    changes.stack_mode = 1;
                }
                int xDisplay = OS.gdk_x11_drawable_get_xdisplay((int)window);
                int xWindow = OS.gdk_x11_drawable_get_xid((int)window);
                int xScreen = OS.XDefaultScreen((int)xDisplay);
                int flags = 96;
                OS.XReconfigureWMWindow((int)xDisplay, (int)xWindow, (int)xScreen, (int)flags, (XWindowChanges)changes);
                if (this.enableWindow != 0) {
                    changes.sibling = OS.gdk_x11_drawable_get_xid((int)window);
                    changes.stack_mode = 0;
                    xWindow = OS.gdk_x11_drawable_get_xid((int)this.enableWindow);
                    OS.XReconfigureWMWindow((int)xDisplay, (int)xWindow, (int)xScreen, (int)flags, (XWindowChanges)changes);
                }
            }
        }
        if (fixChildren) {
            if (above) {
                this.parent.moveAbove(topHandle, siblingHandle);
            } else {
                this.parent.moveBelow(topHandle, siblingHandle);
            }
        }
        if (!above && fixChildren) {
            this.parent.fixZOrder();
        }
    }

    boolean showMenu(int x, int y) {
        Event event = new Event();
        event.x = x;
        event.y = y;
        this.sendEvent(35, event);
        if (event.doit && this.menu != null && !this.menu.isDisposed()) {
            this.menu.createIMMenu(this.imHandle());
            if (event.x != x || event.y != y) {
                this.menu.setLocation(event.x, event.y);
            }
            this.menu.setVisible(true);
            return true;
        }
        return false;
    }

    void showWidget() {
        this.state |= 0x800;
        int topHandle = this.topHandle();
        int parentHandle = this.parent.parentingHandle();
        OS.gtk_container_add((int)parentHandle, (int)topHandle);
        if (this.handle != 0 && this.handle != topHandle) {
            OS.gtk_widget_show((int)this.handle);
        }
        if ((this.state & 0x800) == 0 && this.fixedHandle != 0) {
            OS.gtk_widget_show((int)this.fixedHandle);
        }
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this == this.display.mnemonicControl || this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(int keyval, GdkEventKey gdkEvent) {
        Decorations shell;
        int key = OS.gdk_keyval_to_unicode((int)keyval);
        if (key < 32) {
            return false;
        }
        if (gdkEvent.state == 0) {
            int code = this.traversalCode(keyval, gdkEvent);
            if ((code & 0x80) == 0) {
                return false;
            }
        } else {
            Shell shell2 = this._getShell();
            int mask = 13;
            if ((gdkEvent.state & mask) != OS.gtk_window_get_mnemonic_modifier((int)shell2.shellHandle)) {
                return false;
            }
        }
        if ((shell = this.menuShell()).isVisible() && shell.isEnabled()) {
            Event event = new Event();
            event.detail = 128;
            if (this.setKeyState(event, gdkEvent)) {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
        }
        return false;
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int detail = 0;
        int key = keyEvent.keyval;
        int code = this.traversalCode(key, keyEvent);
        boolean all = false;
        switch (key) {
            case 65307: {
                all = true;
                detail = 2;
                break;
            }
            case 65293: 
            case 65421: {
                all = true;
                detail = 4;
                break;
            }
            case 65056: 
            case 65289: {
                boolean next = (keyEvent.state & 1) == 0;
                detail = next ? 16 : 8;
                break;
            }
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                boolean next = key == 65364 || key == 65363;
                detail = next ? 64 : 32;
                break;
            }
            case 65365: 
            case 65366: {
                all = true;
                if ((keyEvent.state & 4) == 0) {
                    return false;
                }
                detail = key == 65366 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (code & detail) != 0;
        event.detail = detail;
        event.time = keyEvent.time;
        if (!this.setKeyState(event, keyEvent)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    int traversalCode(int key, GdkEventKey event) {
        int code = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        return code;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Control group = this.computeTabGroup();
        Control[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control control = list[index];
            if (control.isDisposed() || !control.setTabGroupFocus(next)) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus(next);
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus(next)) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(char key) {
        return this.mnemonicHit(key);
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean all) {
        if (!OS.GTK_WIDGET_VISIBLE((int)this.topHandle())) {
            return;
        }
        if ((OS.GTK_WIDGET_FLAGS((int)this.handle) & 0x40) == 0) {
            return;
        }
        int window = this.paintWindow();
        this.display.flushExposes(window, all);
        OS.gdk_window_process_updates((int)window, (boolean)all);
    }

    void updateLayout(boolean all) {
    }
}

