/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Iterator;
import java.util.Vector;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Point;
import swingwtx.custom.JClosableTabbedPane;
import swingwtx.custom.event.TabCloseListener;
import swingwtx.swing.DefaultDesktopManager;
import swingwtx.swing.DesktopManager;
import swingwtx.swing.JInternalFrame;
import swingwtx.swing.JLayeredPane;
import swingwtx.swing.SwingUtilities;

public class JDesktopPane
extends JLayeredPane {
    protected Vector frames = new Vector();
    protected boolean useTabbedEmulation = true;
    protected JClosableTabbedPane jtp = null;
    protected JInternalFrame pSelectedFrame = null;
    protected Point nextLocation = null;
    DesktopManager manager = new DefaultDesktopManager();

    public JDesktopPane() {
    }

    public JDesktopPane(boolean useTabbedEmulation) {
        this.useTabbedEmulation = useTabbedEmulation;
    }

    public Component add(Component c) {
        if (!(c instanceof JInternalFrame)) {
            super.add(c);
            return c;
        }
        this.frames.add((JInternalFrame)c);
        ((JInternalFrame)c).setParentPane(this);
        if (this.useTabbedEmulation) {
            return this.addInternalFrameToTabbedPane((JInternalFrame)c);
        }
        Point loc = this.getNextFrameLocation();
        c.setBounds(loc.x, loc.y, 320, 200);
        super.add(c);
        return c;
    }

    public void add(Component c, Object layoutModifier) {
        this.add(c);
    }

    public Component add(String name, Component c) {
        c.setName(name);
        return this.add(c);
    }

    protected JInternalFrame addInternalFrameToTabbedPane(final JInternalFrame frame) {
        frame.setDrawDecoration(false);
        if (this.jtp == null) {
            return frame;
        }
        JDesktopPane me = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (JDesktopPane.this.jtp != null) {
                    JDesktopPane.this.jtp.addTab(frame.getTitle(), frame.getFrameIcon(), frame, frame.getTitle());
                    JDesktopPane.this.jtp.setSelectedIndex(JDesktopPane.this.jtp.getTabCount() - 1);
                }
            }
        });
        return frame;
    }

    public void setUseTabbedEmulation(boolean b) {
        this.useTabbedEmulation = b;
    }

    public Point getNextFrameLocation() {
        if (this.nextLocation == null) {
            this.nextLocation = new Point(0, 0);
        } else if (this.nextLocation.x == 0) {
            this.nextLocation.setLocation(24, 24);
        } else if (this.nextLocation.x == 24) {
            this.nextLocation.setLocation(48, 48);
        } else if (this.nextLocation.x == 48) {
            this.nextLocation.setLocation(72, 72);
        } else if (this.nextLocation.x == 72) {
            this.nextLocation.setLocation(0, 0);
        }
        return this.nextLocation;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        super.setSwingWTParent(parent);
        if (this.useTabbedEmulation) {
            this.setLayout(new BorderLayout());
            this.jtp = new JClosableTabbedPane();
            this.jtp.setTabPlacement(1);
            this.add((Component)this.jtp, "Center");
            Iterator i = this.frames.iterator();
            while (i.hasNext()) {
                JInternalFrame frame = (JInternalFrame)i.next();
                this.jtp.addTab(frame.getTitle(), frame.getFrameIcon(), frame, frame.getTitle());
            }
            this.jtp.addTabCloseListener(new TabCloseListener(){

                public boolean tabClosed(int index) {
                    return ((JInternalFrame)JDesktopPane.this.frames.get(index)).processFrameClosing();
                }
            });
        }
    }

    protected void refreshFrame(final JInternalFrame frame) {
        if (!this.useTabbedEmulation) {
            return;
        }
        if (frame == null) {
            return;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JInternalFrame[] frames = JDesktopPane.this.getAllFrames();
                if (frames == null) {
                    return;
                }
                for (int i = 0; i < frames.length; ++i) {
                    if (frames[i] != frame) continue;
                    JDesktopPane.this.updateFrameAt(i, frame);
                }
            }
        });
    }

    protected void updateFrameAt(int index, JInternalFrame frame) {
        this.jtp.setTitleAt(index, frame.getTitle());
        this.jtp.setIconAt(index, frame.getFrameIcon());
    }

    protected void removeFrame(JInternalFrame frame) {
        if (this.useTabbedEmulation) {
            int i = this.frames.indexOf(frame);
            if (i != -1) {
                this.jtp.removeTabAt(i);
                this.frames.remove(frame);
            }
        } else {
            this.frames.remove(frame);
            this.remove(frame);
        }
    }

    public JInternalFrame[] getAllFrames() {
        JInternalFrame[] ret = new JInternalFrame[this.frames.size()];
        Object[] jf = this.frames.toArray();
        for (int i = 0; i < jf.length; ++i) {
            ret[i] = (JInternalFrame)jf[i];
        }
        jf = null;
        return ret;
    }

    public JInternalFrame getSelectedFrame() {
        if (this.useTabbedEmulation) {
            if (this.jtp == null) {
                return null;
            }
            return (JInternalFrame)this.frames.get(this.jtp.getSelectedIndex());
        }
        if (this.pSelectedFrame != null) {
            return this.pSelectedFrame;
        }
        if (this.frames.size() > 0) {
            return (JInternalFrame)this.frames.get(0);
        }
        return null;
    }

    public void setSelectedFrame(JInternalFrame frame) {
        if (this.useTabbedEmulation) {
            if (this.jtp == null) {
                return;
            }
            int i = this.frames.indexOf(frame);
            if (i != -1) {
                this.jtp.setSelectedIndex(i);
            }
        } else {
            this.pSelectedFrame = frame;
            this.moveToFront(frame);
        }
    }

    public DesktopManager getDesktopManager() {
        return this.manager;
    }
}

