/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.border;

import swingwt.awt.Color;
import swingwt.awt.Component;
import swingwt.awt.Font;
import swingwt.awt.Graphics;
import swingwt.awt.Insets;
import swingwt.awt.SystemColor;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.border.AbstractBorder;
import swingwtx.swing.border.Border;
import swingwtx.swing.border.EmptyBorder;

public class TitledBorder
extends AbstractBorder
implements Border {
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected String title = "";
    protected Font font = null;
    protected Color color = null;
    protected Border border = null;

    public TitledBorder(String title) {
        this.title = title;
        this.border = new EmptyBorder(0, 0, 0, 0);
    }

    public TitledBorder(Border border) {
        this.border = border;
    }

    public TitledBorder(Border border, String title) {
        this.title = title;
        this.border = border;
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition) {
        this.title = title;
        this.border = border;
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont) {
        this.title = title;
        this.font = titleFont;
        this.border = border;
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        this.title = title;
        this.font = titleFont;
        this.color = titleColor;
        this.border = border;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(SystemColor.getSystemColor(18));
        g.drawLine(2, 10, width - 3, 10);
        g.drawLine(2, 10, 2, height - 3);
        g.drawLine(2, height - 3, width - 2, height - 3);
        g.drawLine(width - 3, 10, width - 3, height - 3);
        if (this.color != null) {
            g.setColor(this.color);
        } else {
            g.setColor(SystemColor.getSystemColor(23));
        }
        if (this.font != null) {
            g.setFont(this.font);
        }
        g.drawString(this.title, 8, 3);
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets());
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = insets.bottom = SwingWTUtils.getRenderStringHeight("W");
        insets.top += insets.top / 2;
        insets.right = 4;
        insets.left = 4;
        return insets;
    }

    public void setTitleJustification(int titleJustification) {
    }

    public int getTitleJustification() {
        return 0;
    }

    public Font getTitleFont() {
        Font font = this.getFont();
        if (font == null) {
            font = Font.getStubFont();
        }
        return font;
    }

    public void setTitleFont(Font font2) {
        this.setFont(font2);
    }

    public void setTitleColor(Color color) {
        this.setColor(color);
    }

    public Color getTitleColor() {
        return this.getColor();
    }
}

