/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;

public class SubActionBars
implements IActionBars {
    private IActionBars parent;
    private boolean active = false;
    private Map actionHandlers;
    private SubMenuManager menuMgr;
    private SubStatusLineManager statusLineMgr;
    private SubToolBarManager toolBarMgr;
    private ListenerList propertyChangeListeners = new ListenerList();
    private boolean actionHandlersChanged;
    public static final String P_ACTION_HANDLERS = "org.eclipse.ui.internal.actionHandlers";

    public SubActionBars(IActionBars parent) {
        this.parent = parent;
    }

    public void activate() {
        this.activate(true);
    }

    public void activate(boolean forceVisibility) {
        this.setActive(true);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void clearGlobalActionHandlers() {
        if (this.actionHandlers != null) {
            this.actionHandlers.clear();
            this.actionHandlersChanged = true;
        }
    }

    protected SubMenuManager createSubMenuManager(IMenuManager parent) {
        return new SubMenuManager(parent);
    }

    protected SubToolBarManager createSubToolBarManager(IToolBarManager parent) {
        return new SubToolBarManager(parent);
    }

    public void deactivate() {
        this.deactivate(true);
    }

    public void deactivate(boolean forceHide) {
        this.setActive(false);
    }

    public void dispose() {
        if (this.actionHandlers != null) {
            this.actionHandlers.clear();
        }
        if (this.menuMgr != null) {
            this.menuMgr.disposeManager();
        }
        if (this.statusLineMgr != null) {
            this.statusLineMgr.disposeManager();
        }
        if (this.toolBarMgr != null) {
            this.toolBarMgr.disposeManager();
        }
        this.propertyChangeListeners.clear();
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        Object[] listeners = this.propertyChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    protected void fireActionHandlersChanged() {
        if (this.actionHandlersChanged) {
            this.firePropertyChange(new PropertyChangeEvent((Object)this, P_ACTION_HANDLERS, null, null));
            this.actionHandlersChanged = false;
        }
    }

    protected final boolean getActive() {
        return this.active;
    }

    public IAction getGlobalActionHandler(String actionID) {
        if (this.actionHandlers == null) {
            return null;
        }
        return (IAction)this.actionHandlers.get(actionID);
    }

    public Map getGlobalActionHandlers() {
        return this.actionHandlers;
    }

    public IMenuManager getMenuManager() {
        if (this.menuMgr == null) {
            this.menuMgr = this.createSubMenuManager(this.parent.getMenuManager());
            this.menuMgr.setVisible(this.active);
        }
        return this.menuMgr;
    }

    protected final IActionBars getParent() {
        return this.parent;
    }

    public IStatusLineManager getStatusLineManager() {
        if (this.statusLineMgr == null) {
            this.statusLineMgr = new SubStatusLineManager(this.parent.getStatusLineManager());
            this.statusLineMgr.setVisible(this.active);
        }
        return this.statusLineMgr;
    }

    public IToolBarManager getToolBarManager() {
        if (this.toolBarMgr == null) {
            this.toolBarMgr = this.createSubToolBarManager(this.parent.getToolBarManager());
            this.toolBarMgr.setVisible(this.active);
        }
        return this.toolBarMgr;
    }

    protected final boolean isSubMenuManagerCreated() {
        return this.menuMgr != null;
    }

    protected final boolean isSubToolBarManagerCreated() {
        return this.toolBarMgr != null;
    }

    protected final boolean isSubStatusLineManagerCreated() {
        return this.statusLineMgr != null;
    }

    public void partChanged(IWorkbenchPart part) {
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }

    protected final void basicSetActive(boolean active) {
        this.active = active;
    }

    protected void setActive(boolean set) {
        this.active = set;
        if (this.menuMgr != null) {
            this.menuMgr.setVisible(set);
        }
        if (this.statusLineMgr != null) {
            this.statusLineMgr.setVisible(set);
        }
        if (this.toolBarMgr != null) {
            this.toolBarMgr.setVisible(set);
        }
    }

    public void setGlobalActionHandler(String actionID, IAction handler) {
        if (handler != null) {
            if (this.actionHandlers == null) {
                this.actionHandlers = new HashMap(11);
            }
            this.actionHandlers.put(actionID, handler);
        } else if (this.actionHandlers != null) {
            this.actionHandlers.remove(actionID);
        }
        this.actionHandlersChanged = true;
    }

    public void updateActionBars() {
        this.parent.updateActionBars();
        this.fireActionHandlersChanged();
    }
}

