/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.progress.BlockedJobsDialog;
import org.eclipse.ui.progress.WorkbenchJob;

public class EventLoopProgressMonitor
extends ProgressMonitorWrapper
implements IProgressMonitorWithBlocking {
    private static int T_THRESH = 100;
    private static int T_MAX = 50;
    private BlockedJobsDialog dialog;
    private long lastTime = System.currentTimeMillis();

    public EventLoopProgressMonitor(IProgressMonitor monitor) {
        super(monitor);
    }

    public void beginTask(String name, int totalWork) {
        super.beginTask(name, totalWork);
        this.runEventLoop();
    }

    public void clearBlocked() {
        if (this.dialog == null || this.dialog.getShell() == null || this.dialog.getShell().isDisposed()) {
            this.dialog = null;
            return;
        }
        this.dialog.close();
        this.dialog = null;
    }

    public void done() {
        super.done();
        this.runEventLoop();
    }

    public void internalWorked(double work) {
        super.internalWorked(work);
        this.runEventLoop();
    }

    public boolean isCanceled() {
        this.runEventLoop();
        return super.isCanceled();
    }

    private void runEventLoop() {
        long t = System.currentTimeMillis();
        if (t - this.lastTime < (long)T_THRESH) {
            return;
        }
        this.lastTime = t;
        Display disp = Display.getDefault();
        if (disp == null) {
            return;
        }
        while (disp.readAndDispatch() && System.currentTimeMillis() - t <= (long)T_MAX) {
        }
    }

    public void setBlocked(IStatus reason) {
        this.dialog = new BlockedJobsDialog(null, (IProgressMonitor)this, reason);
        this.dialog.setBlockOnOpen(false);
        WorkbenchJob dialogJob = new WorkbenchJob(WorkbenchMessages.getString("EventLoopProgressMonitor.OpenDialogJobName")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (EventLoopProgressMonitor.this.dialog == null) {
                    return Status.CANCEL_STATUS;
                }
                EventLoopProgressMonitor.this.dialog.open();
                return Status.OK_STATUS;
            }
        };
        dialogJob.setSystem(true);
        dialogJob.schedule(3000L);
    }

    public void setCanceled(boolean b) {
        super.setCanceled(b);
        this.runEventLoop();
    }

    public void setTaskName(String name) {
        super.setTaskName(name);
        this.runEventLoop();
    }

    public void subTask(String name) {
        super.subTask(name);
        this.runEventLoop();
    }

    public void worked(int work) {
        super.worked(work);
        this.runEventLoop();
    }
}

