/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class WorkbenchSiteProgressService
implements IWorkbenchSiteProgressService {
    PartSite site;
    IJobChangeListener listener;
    IPropertyChangeListener[] changeListeners = new IPropertyChangeListener[0];
    private Cursor waitCursor;
    private SiteUpdateJob updateJob;

    public WorkbenchSiteProgressService(PartSite partSite) {
        this.site = partSite;
    }

    public void dispose() {
        if (this.updateJob != null) {
            this.updateJob.cancel();
        }
        if (this.waitCursor == null) {
            return;
        }
        this.waitCursor.dispose();
        this.waitCursor = null;
    }

    public IStatus requestInUI(UIJob job, String message) {
        return this.site.getWorkbenchWindow().getWorkbench().getProgressService().requestInUI(job, message);
    }

    public void busyCursorWhile(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.site.getWorkbenchWindow().getWorkbench().getProgressService().busyCursorWhile(runnable);
    }

    public void schedule(Job job, long delay, boolean useHalfBusyCursor) {
        job.addJobChangeListener(this.getJobChangeListener(job, useHalfBusyCursor));
        job.schedule(delay);
    }

    public void schedule(Job job, long delay) {
        this.schedule(job, delay, false);
    }

    public void schedule(Job job) {
        this.schedule(job, 0L, false);
    }

    public IJobChangeListener getJobChangeListener(Job job, boolean useHalfBusyCursor) {
        if (this.listener == null) {
            this.updateJob = new SiteUpdateJob();
            this.updateJob.setSystem(true);
            this.updateJob.useWaitCursor = useHalfBusyCursor;
            this.listener = new JobChangeAdapter(){

                public void aboutToRun(IJobChangeEvent event) {
                    if (PlatformUI.isWorkbenchRunning()) {
                        WorkbenchSiteProgressService.this.updateJob.setBusy(true);
                        WorkbenchSiteProgressService.this.updateJob.schedule(100L);
                    } else {
                        WorkbenchSiteProgressService.this.updateJob.cancel();
                    }
                }

                public void done(IJobChangeEvent event) {
                    if (PlatformUI.isWorkbenchRunning()) {
                        WorkbenchSiteProgressService.this.updateJob.setBusy(false);
                        WorkbenchSiteProgressService.this.updateJob.schedule(100L);
                    } else {
                        WorkbenchSiteProgressService.this.updateJob.cancel();
                    }
                }
            };
        }
        return this.listener;
    }

    private class SiteUpdateJob
    extends WorkbenchJob {
        private boolean busy;
        private boolean useWaitCursor;
        Object lock = new Object();

        void setBusy(boolean cursorState) {
            Object object = this.lock;
            synchronized (object) {
                this.busy = cursorState;
            }
        }

        SiteUpdateJob() {
            super(ProgressMessages.getString("WorkbenchSiteProgressService.CursorJob"));
        }

        private Cursor getWaitCursor(Display display) {
            if (WorkbenchSiteProgressService.this.waitCursor == null) {
                WorkbenchSiteProgressService.this.waitCursor = new Cursor((Device)display, 3);
            }
            return WorkbenchSiteProgressService.this.waitCursor;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Control control = WorkbenchSiteProgressService.this.site.getPane().getControl();
            if (control == null || control.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.useWaitCursor) {
                    Cursor cursor = null;
                    if (this.busy) {
                        cursor = this.getWaitCursor(control.getDisplay());
                    }
                    control.setCursor(cursor);
                }
                WorkbenchSiteProgressService.this.site.getPane().setBusy(this.busy);
                IWorkbenchPart part = WorkbenchSiteProgressService.this.site.getPart();
                if (part instanceof WorkbenchPart) {
                    ((WorkbenchPart)part).showBusy(this.busy);
                }
            }
            return Status.OK_STATUS;
        }

        void clearCursors() {
            if (WorkbenchSiteProgressService.this.waitCursor != null) {
                WorkbenchSiteProgressService.this.waitCursor.dispose();
                WorkbenchSiteProgressService.this.waitCursor = null;
            }
        }
    }
}

