/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Choice.java,v $
   Revision 1.8  2005/01/05 09:22:24  bobintetley
   Updated copyright year on source

   Revision 1.7  2004/11/02 11:07:29  bobintetley
   Fixed a number of small compatibility bugs

   Revision 1.6  2004/06/10 07:57:57  dannaab
   Added AWTSwingWrapper to map AWT components to the corresponding Swing version.  Implemted using it: TextComponent, TextArea, TextField; used similar technique for Menu components

   Revision 1.5  2004/01/20 07:38:05  bobintetley
   Bug fixes and compatibility methods

   Revision 1.4  2004/01/15 10:11:14  bobintetley
   Fixed AWT constructors/hierarchy

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwt.awt;

import swingwt.awt.event.ItemEvent;
import swingwt.awt.event.ItemListener;

import swingwtx.swing.DefaultComboBoxModel;

public class Choice extends AWTSwingWrapper {

    public Choice() { 
        swingPeer = new swingwtx.swing.JComboBox(new DefaultComboBoxModel());
    }
    public Choice(Object[] items) {
        swingPeer = new swingwtx.swing.JComboBox(items);
    }
    public Choice(java.util.Vector items) {
        swingPeer = new swingwtx.swing.JComboBox(items);
    }
    
    private final swingwtx.swing.JComboBox getSwingPeer() { return (swingwtx.swing.JComboBox) swingPeer; }
    
    public void add(String item) { getSwingPeer().addItem(item); }
    public void addItem(String item) { getSwingPeer().addItem(item); }
    public void addItemListener(ItemListener l) { getSwingPeer().addItemListener(l); }
    public int countItems() { return getItemCount(); }
    public String getItem(int index) { return getSwingPeer().getItemAt(index).toString(); }
    public int getItemCount() { return getSwingPeer().getItemCount(); }
    public ItemListener[] getItemListeners() { return getSwingPeer().getItemListeners(); }
    public int getSelectedIndex() { return getSwingPeer().getSelectedIndex(); }
    public String getSelectedItem() { return getSwingPeer().getSelectedItem().toString(); }
    public Object[] getSelectedObjects() { return getSwingPeer().getSelectedObjects(); }
    public void insert(String item, int index) { getSwingPeer().insertItemAt(item, index); }
    protected void processEvent(AWTEvent e) { getSwingPeer().processEvent(e); }
    protected void processItemEvent(ItemEvent e) { getSwingPeer().processItemEvent(e); }
    public void remove(int position) { getSwingPeer().remove(position); }
    public void remove(String item) { getSwingPeer().removeItem(item); }
    public void removeAll() { getSwingPeer().removeAll(); }
    public void removeItemListener(ItemListener l) { getSwingPeer().removeItemListener(l); }
    public void select(int pos) { getSwingPeer().setSelectedIndex(pos); }
    public void select(String str) { getSwingPeer().setSelectedItem(str); } 
}
