/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Clipboard.java,v $
   Revision 1.3  2005/01/05 09:22:25  bobintetley
   Updated copyright year on source

   Revision 1.2  2004/05/05 12:43:19  bobintetley
   Patches/new files from Laurent Martell

   Revision 1.1  2004/01/20 07:38:05  bobintetley
   Bug fixes and compatibility methods

   Revision 1.4  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwt.awt.datatransfer;

import org.eclipse.swt.dnd.*;

/**
 * This class differs slightly from the AWT implementation.
 * Mostly because type mapping is massively different between
 * the AWT and SWT implementations, so this works, you can knock
 * a couple of parameters off your calls, but it's woefully
 * inadequate and can only handle text.
 *
 */
public class Clipboard {

    private org.eclipse.swt.dnd.Clipboard clip = new org.eclipse.swt.dnd.Clipboard(swingwtx.swing.SwingWTUtils.getDisplay());
    
    public Clipboard() {}
    
    public Object getContents() {
        return clip.getContents(TextTransfer.getInstance());
    }
    
    /** NOT IMPLEMENTED - use setContents(Object) for now */
    public void setContents(Transferable contents, ClipboardOwner owner) {    
    }
    
    /** NOT IMPLEMENTED - use getContents() */
    public Transferable getContents(Object owner) {
        return null;
    }
    
    public String getName() {
        return "";
    }
    
    public void setContents(Object contents) {
        clip.setContents(new Object[] { contents }, new Transfer[] { TextTransfer.getInstance() });
    }
    
}
