/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Point2D.java,v $
   Revision 1.4  2005/01/05 09:22:27  bobintetley
   Updated copyright year on source

   Revision 1.3  2004/07/16 07:20:43  dannaab
   Add Graphics2DRenderer to allow rendering of awt 2D paint functionality to SWT; fill out TableCellRenderer support a bit (default cell renderers)

   Revision 1.2  2004/04/20 16:36:14  bobintetley
   Code cleanup

   Revision 1.1  2004/01/15 15:20:29  bobintetley
   Java2D work
*/

package swingwt.awt.geom;

public abstract class Point2D {

    // Abstract methods...
    public abstract void setLocation(double x, double y);
    public abstract double getX();
    public abstract double getY();
    
    public double distanceSq(double x, double y) { return distanceSq(getX(), getY(), x, y); }
    
    public static double distance(double x1, double y1, double x2, double y2) { return Math.sqrt(distanceSq(x1, y1, x2, y2));}
    public static double distanceSq(double x1, double y1, double x2, double y2) {
        double x = x1 - x2;
        double y = y1 - y2;
        return (x*x + y*y);
    }

    public double distance(double x, double y) { return distance(getX(), getY(), x, y); }
    public double distance(Point2D point) { return distance(point.getX(), point.getY()); }
    public double distanceSq(Point2D point) { return distanceSq(point.getX(), point.getY()); }
    public void setLocation(Point2D point) { setLocation(point.getX(), point.getY());}
    
    public static class Float extends Point2D {
    	public float x, y;

    	public Float() {}
    	public Float(float x, float y) {
    	    this.x = x;
    	    this.y = y;
    	}

    	public double getX() { return (double) x; }
    	public double getY() { return (double) y; }
    	
    	public void setLocation(double x, double y) { this.x = (float) x; this.y = (float) y; }
    	public void setLocation(float x, float y) { this.x = x; this.y = y; }
    }
}

