/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley
 
   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.
 
   Contact me by electronic mail: bobintetley@users.sourceforge.net
 
   $Log: JComponent.java,v $
   Revision 1.42  2005/01/05 09:22:30  bobintetley
   Updated copyright year on source

   Revision 1.41  2005/01/05 08:37:13  bobintetley
   Many compatibility fixes from David Barron

   Revision 1.40  2004/11/02 11:07:31  bobintetley
   Fixed a number of small compatibility bugs

   Revision 1.39  2004/08/02 22:01:03  dannaab
   JViewport/JScrollPane integration

   Revision 1.38  2004/06/10 07:57:59  dannaab
   Added AWTSwingWrapper to map AWT components to the corresponding Swing version.  Implemted using it: TextComponent, TextArea, TextField; used similar technique for Menu components

   Revision 1.37  2004/05/25 01:04:12  dannaab
   Misc bugfixes, ActionMap.java added, added swt source to lib dir (for debugging
   purposes), misc import optimization

   Revision 1.36  2004/05/11 09:41:41  bobintetley
   Fixes to JInternalFrame ordering

   Revision 1.35  2004/05/10 20:51:20  bobintetley
   Event chain for making internal frames active in their JDesktopPane when a child is clicked/receives the focus

   Revision 1.34  2004/05/08 08:35:55  bobintetley
   *** empty log message ***

   Revision 1.33  2004/05/07 12:11:18  bobintetley
   Default layout fixes and correct behaviour for null layout

   Revision 1.32  2004/05/06 00:24:20  laurentmartelli
   repaint(Rectangle) has a proper implementation (but it still amounts to repainting everything since repaint(int,int,int,int) is not fully implemented.

   Revision 1.31  2004/05/05 19:29:35  bobintetley
   JComponent.paintComponent() is now called correctly

   Revision 1.30  2004/05/05 12:43:21  bobintetley
   Patches/new files from Laurent Martell

   Revision 1.29  2004/05/03 20:53:45  dannaab
   small tweak to layoutmanager instance objects to make easier to read

   Revision 1.28  2004/04/30 23:18:26  dannaab
   List selection support, misc bug fixes

   Revision 1.27  2004/04/29 12:49:27  bobintetley
   Additional JOptionePane constants, missing JTree methods and improved awt.Image support

   Revision 1.26  2004/04/28 08:38:11  bobintetley
   Hierarchy fixes, code cleanup for base classes, additional javadocs and use of flag to identify JComponent descendants with peers

   Revision 1.25  2004/04/28 07:19:31  bobintetley
   Fixes to destruction code

   Revision 1.24  2004/04/27 06:37:42  bobintetley
   Corrected hierarchy with JComponent descending Container

   Revision 1.23  2004/04/25 19:07:34  bobintetley
   Fix to border painting code to not waste as many objects and to fix broken
      mouse events

   Revision 1.22  2004/04/23 00:52:32  dannaab
   Handle borders in a Swing-like way. Implement EmptyBorder & TitledBorder

   Revision 1.21  2004/04/20 14:34:15  bobintetley
   Double buffering support for component paint()

   Revision 1.20  2004/04/19 15:03:26  bobintetley
   Missing Component/JComponent focus methods

   Revision 1.19  2004/04/16 10:19:06  dannaab
   Misc bug fixes, InputMap implementation, preliminary undo support

   Revision 1.18  2004/03/22 15:10:22  bobintetley
   JRootPane and JLayeredPane implementation

   Revision 1.17  2004/03/01 15:58:47  bobintetley
   Various little bug fixes

   Revision 1.16  2004/02/24 09:36:39  bobintetley
   Compatibility methods

   Revision 1.15  2004/02/19 09:58:44  bobintetley
   Various small bug fixes and JTextArea should be much faster/lighter

   Revision 1.14  2004/01/27 09:05:10  bobintetley
   ListModel and List Selection implemented. ScrollPane fix so all components
      scrollable

   Revision 1.13  2004/01/26 14:05:23  bobintetley
   Compatibility methods

   Revision 1.12  2004/01/26 10:03:37  bobintetley
   Fixed component painting, added overloaded TabbedPane add() methods

   Revision 1.11  2004/01/26 08:11:00  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.10  2004/01/20 15:52:56  bobintetley
   Code from an anonymous developer

   Revision 1.9  2004/01/16 15:53:32  bobintetley
   Many compatibility methods added to Container, Component, JInternalFrame,
      UIManager, SwingUtilities, JTabbedPane, JPasswordField, JCheckBox
      and JRadioButton.
 
   Revision 1.8  2004/01/15 10:11:15  bobintetley
   Fixed AWT constructors/hierarchy
 
   Revision 1.7  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications
 
   Revision 1.6  2003/12/15 15:54:25  bobintetley
   Additional core methods
 
   Revision 1.5  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers
 
 */


package swingwtx.swing;

import swingwtx.swing.border.*;
import swingwtx.accessibility.*;
import swingwt.awt.*;
import swingwt.awt.event.*;

import java.beans.*;

import java.util.*;

public class JComponent extends swingwt.awt.Container {

    /** The border for the component */
    protected swingwtx.swing.border.Border border = null;
    /** The component's accessible context */
    protected AccessibleContext accessibleContext = null;
    /** Whether or not subclasses are supplying a peer in their setSwingWTParent() call -
     *  if they don't, this component will supply a Composite peer (this is for Swing code
     *  that descends JComopnent and paints on it)
     */
    protected boolean descendantHasPeer = false;
    /** The table of client properties */
    protected Hashtable clientProperties;

    protected boolean opaque = true;

    protected InputMap focusInputMap = null;
    protected InputMap ancestorInputMap = null;
    protected InputMap windowInputMap = null;
    
    protected ActionMap actionMap = null;

    protected Vector propertyChangeListeners = new Vector();

    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;

    /** Creates an empty JComponent which by default will use
     *  a Composite peer (allowing you to paint on it).
     */
    public JComponent() {  }
    
    /** Adds a PropertyChangeListener to the component */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeListeners.add(l);    
    }
    /** Adds a PropertyChangeListener to the component */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        propertyChangeListeners.add(l);    
    }    
    /** Removes a PropertyChangeListener from the component */
    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeListeners.remove(l);    
    }
    /** Removes a PropertyChangeListener from the component */
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        propertyChangeListeners.remove(l);    
    }



    
    // Overriden add/remove methods - these are used to
    // attach a focus/mouse listener to the component if it is a child
    // of a JInternalFrame. When the component gains the focus or is
    // clicked, the setSelectedFrame() method of the JInternalFrame's
    // parent JDesktopPane is called with the frame to tell it to
    // become the active layer
    // =================================================================
    
    public void add(swingwt.awt.Component c, Object layoutModifier) {
	checkInternalFrameChild();
	super.add(c, layoutModifier);
    }
    
    public void add(swingwt.awt.Component c, Object layoutModifier, int index) {
	checkInternalFrameChild();
        super.add(c, layoutModifier, index);
    }

    public Component add(String name, swingwt.awt.Component c) {
	checkInternalFrameChild();
        return super.add(name, c);
    }
    
    public Component add(Component c) {
	checkInternalFrameChild();
        return super.add(c);
    }
    
    public Component add(Component c, int index) {
	checkInternalFrameChild();
        return super.add(c);    
    }

    public void remove(swingwt.awt.Component c) {
	if (internalFrameAdapter != null) {
	    removeFocusListener(internalFrameAdapter);
	    removeMouseListener(internalFrameAdapter);
	    internalFrameAdapter = null;
	}
	super.remove(c);
    }

    public void remove(int index) {
        Component c = (Component) comps.get(index);
        remove(c);
    }

    /** Checks whether this JComponent is a child of a JInternalFrame
     *  and if so, attaches a focus and mouse listener - when the
     *  component is clicked/gets the focus, the desktop pane of
     *  the JInternalFrame is called to tell it to make the frame
     *  active.
     *
     *  Of course, it only does this if the JDesktopPane is
     *  not using tabbed emulation (as you can't see other
     *  child components in tabbed emulation).
     */
    protected void checkInternalFrameChild() {
        Container c = this;
	while (c != null) {
	    if (c instanceof JInternalFrame) {
                internalFrameParent = (JInternalFrame) c;
                internalFrameAdapter = new InternalFrameSelectionListener();
                addMouseListener(internalFrameAdapter);
                addFocusListener(internalFrameAdapter);
                return;
	    }
	    c = c.getParent();
	}
    }

    /** Event adapter for managing internal frame selection if
     *  this component is an internal frame child. Fires when
     *  the mouseClicked or focusGained event hits.
     *
     *  There will never be more than once instance of this
     *  class per JComponent to make it easy to add/remove.
     */
    protected class InternalFrameSelectionListener implements
    						   MouseListener, FocusListener {
        public void focusGained(FocusEvent e) { selectFrame(); }
	public void focusLost(FocusEvent e) {}
	public void mouseClicked(MouseEvent e) { selectFrame(); }
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}

	public void selectFrame() {
	    try {
                if (!internalFrameParent.getParentPane().useTabbedEmulation) {
                    internalFrameParent.getParentPane().setSelectedFrame(internalFrameParent);
                }
	    }
	    catch (Exception e) {
                e.printStackTrace();
	    }
	}
    }
    /** Event adapter for calling the setSelection on the JInternalFrame parent
     *  if there is one.
     */
    protected InternalFrameSelectionListener internalFrameAdapter = null;
    /** JInternalFrame parent if this component has one */
    protected JInternalFrame internalFrameParent = null;
    

    // ============= End of internal frame selection code
    
    
    
    /** Forces a repaint of the whole component */
    public void paintImmediately(int x,int y,int w, int h) {
        super.repaint();
    }
    
    /** Forces a repaint of the whole component. Calls the
     * Component.repaint() method in the superclass
     */
    public void paintImmediately(swingwt.awt.Rectangle r) {
        super.repaint();
    }
    
    /** Forces a repaint of a specified rectangle (actually
      * repaints the whole thing) */
    public void repaint(Rectangle r) {
        repaint(r.x,r.y,r.width,r.height);
    }
    
    /** 
     * Override in subclass
     */
    protected void paintComponent(swingwt.awt.Graphics g) {
        paint(g);
    }
    
    /**
     * NOT IMPLEMENTED
     */
    protected void paintChildren(swingwt.awt.Graphics g) {
    }

    public void paintBackground(int x, int y, int width, int height) {
         if (parent != null && !isOpaque()) {
             Dimension size = getSize();
             Point location = getLocation();
             //parent.paintBackground(location.x, location.y, size.width, size.height);
         }
    }

    /**
     * Paints this component and any associated borders
     * on it. Note that if no subclass overrides the
     * paint method, the component tells the native bits
     * to show a widget and nothing else happens
     */
    public void paint(swingwt.awt.Graphics g) {
        super.paint(g);
        if (border != null) {
	    border.paintBorder(this, g, 0, 0, getWidth(), getHeight());
	}
    }

    /** Returns the components border.  */
    public Border getBorder() { if (border == null) return BorderFactory.createEmptyBorder(); else return border; }
    /** Sets the components border */
    public void setBorder(Border b) { border = b; invalidate(); }
    
    /** NOT IMPLEMENTED */
    public void setRequestFocusEnabled(boolean b) {}
    /** NOT IMPLEMENTED */
    public void setAutoscrolls(boolean b) {}
    /** Returns the appropriate tooltip text for a given
     *  <code>MouseEvent</code>. Since platform lacks Swing's
     *  flexibility in this regard, always returns super.getToolTipText()
     */
    public String getToolTipText(swingwt.awt.event.MouseEvent e) {
        return getToolTipText();    
    }

    /** Retrieves the top-level ancestor of this component
     *  (submitted by Fernando Petrola) 
     **/
    public Container getTopLevelAncestor() {
        for (Container p= this; p != null; p= p.getParent())
            if (p instanceof swingwt.awt.Window || p instanceof swingwt.applet.Applet)
                return p;
        return null;
    }
    
    /** Returns the appropriate location for the tooltip text
     *  for a given mouse event. This will just read the X/Y location
     *  of the cursor from the mouse event and return that.
     */
    public Point getToolTipLocation(swingwt.awt.event.MouseEvent e) {
        return e.getPoint();
    }
    /** NOT IMPLEMENTED
      * @return true */
    public boolean getAutoscrolls() { return true; }
    /** Hardcoded to return true - there's no other way for
     *  platform widgets.
     */
    public boolean isOpaque() { return opaque; }
    /** Ignored - platform widgets are always opaque */
    public void setOpaque(boolean b) { this.opaque = b; }
    /** Whether or not this component is using double-buffering.
     *  Only applies to components with Canvas peers, as the
     *  platform is responsible for painting widgets
     */
    public boolean isDoubleBuffered() { return pDoubleBuffered; }
    /** Used to determine whether or not to double buffer the
     *  component. This only has meaning for Canvas peers, and if this
     *  is true, the subclass paint() method will receive a graphics
     *  context for a buffered image to paint on, which will then
     *  be painted onto the component. Otherwise, the paint() method
     *  will receive the component's graphics context to paint on.
     */
    public void setDoubleBuffered(boolean b) { pDoubleBuffered = b; }
    
    /** NOT IMPLEMENTED - used to scroll parent JViewPort containers
      * to the specified rectangle */
    public void scrollRectToVisible(Rectangle aRect) { 
    }
    
    /** Retrieves all client properties (Hashtable) as a Dictionary */
    private Dictionary getClientProperties() {
        if (clientProperties == null) {
            clientProperties = new Hashtable(2);
        }
        return clientProperties;
    }
    
    /** Calls invalidate */
    public void revalidate() { invalidate(); }
    
    /** 
     *  Retrieves a property from the client, or null if
     *  the key does not exist.
     */
    public final Object getClientProperty(Object key) {
    	getClientProperties();
        if (clientProperties == null) {
            return null;
        }
        else {
            return getClientProperties().get(key);
        }
    }
    
    /** 
     *  Not implemented correctly - rather than returning
     *  the visible portion of the component, this returns
     *  a Rectangle sized to match the component
     */
    public swingwt.awt.Rectangle getVisibleRect() {
        return new swingwt.awt.Rectangle(0, 0, getWidth(), getHeight());
    }
    
    /** Sets a property against the component */
    public final void putClientProperty(Object key, Object value) {
    	getClientProperties();
        if (value == null && clientProperties == null) {
            return;
        }
        getClientProperties().put(key, value);
    }
    
    /** NOT IMPLEMENTED */
    public void setMargin(swingwt.awt.Insets i) {}
    
    /** Override in subclass to return something more specific */
    public AccessibleContext getAccessibleContext() {
        return accessibleContext;
    }
    
    /** 
     *  Used to determine whether this component is a top level container
     *  (overriden in subclasses), so validation code knows to work up
     *  the tree to that point before validating down.
     */
    public boolean isValidateRoot() {
        return false;    
    }
    
    /** Always returns true - we're using native widgets! */
    public boolean isOptimizedDrawingEnabled() { 
        return true;
    }
    
    /** NOT IMPLEMENTED */
    public void setNextFocusableComponent(Component acomponent) {
    }

    /** Returns the Insets for the components (taking into account any Border) */
    public Insets getInsets() {
        final Insets insets = new Insets();

        SwingUtilities.invokeSync( new Runnable() {
            public void run() {
                if (border != null) {
                    if (border instanceof AbstractBorder)
                        ((AbstractBorder)border).getBorderInsets(JComponent.this, insets);
                    else {
                        Insets borderInsets = border.getBorderInsets(JComponent.this);
                        insets.left = borderInsets.left;
                        insets.top = borderInsets.top;
                        insets.right = borderInsets.right;
                        insets.bottom = borderInsets.bottom;
                    }
                }
                else {
                    
                    // If we have an unrealised component, return no insets
                    if (!SwingWTUtils.isSWTControlAvailable(composite))
                        return;
                    
                    org.eclipse.swt.graphics.Rectangle rect = composite.getBounds();
                    org.eclipse.swt.graphics.Rectangle client = composite.getClientArea();

                    insets.left = client.x;
                    insets.top = client.y;
                    insets.right = rect.width - client.width - client.x;
                    insets.bottom = rect.height - client.height - client.y;
                }
            }
        });

        return insets;
    }

    
    /**
     * Overridden here - we still use the implementation in the superclass, but
     * we are just checking if we are in a scrollpane container and set the
     * preferred size on that if necessary.
     */
    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
    }

    /** Sets the InputMap for this component */
    public final void setInputMap(int condition, InputMap inputMap) {
        if (condition == WHEN_FOCUSED) { focusInputMap = inputMap; }
        else if (condition == WHEN_ANCESTOR_OF_FOCUSED_COMPONENT) { ancestorInputMap = inputMap; }
        else if (condition == WHEN_IN_FOCUSED_WINDOW) { windowInputMap = inputMap; }
        else { throw new IllegalArgumentException("Illegal InputMap type!"); }
    }

    /** Gets the InputMap for this component */
    public final InputMap getInputMap(int condition, boolean create) {
        InputMap inputMap = null;

        if (condition == WHEN_FOCUSED)
        {
            if (focusInputMap == null && create) focusInputMap = new InputMap();
            if (focusInputMap != null) { inputMap = focusInputMap; }
        }
        else if (condition == WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
        {
            if (ancestorInputMap == null && create) ancestorInputMap = new InputMap();
            if (ancestorInputMap != null) { inputMap = ancestorInputMap; }
        }
        else if (condition == WHEN_IN_FOCUSED_WINDOW)
        {
            if (windowInputMap == null && create) windowInputMap = new InputMap();
            if (windowInputMap != null) { inputMap = windowInputMap; }
        }
        else
        {
            throw new IllegalArgumentException("Illegal InputMap type!");
        }

        return inputMap;
    }
    
    public final void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
    }

    public final ActionMap getActionMap() {
        return getActionMap(true);
    }
    
    private final ActionMap getActionMap(boolean create) {
        ActionMap map = null;
        if (actionMap != null) map = actionMap;
        else if (create) map = new ActionMap();
        
        this.actionMap = map;
        return map;
    }
    
    /** Destroys the component */
    public void dispose() {
	// Use dispose() from Container, which destroys child
	// components and finally the peer itself
        super.dispose();	
    }

     public JRootPane getRootPane() {
	JRootPane rootPane = null;
        Container parent2 = getParent();
        while (parent2 != null) {
            if (parent2 instanceof JRootPane) {
                rootPane = (JRootPane)parent2;
                break;
            }
            parent2 = parent2.getParent();
         }
         return rootPane;
     }
							 

    /**
     * Callback for when this JComponent is added to a container.
     */
    public void setSwingWTParent(Container parent) throws Exception {
	
	// Ensure child components are created where necessary (if
        // this JComponent is a container)
        super.setSwingWTParent(parent);

	// We need to identify whether a subclass is providing it's
	// own peer, and if not, create a Composite peer.
	if (!descendantHasPeer) {
	    ppeer = new org.eclipse.swt.widgets.Composite(parent.getComposite(), 0);
            peer = ppeer;
            this.parent = parent;
        }
    }

}
