/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JDialog.java,v $
   Revision 1.29  2005/01/05 09:22:31  bobintetley
   Updated copyright year on source

   Revision 1.28  2004/09/17 19:15:24  dannaab
   Add SWT custom params to buttons; optimize some imports

   Revision 1.27  2004/05/26 04:46:07  dannaab
   Changed how Window/Dialog/Frame are initialized.
   Now, the SWT peer's instantiation is delayed until setVisible(true).  This
   has the benefit of allowing Swing's setter methods that can only be set via
   the SWT Shell peer's construction (ie, setResizable(), setModel())

   Revision 1.26  2004/04/19 15:43:25  bobintetley
   Missing (and incorrect) Dialog/JDialog constructors implemented

   Revision 1.25  2004/04/16 10:19:06  dannaab
   Misc bug fixes, InputMap implementation, preliminary undo support

   Revision 1.24  2004/03/22 15:10:22  bobintetley
   JRootPane and JLayeredPane implementation

   Revision 1.23  2004/03/18 15:13:22  bobintetley
   Temporary fix to getRootPane()

   Revision 1.22  2004/03/18 14:42:11  bobintetley
   Fix to Window hierarchy to match Swing, and fix to allow MDI apps
      to work under SWT 2.x

   Revision 1.21  2004/02/02 14:40:22  bobintetley
   Non-modal dialogs now work correctly

   Revision 1.20  2004/01/20 15:00:57  bobintetley
   Fixed dialog modality

   Revision 1.19  2004/01/16 09:35:47  bobintetley
   Full event dispatch thread support!

   Revision 1.18  2003/12/17 13:20:58  bobintetley
   Full showInputDialog support and JDialogs can now block correctly

   Revision 1.17  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications

   Revision 1.16  2003/12/15 17:39:11  bobintetley
   Missing implementations completed

   Revision 1.15  2003/12/15 15:54:25  bobintetley
   Additional core methods

   Revision 1.14  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import swingwt.awt.*;

public class JDialog extends swingwt.awt.Dialog implements WindowConstants, RootPaneContainer {
    
    protected int closeOperation = WindowConstants.DISPOSE_ON_CLOSE;
    
    public JDialog() {super(); }
    public JDialog(swingwt.awt.Dialog owner) { super(owner);  }
    public JDialog(swingwt.awt.Dialog owner, boolean modal) { super(owner, modal); }
    public JDialog(swingwt.awt.Dialog owner, String title) { super(owner, title); }
    public JDialog(swingwt.awt.Dialog owner, String title, boolean modal) { super(owner, title, modal); }
    public JDialog(swingwt.awt.Dialog owner, String title, boolean modal, GraphicsConfiguration gc) { super(owner, title, modal, gc); }
    public JDialog(Frame owner) { super(owner);  }
    public JDialog(Frame owner, boolean modal) { super(owner, modal); }
    public JDialog(Frame owner, String title) { super(owner, title); }
    public JDialog(Frame owner, String title, boolean modal) { super(owner, title, modal); }
    public JDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) { super(owner, title, modal, gc); }

    public int getDefaultCloseOperation() {
        return closeOperation;
    }
    
    public void setDefaultCloseOperation(int operation) {
        closeOperation = operation;
    }
    
    public Container getContentPane() {
        return rootPane.getContentPane();
    }
    
    public Component getGlassPane() {
        return rootPane.getGlassPane();
    }
    
    public JLayeredPane getLayeredPane() {
        return rootPane.getLayeredPane();
    }
    
    public JRootPane getRootPane() {
        return rootPane;
    }
    
    public void setContentPane(Container contentPane) {
        rootPane.setContentPane(contentPane);
    }
    
    public void setGlassPane(Component glassPane) {
        rootPane.setGlassPane(glassPane);
    }
    
    public void setLayeredPane(JLayeredPane layeredPane) {
        rootPane.setLayeredPane(layeredPane);
    }
    
    public void registerWindowEvents() {
        
        // Overriden here so we can manage default close operations.
        
        peer.addShellListener(new org.eclipse.swt.events.ShellListener() {
            public void shellActivated(org.eclipse.swt.events.ShellEvent e) {
                processWindowEvent(swingwt.awt.event.WindowEvent.WINDOW_ACTIVATED);
            }
            public void shellClosed(org.eclipse.swt.events.ShellEvent e) {
                isClosed = true;
                processWindowEvent(swingwt.awt.event.WindowEvent.WINDOW_CLOSING);
                processWindowEvent(swingwt.awt.event.WindowEvent.WINDOW_CLOSED);
                // See what's set for the default close operation and handle it
                switch (closeOperation) {
                    case WindowConstants.DISPOSE_ON_CLOSE: e.doit = true; SwingWTUtils.decrementWindowReferences(); break;
                    case WindowConstants.DO_NOTHING_ON_CLOSE: e.doit = false; break;
                    case WindowConstants.EXIT_ON_CLOSE: e.doit = true; SwingWTUtils.decrementWindowReferences(); System.exit(0); break;
                    case WindowConstants.HIDE_ON_CLOSE: e.doit = false; peer.setVisible(false); break;
                }
            }
            public void shellDeactivated(org.eclipse.swt.events.ShellEvent e) {
                processWindowEvent(swingwt.awt.event.WindowEvent.WINDOW_DEACTIVATED);
            }
            public void shellDeiconified(org.eclipse.swt.events.ShellEvent e) {
                processWindowEvent(swingwt.awt.event.WindowEvent.WINDOW_DEICONIFIED);
            }
            public void shellIconified(org.eclipse.swt.events.ShellEvent e) {
                processWindowEvent(swingwt.awt.event.WindowEvent.WINDOW_ICONIFIED);
            }
        });
    }
    
}
