/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: EditorPane.java,v $
   Revision 1.3  2005/02/16 08:34:36  bobintetley
   JFileChooser.showDialog support, JOptionPane instance support (no dialog creation at present), JSplitPane.getDividerLocation(), PixelGrabber.grabPixels(ms) throws InterruptedException, swingwtx.swing.MenuElement implemented, with JMenu* implementors, JPopupMenu.getSubElements(), JMenuBar.getSubElements(), JMenu.getSubElements()

   Revision 1.2  2005/01/05 09:22:33  bobintetley
   Updated copyright year on source

   Revision 1.1  2004/10/29 10:24:07  bobintetley
   Separate EditorPane implementations to decouple platform specifics,
   stubbing of HTMLEditorKit



*/

package swingwtx.swing.editorpanes;

import swingwtx.swing.text.*;
import swingwtx.swing.JComponent;
import swingwt.awt.Color;
import java.net.*;
import java.io.*;
import org.eclipse.swt.widgets.Control;

/**
 * Some distributions of Free OSes don't like the reliance on
 * Mozilla that use of the browser component brings (well, Debian
 * so far), so this interface allows us to abstract away the
 * implementation of the editorpane.
 *
 * This works well for us since we use a StyledText for editable
 * content anyway.
 *
 * @author  Robin Rawson-Tetley
 *
 */
public interface EditorPane {
  
    void setSwingWTParent(swingwt.awt.Container parent) throws Exception;
    swingwt.awt.Dimension calculatePreferredSize();
    String getText();
    void setText(String text);
    String getContentType();
    void setContentType(String contentType);
    boolean isEditable();
    void setEditable(boolean b);
    public void setDocument(Document newdoc);
    public Document getDocument();
    void setPage(URL url) throws IOException;
    void setPage(String url) throws IOException;
    void addHyperlinkListener(swingwtx.swing.event.HyperlinkListener l);
    void removeHyperlinkListener(swingwtx.swing.event.HyperlinkListener l);
    void setCaretPosition(int pos);
    int getCaretPosition();
    int getSelectionStart();
    int getSelectionEnd();
    EditorKit getEditorKit();
    void setEditorKit(EditorKit k);
    void setSelectionColor(Color color);
    Color getSelectionColor();
    void scrollToReference(String reference);
    Control getSWTPeer();
    JComponent getJComponent();
}
