/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: TableColumn.java,v $
   Revision 1.10  2005/01/05 09:22:36  bobintetley
   Updated copyright year on source

   Revision 1.9  2004/05/25 01:04:12  dannaab
   Misc bugfixes, ActionMap.java added, added swt source to lib dir (for debugging
   purposes), misc import optimization

   Revision 1.8  2004/04/16 14:39:03  bobintetley
   Table and Tree cell editor support

   Revision 1.7  2004/04/16 10:19:07  dannaab
   Misc bug fixes, InputMap implementation, preliminary undo support

   Revision 1.6  2004/02/02 09:33:39  bobintetley
   Fixed broken TableColumn constructors

   Revision 1.5  2003/12/17 10:57:35  bobintetley
   JTableHeader implementation plus Table event/model fixes

   Revision 1.4  2003/12/15 16:40:05  bobintetley
   Core methods + skeleton JTableHeader/JScrollBar support

   Revision 1.3  2003/12/14 09:13:39  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing.table;

public class TableColumn {

    protected TableCellRenderer cellRenderer = null;
    protected TableCellRenderer headerRenderer = null;
    private int idx = 0;
    private int width = 0;
    private int maxWidth = 0;
    private int minWidth = 0;
    private int preferredWidth = 0;
    private boolean resizable = true;
    private Object headerValue = null;
    private Object identifier = null;
    private TableCellEditor tableCellEditor = null;

    public TableColumn() {}
    public TableColumn(int index) { idx = index; }
    public TableColumn(int index, int width) { idx = index; this.width = width; }
    public TableColumn(int index, int width, TableCellRenderer renderer, TableCellEditor editor) { idx = index; this.width = width; cellRenderer = renderer; tableCellEditor = editor;}


    public void setCellRenderer(TableCellRenderer newrenderer) {
        cellRenderer = newrenderer;
    }

    public TableCellRenderer getCellRenderer() {
        return cellRenderer;
    }

    /** Not implemented - any reason to? */
    public void setHeaderRenderer(TableCellRenderer headerRenderer) {
        this.headerRenderer = headerRenderer;
    }

    public TableCellRenderer getHeaderRenderer() {
        return headerRenderer;
    }

    public int getModelIndex() {
        return idx;
    }

    public void setModelIndex(int index) {
        idx = index;
    }

    public java.lang.Object getHeaderValue() {
        return headerValue;
    }
    public void setHeaderValue(java.lang.Object headerValue) {
        this.headerValue = headerValue;
    }

    public java.lang.Object getIdentifier() {
        return (identifier == null) ? getHeaderValue() : identifier;
    }
    public void setIdentifier(java.lang.Object identifier) {
        this.identifier = identifier;
    }

    public int getMaxWidth() {
        return maxWidth;
    }

    /** Setter for property maxWidth.
     * @param maxWidth New value of property maxWidth.
     *
     */
    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMinWidth() {
        return minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getPreferredWidth() {
        return preferredWidth;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public boolean isResizable() {
        return resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public TableCellEditor getCellEditor() {
        return tableCellEditor;
    }
    
    public void setCellEditor(TableCellEditor tableCellEditor) {
        this.tableCellEditor = tableCellEditor;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

}
