/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Caret.java,v $
   Revision 1.3  2005/01/05 09:22:36  bobintetley
   Updated copyright year on source

   Revision 1.2  2004/10/30 20:11:58  bobintetley
   Code cleanup

   Revision 1.1  2004/03/18 16:21:37  bobintetley
   JTextComponent/Caret implementation and fix to JFileChooser for bug in GNU classpath


*/

package swingwtx.swing.text;

import swingwt.awt.*;
import swingwtx.swing.event.*;

public interface Caret {
    public void install(JTextComponent c);
    public void deinstall(JTextComponent c);
    public void paint(Graphics g);
    public void addChangeListener(ChangeListener l);
    public void removeChangeListener(ChangeListener l);
    public boolean isVisible();
    public void setVisible(boolean v);
    public boolean isSelectionVisible();
    public void setSelectionVisible(boolean v);
    public void setMagicCaretPosition(Point p);
    public Point getMagicCaretPosition();
    public void setBlinkRate(int rate);
    public int getBlinkRate();
    public int getDot();
    public int getMark();
    public void setDot(int dot);
    public void moveDot(int dot);
}