/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: DefaultTreeCellRenderer.java,v $
   Revision 1.13  2005/01/11 16:40:18  bobintetley
   Code cleanup around pixmaps

   Revision 1.12  2005/01/05 09:22:36  bobintetley
   Updated copyright year on source

   Revision 1.11  2005/01/05 08:37:15  bobintetley
   Many compatibility fixes from David Barron

   Revision 1.10  2004/11/05 11:31:51  bobintetley
   getPixmap() variant that uses Class context and relative resources (Shaun Jackman)

   Revision 1.9  2004/11/04 20:49:18  bobintetley
   Relative resources breaks under Sun VMs. Gone back to the getPixmap() method

   Revision 1.8  2004/11/04 20:24:21  bobintetley
   Whoops, should at least compile before checkin :)

   Revision 1.7  2004/11/04 20:16:04  bobintetley
   Relative image resources and moved filechooser images into swingwtx.swing

   Revision 1.6  2004/11/04 10:27:03  bobintetley
   getPixmap() call to look for images on the filesystem or as a classpath
      resource.

   Revision 1.5  2004/05/05 12:43:22  bobintetley
   Patches/new files from Laurent Martell

   Revision 1.4  2004/04/15 13:23:03  bobintetley
   Default JTree images in cell renderer for folder/doc like Swing

   Revision 1.3  2003/12/14 09:13:39  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing.tree;

import swingwtx.swing.*;
import swingwt.awt.*;

public class DefaultTreeCellRenderer extends JLabel implements TreeCellRenderer {
    
    protected boolean hasFocus;
    protected boolean selected;
    
    public Component getTreeCellRendererComponent(swingwtx.swing.JTree tree, 
            Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
         
         this.hasFocus = hasFocus;
         this.selected = selected;
                
         // Default tree images
         if (leaf)
             if (expanded)
                setIcon(openIcon);
             else
                setIcon(closedIcon);
         else
             setIcon(leafIcon);
         
         setText(value.toString());
         return this;
    }
    
    public Color getTextSelectionColor() { return SystemColor.controlHighlight; }
    public Color getTextNonSelectionColor() { return SystemColor.controlText; }

    Icon leafIcon = SwingWTUtils.getPixmap(DefaultTreeCellRenderer.class, "doc.gif");
    Icon openIcon = SwingWTUtils.getPixmap(DefaultTreeCellRenderer.class, "folderopen.gif");
    Icon closedIcon = SwingWTUtils.getPixmap(DefaultTreeCellRenderer.class, "folder.gif");
	    
    public Icon getLeafIcon() { return leafIcon; }
    public Icon getOpenIcon() { return openIcon; }
    public Icon getClosedIcon() { return closedIcon; }

    public void setLeafIcon(Icon icon) { leafIcon = icon; }
    public void setOpenIcon(Icon icon) { openIcon = icon; }
    public void setClosedIcon(Icon icon) { closedIcon = icon; }

}
