/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#include "aplist.h"

APList::APList()
{
	//mut.lock();
		max=512;
		last=0;
		list = new APEntry*[max];
	//mut.unlock();
	if (list == NULL ) ErrorMem();
}

APList::~ APList()
{
	//mut.lock(); 
	delete [] list; 
	//mut.unlock(); 
	qDebug("Deleting aplist..."); 	
}


void APList::ErrorMem()
{
	std::cerr << "APList: Not enough memory\n";
	exit (1);	
}

APEntry &APList::operator[] (int i)
{
	return *list[i];
}

bool APList::AddNew(APEntry *ap)
{
	if (last == max)
	{
		cerr << "APList: the list is full";
		return false;
	}
	//mut.lock();
		list[last]=ap;	//call to APEntry::operator=
		last ++;
		//if (!isInList(ap)) last++;
	//mut.unlock();
	return true;
}

bool APList::isInList(APEntry *ap)
{
	char temp[255];
	for (int i=0;i < last;i++)
		if (strcmp(list[i]->getMAC(temp),ap->getMAC(temp))==0)
			return true;
	return false;
}
void APList::Display()
{
	char temp [255];
	cout << "AP's encontrados: " << endl;
	for (int i=0;i < last;i++)
	{
		cout << "ESSID: " << list[i]->getEssid(temp) << endl;
		cout << "  MAC: " << list[i]->getMAC(temp) << endl;
		cout << "  CHA: " << list[i]->getChannel() << endl;
		cout << "  MOD: " << list[i]->getModeString() << endl;
		cout << "  SIG: " << list[i]->getSignal() << endl;
		cout << "  NOI: " << list[i]->getNoise() << endl;
	}
}

void APList::Drop()
{
	//mut.lock();
	for (int i=0;i < last ; i++)
		delete list[i];
	last=0;
	//mut.unlock();
}

