/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "frmutils.h"

frmUtils::frmUtils(QWidget* parent, const char* name, bool modal, WFlags fl)
                : dlgUtils(parent,name, modal,fl)
{
	buttonCancel->setIconSet(BarIcon("button_cancel"));
	buttonGo->setIconSet(BarIcon("button_ok"));
}

frmUtils::~frmUtils()
{}

/*$SPECIALIZATION$*/
void frmUtils::FindDest()
{
	txtDest->setText(QFileDialog::getSaveFileName(
        	QDir::homeDirPath(),
        	i18n("SWScanner ESRI ShapeFiles (*.shp *.shx *.dbf)"),
        	this,
        	i18n("Save file dialog"),
        	i18n("Choose a filename to save under (file extension is not needed)")));
}

void frmUtils::FindSource()
{
	QString type;
	switch(cmbType->currentItem())
	{
		case 0: type = i18n("SWScanner GPS Log files (*.swl)"); break;
		case 1: type = i18n("NetStumbler summary files (*.nss)"); break;
		case 2: type = i18n("SWScanner ESRI ShapeFiles (*.shp)"); break;
	}

	txtSource->setText(QFileDialog::getOpenFileName(
        	QDir::homeDirPath(),
        	type,
        	this,
        	i18n("Open file dialog"),
        	i18n("Choose a filename to open")));
}


void frmUtils::TypeChanged(int i)
{
	switch (i)
	{
		case 0: 
			lblSource->setText(i18n("Select a SWScanner GPS Log file (NetStumbler txt log compatible):")); 
			lblDest->setText(i18n("Select the destination ESRI Shapefile (.shp, .dbf or .dbx):")); 
			break;
		case 1:
			lblSource->setText(i18n("Select a NetStumbler summary file:")); 
			lblDest->setText(i18n("Select the destination ESRI Shapefile (.shp, .dbf or .dbx):")); 
			break;			
	}
}

void frmUtils::accept()
{
	QFile source, dest;

	if ( txtSource->text() == "" || txtDest->text() == "") 
	{
		QMessageBox::information( this, i18n("SWScanner"), i18n("It's needed to select both source and destination files."));
		return;
	}
	
	source.setName(txtSource->text());
	dest.setName(txtDest->text());
	
	switch(cmbType->currentItem())
	{
		case 0: swlTOshp(&source, &dest); break;
		case 1: nssTOshp(&source, &dest); break;
	}

}

void frmUtils::swlTOshp(QFile * source, QFile * dest)
{
	source->open(IO_ReadOnly);
	QTextStream stream(source);
	ShapeHandler * shpDest = new ShapeHandler;
	QString line, aux, shapeName = dest->name();
	APEntry ap;
	int i=0, k=0;
	long nlin=0;
	double lati=0, longi=0;
	
	lblInfo->setText(i18n("Converting... it may need several minutes:"));
	if (dest->exists())
		if( QMessageBox::question(
					0,
					i18n("SWScanner"),
					i18n("A file called %1 already exists. Do you want to overwrite it?\n").arg( shapeName ),
					i18n("&Yes"), i18n("&No"),
					QString::null, 0, 1 ) )	
			return;	// only continue if user select yes

	// delete the file extension (not needed)
	if ((shapeName.right(4) == ".shp") || (shapeName.right(4) == ".shx") || (shapeName.right(4) == ".dbf"))
	{
		shapeName.truncate(shapeName.length()-4);
		dest->setName(shapeName);
	}						
	shpDest->createShapefile((char *)dest->name().ascii());
	while ( !stream.atEnd() )
	{
		line = stream.readLine();
		nlin++;
	}

	source->at(0);
	progressBar1->reset();
	progressBar1->setTotalSteps(100);

	// Read the file line by line:
	while ( !stream.atEnd() ) 
	{
		line = stream.readLine(); // line of text excluding '\n'
		k=0;
		if (line.left(1) != "#")
		{
			QStringList data = data.split("\t",line,TRUE);
			for ( QStringList::Iterator it = data.begin(); it != data.end(); ++it)
			{
				// qDebug(QString(*it));
				aux=(*it);
				switch (k)
				{
					case 0: lati=QVariant(aux.right(aux.length()-2)).toDouble(); 
						if (aux.left(1) == "S") lati = -lati;	// lati is northern
						break;
					case 1: longi=QVariant(aux.right(aux.length()-2)).toDouble(); 
						if (aux.left(1) == "W") longi = -longi;	// longi is easting
						break;
					case 2: ap.setEssid((char *)(*it).mid(2,(*it).length()-4).ascii()); break;
					case 4: ap.setMAC((char *)(*it).mid(2,17).upper().ascii()); break;
					case 3: ap.setMode((*it)=="BSS"?0:1); break;
					case 6: 
					{
						QStringList sig = sig.split(" ",(*it),TRUE);
						QStringList::Iterator it2 = sig.begin();
						it2+=2; ap.setSignal(QVariant((*it2)).toInt()-149);
						it2++;  ap.setNoise(QVariant((*it2)).toInt()-149);
						break;
					}
					case 8:  // Flags
					{
						if ((*it).toInt(0,16) & 0x10)
							ap.setWEP(TRUE);
						else
							ap.setWEP(FALSE);
						break;
					}
					case 9: // ChannelBits
					{
						ap.setChannel( ((*it).toLong(0,16) & 0x2)? 1 : 0 );
						ap.setChannel( ((*it).toLong(0,16) & 0x4)? 2 : 0 );
						ap.setChannel( ((*it).toLong(0,16) & 0x8)? 3 : 0 );
						ap.setChannel( ((*it).toLong(0,16) & 0x10)? 4 : 0 );
						ap.setChannel( ((*it).toLong(0,16) & 0x20)? 5 : 0 );
						ap.setChannel( ((*it).toLong(0,16) & 0x40)? 6 : 0  );
						ap.setChannel( ((*it).toLong(0,16) & 0x80)? 7 : 0  );
						ap.setChannel( ((*it).toLong(0,16) & 0x100)? 8  : 0 );
						ap.setChannel( ((*it).toLong(0,16) & 0x200)? 9  : 0 );
						ap.setChannel( ((*it).toLong(0,16) & 0x400)? 10  : 0 );
						ap.setChannel( ((*it).toLong(0,16) & 0x800)? 11 : 0  );
						ap.setChannel( ((*it).toLong(0,16) & 0x1000)? 12 : 0  );
						ap.setChannel( ((*it).toLong(0,16) & 0x2000)? 13 : 0  );
						ap.setChannel( ((*it).toLong(0,16) & 0x4000)? 14 : 0  );
						break;
					}	
				}
				k++;
				if (lati == 0 || (longi == 0 && k > 1)) break;	// avoid fake registers processing
			}
			if (lati == 0 || longi == 0) continue;	// avoid fake registers storing
			shpDest->newData(&ap, longi, lati);
			i++;
			progressBar1->setProgress(i*100/nlin);
		}
        }
	lblInfo->setText("");
	progressBar1->setProgress(100);
	delete shpDest;
	source->close();
	QMessageBox::information(this, i18n("SWScanner"), i18n("Conversion successfully finished."));
}

void frmUtils::nssTOshp(QFile * source, QFile * dest)
{
	swlTOshp(source,dest);
}

#include "frmutils.moc"

