/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "swsconfig.h"

SWSconfig::SWSconfig()
{
	cfg = KGlobal::config();
	qDebug ("Creating SWSconfig...");
}
SWSconfig::~SWSconfig()
{
	cfg->sync();
	qDebug ("Deleting SWSconfig...");
}

// *************************************
// ********** SERIAL SETTINGS **********
// *************************************
void SWSconfig::setSerialDev (QString s)
{
	cfg->setGroup("Serial Settings");
	cfg->writeEntry("SerialDev",s);
}
QString SWSconfig::getSerialDev ()
{
	cfg->setGroup("Serial Settings");
	return cfg->readEntry("SerialDev","/dev/ttyS0");
}
void SWSconfig::setBaud (int b) 
{
	cfg->setGroup("Serial Settings");
	cfg->writeEntry("Baud",b);
}
int SWSconfig::getBaud()
{
	cfg->setGroup("Serial Settings");
	return cfg->readNumEntry("Baud", 9600);
}
void SWSconfig::setDataBits (int d) 
{
	cfg->setGroup("Serial Settings");
	cfg->writeEntry("DataBits", d);
}
int SWSconfig::getDataBits ()
{
	cfg->setGroup("Serial Settings");
	return cfg->readNumEntry("DataBits", 8);
}
void SWSconfig::setStopBits (int s) 
{
	cfg->setGroup("Serial Settings");
	cfg->writeEntry("StopBits", s);
}
int SWSconfig::getStopBits ()
{
	cfg->setGroup("Serial Settings");
	return cfg->readNumEntry("StopBits", 1);
}
void SWSconfig::setParity (QString p) 
{
	cfg->setGroup("Serial Settings");
	cfg->writeEntry("Parity", p);
}
QString SWSconfig::getParity ()
{
	cfg->setGroup("Serial Settings");
	return cfg->readEntry("Parity", "N");
}

// *************************************
// ********* GENERAL SETTINGS **********
// *************************************
void SWSconfig::setDhclient (QString d)
{
	cfg->setGroup("General Settings");
	cfg->writeEntry("DhClient", d);
	
}
QString SWSconfig::getDhclient ()
{
	cfg->setGroup("General Settings");
	return cfg->readEntry("DhClient", "/sbin/dhclient");
}
void SWSconfig::setDefIface (QString i)
{
	cfg->setGroup("General Settings");
	cfg->writeEntry("DefIface", i);
}
QString SWSconfig::getDefIface ()
{
	cfg->setGroup("General Settings");
	return cfg->readEntry("DefIface", "lo");
}
void SWSconfig::setStartScanning (bool s)
{
	cfg->setGroup("General Settings");
	cfg->writeEntry("StartScanning", s);
}
bool SWSconfig::getStartScanning()
{
	cfg->setGroup("General Settings");
	return cfg->readBoolEntry("StartScanning", false);
}
void SWSconfig::setTerminal (QString d)
{
	cfg->setGroup("General Settings");
	cfg->writeEntry("x-terminal", d);
	
}
QString SWSconfig::getTerminal ()
{
	cfg->setGroup("General Settings");
	return cfg->readEntry("x-terminal", "/usr/bin/X11/xterm");
}
void SWSconfig::setUseTerminal (bool s)
{
	cfg->setGroup("General Settings");
	cfg->writeEntry("use-x-terminal", s);
}
bool SWSconfig::getUseTerminal()
{
	cfg->setGroup("General Settings");
	return cfg->readBoolEntry("use-x-terminal", true);
}