	/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef APLIST_H
#define APLIST_H

#include "apentry.h"

#include <qmutex.h>
#include <qptrlist.h>

#include <stdio.h>
#include <iostream>

using namespace std;

class APList : public QPtrList<APEntry>
{
private:
	QMutex mut;
	
public:
	APList();
	~APList();

	void Display();				//dump list contents to stdout
	bool isInList (APEntry *);
	bool isInList (char * mac);
	void lock() { mut.lock(); };		//lock the mutex
	void unlock() { mut.unlock(); };	//unlock the mutex
// 	APEntry * findByMAC(char * mac);	//search by mac
	void addOrUpdateIfExists(APEntry * ap);

protected:
	virtual int compareItems( QPtrCollection::Item, QPtrCollection::Item );
};

#endif
