//
// C++ Implementation: treefilterlistview
//
// Description: 
//
//
// Author: Ivn Forcada Atienza <ivan@swscanner.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "treefilterlistview.h"

TreeFilterListView::TreeFilterListView(QWidget * parent, const char * name, WFlags f)
	: QListView(parent, name, f)
{
	setSelectionMode(QListView::Single);
	header()->setLabel( 0, "  " + i18n( "Filter" ) );
	clear();
	addColumn( "  " + i18n( "Filter" ) );
	header()->setLabel( header()->count() - 1, SmallIcon("filter"), "  " + i18n( "Filter" ) );
	setMinimumSize( QSize( 180, 140 ) );
	setMaximumSize( QSize( 175, 32767 ) );

	QListViewItem * root = new QListViewItem( this, 0 );
	root->setText( 0, "/" );		
	root->setOpen( TRUE );
	QListViewItem * branch = new QListViewItem( root, 0 );
	branch->setText( 0, i18n( "CHANNEL" ) );
	branch->setPixmap( 0, SmallIcon("flag") );
	branch = new QListViewItem( root, branch );
	branch->setText( 0, i18n( "ESSID" ) );
	branch->setPixmap( 0, SmallIcon("flag") );
	branch = new QListViewItem( root, branch );
	branch->setText( 0, i18n( "MAC" ) );
	branch->setPixmap( 0, SmallIcon("flag") );
	branch = new QListViewItem( root, branch );
	branch->setText( 0, i18n( "WEP" ) );
	branch->setPixmap( 0, SmallIcon("flag") );
	tblScan = 0;
}

QListView * TreeFilterListView::Table()
{
	if (tblScan)
		return tblScan;
	else
	{
		tblScan = (AccessPointListView*) parentWidget()->child("tblScan");
		return tblScan;
	}
}

bool TreeFilterListView::passTheFilter(QListViewItem * it)
{
        QListViewItem * sel = selectedItem();
	AccessPointListView * table = (AccessPointListView *) Table();
	
        if (sel == 0)
                return true;	// There's no filter selected

	// Top-level nodes doesn't filter anything
        if (sel->key(0,true) == i18n("MAC"))
                return true;
        if (sel->key(0,true) == i18n("ESSID"))
                return true;
        if (sel->key(0,true) == i18n("CHANNEL"))
                return true;
        if (sel->key(0,true) == i18n("WEP"))
                return true;		
        if (sel->key(0,true) == QString("/"))
                return true;

        if (sel->parent()->key(0,true) == i18n("MAC"))   //filter by MAC
        {
                if (sel->key(0,true) == it->text(table->getCol(i18n("MAC"))))
                        return true;	//this mac is the one filtered
        } else if (sel->parent()->key(0,true) == i18n("ESSID"))   //filter by Essid
        {
                if (sel->key(0,true) == it->text(table->getCol(i18n("ESSID"))))
                        return true;	//this essid is the one filtered
        } else if (sel->parent()->key(0,true) == i18n("CHANNEL"))   //filter by channel
        {
                if (sel->key(0,true) == it->text(table->getCol(i18n("CHANNEL"))))
                        return true;	//this channel is the one filtered
        } else if (sel->parent()->key(0,true) == i18n("WEP"))   //filter by wep
        {
                if (sel->key(0,true) == it->text(table->getCol(i18n("WEP"))))
                        return true;	//this wep mode is the one filtered
        }

        return false;
}

void TreeFilterListView::deleteChildren (QListViewItem * parentNode)
{
        QListViewItem * myChild = parentNode->firstChild();
        QListViewItem * aux;

        while (myChild) {
                aux = myChild;
                myChild = myChild->nextSibling();
                delete aux;
        }
}

void TreeFilterListView::clear()
{
	QListViewItem * item;
        
	item=findItem(i18n("MAC"),0);
        if (item) deleteChildren(item);
        item=findItem(i18n("ESSID"),0);
        if (item) deleteChildren(item);
        item=findItem(i18n("CHANNEL"),0);
        if (item) deleteChildren(item);
	item=findItem(i18n("WEP"),0);
	if (item) deleteChildren(item);
}

